/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.async;

import com.mchange.v2.async.AsynchronousRunner;
import com.mchange.v2.async.Queuable;
import com.mchange.v2.async.RunnableQueue;
import com.mchange.v2.async.SimpleRunnableQueue;

public class RoundRobinAsynchronousRunner
implements AsynchronousRunner,
Queuable {
    final RunnableQueue[] rqs;
    int task_turn = 0;
    int view_turn = 0;

    public RoundRobinAsynchronousRunner(int n) {
        this(n, true);
    }

    public RoundRobinAsynchronousRunner(int n, boolean bl) {
        this.rqs = new RunnableQueue[n];
        int n2 = 0;
        while (n2 < n) {
            this.rqs[n2] = new SimpleRunnableQueue(bl);
            ++n2;
        }
    }

    public synchronized void postRunnable(Runnable runnable) {
        this.rqs[this.task_turn++].postRunnable(runnable);
        this.task_turn %= this.rqs.length;
    }

    public synchronized RunnableQueue asRunnableQueue() {
        RunnableQueueView runnableQueueView = new RunnableQueueView(this.view_turn++);
        this.view_turn %= this.rqs.length;
        return runnableQueueView;
    }

    public void close(boolean bl) {
        int n = 0;
        int n2 = this.rqs.length;
        while (n < n2) {
            this.rqs[n].close(bl);
            this.rqs[n] = null;
            ++n;
        }
    }

    public void close() {
        this.close(true);
    }

    class RunnableQueueView
    implements RunnableQueue {
        final int rq_num;

        RunnableQueueView(int n) {
            this.rq_num = n;
        }

        public void postRunnable(Runnable runnable) {
            RoundRobinAsynchronousRunner.this.rqs[this.rq_num].postRunnable(runnable);
        }

        public void close(boolean bl) {
        }

        public void close() {
        }
    }
}

