/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.sitemesh.filter;

import com.opensymphony.module.sitemesh.Config;
import com.opensymphony.module.sitemesh.Factory;
import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.module.sitemesh.PageParser;
import com.opensymphony.module.sitemesh.filter.PageOutputStream;
import com.opensymphony.module.sitemesh.filter.WriterResponse;
import com.opensymphony.module.sitemesh.util.Container;
import java.io.IOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public final class PageResponse
extends WriterResponse {
    private PageOutputStream pageOutputStream = null;
    private Config config = null;
    private Page page = null;
    private String contentType = null;
    private String encoding = null;
    private boolean aborted = false;
    private boolean parseablePage = false;
    private long lastModified;

    public PageResponse(HttpServletResponse httpServletResponse, Config config) throws IOException {
        super(httpServletResponse);
        this.config = config;
    }

    public void setContentType(String string) {
        int n = -1;
        try {
            n = string.lastIndexOf(61);
            if (n != -1) {
                this.encoding = string.substring(n + 1).trim();
            }
            this.contentType = (n = string.indexOf(59)) > 0 ? string.substring(0, n) : string;
            super.setContentType(string);
            this.getOutputStream();
            if (Factory.getInstance(this.config).shouldParsePage(this.contentType)) {
                this.parseablePage = true;
            } else {
                this.pageOutputStream.discardBuffer();
                this.parseablePage = false;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void setContentLength(int n) {
        if (!this.parseablePage()) {
            super.setContentLength(n);
        }
    }

    public void setDateHeader(String string, long l) {
        if (this.parseablePage() && "Last-Modified".equalsIgnoreCase(string)) {
            this.lastModified = l;
        } else {
            super.setDateHeader(string, l);
        }
    }

    public void setStatus(int n) {
        if (n == 304) {
            if (!this.parseablePage()) {
                super.setStatus(n);
            }
        } else {
            super.setStatus(n);
        }
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.pageOutputStream == null) {
            this.pageOutputStream = new PageOutputStream(super.getOutputStream());
        }
        return this.pageOutputStream;
    }

    public void closeStream() throws IOException {
        if (this.parseablePage()) {
            try {
                super.getOutputStream().flush();
            }
            catch (IOException iOException) {
                if (Container.get() == 1) {
                    return;
                }
                throw iOException;
            }
        }
    }

    public boolean parseablePage() {
        return this.parseablePage;
    }

    public Page getPage() throws IOException {
        if (this.contentType == null) {
            this.getOutputStream();
            this.pageOutputStream.discardBuffer();
        }
        if (this.aborted || !this.parseablePage()) {
            return null;
        }
        if (this.page == null) {
            Factory factory = Factory.getInstance(this.config);
            PageParser pageParser = factory.getPageParser(this.contentType);
            this.getOutputStream();
            this.getWriter().flush();
            return pageParser.parse(this.pageOutputStream.getBuffer(), this.encoding);
        }
        return this.page;
    }

    public void sendError(int n) throws IOException {
        this.aborted = true;
        super.sendError(n);
    }

    public void sendError(int n, String string) throws IOException {
        this.aborted = true;
        super.sendError(n, string);
    }

    public void sendRedirect(String string) throws IOException {
        this.aborted = true;
        super.sendRedirect(string);
    }
}

