/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.remoting;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jboss.seam.Component;
import org.jboss.seam.annotations.WebRemote;
import org.jboss.seam.remoting.CallContext;
import org.jboss.seam.remoting.wrapper.ConversionException;
import org.jboss.seam.remoting.wrapper.ConversionScore;
import org.jboss.seam.remoting.wrapper.Wrapper;

public class Call {
    private String id;
    private String componentName;
    private String methodName;
    private List<Wrapper> params = new ArrayList<Wrapper>();
    private Object result;
    private CallContext context;

    public Call(String id, String componentName, String methodName) {
        this.id = id;
        this.componentName = componentName;
        this.methodName = methodName;
        this.context = new CallContext();
    }

    public CallContext getContext() {
        return this.context;
    }

    public void addParameter(Wrapper param) {
        this.params.add(param);
    }

    public Object getResult() {
        return this.result;
    }

    public String getId() {
        return this.id;
    }

    public void execute() throws Exception {
        Method m;
        Component component = Component.forName(this.componentName);
        if (component == null) {
            throw new RuntimeException("No such component: " + this.componentName);
        }
        Object instance = Component.getInstance(this.componentName, true);
        Class<?> type = component.getLocalInterfaces().iterator().next();
        if (type == null) {
            type = component.getBeanClass();
        }
        if ((m = this.findMethod(this.methodName, type)) == null) {
            throw new RuntimeException("No compatible method found.");
        }
        this.result = m.invoke(instance, this.convertParams(m.getGenericParameterTypes()));
    }

    private Object[] convertParams(Type[] targetTypes) throws ConversionException {
        Object[] paramValues = new Object[targetTypes.length];
        for (int i = 0; i < targetTypes.length; ++i) {
            paramValues[i] = this.params.get(i).convert(targetTypes[i]);
        }
        return paramValues;
    }

    private Method findMethod(String name, Class cls) {
        HashMap<Method, Integer> candidates = new HashMap<Method, Integer>();
        for (Method m : cls.getDeclaredMethods()) {
            if (m.getAnnotation(WebRemote.class) == null || !name.equals(m.getName()) || m.getParameterTypes().length != this.params.size()) continue;
            int score = 0;
            for (int i = 0; i < m.getParameterTypes().length; ++i) {
                ConversionScore convScore = this.params.get(i).conversionScore(m.getParameterTypes()[i]);
                if (convScore == ConversionScore.nomatch) continue;
                score += convScore.getScore();
            }
            candidates.put(m, score);
        }
        Method bestMethod = null;
        int bestScore = 0;
        for (Method m : candidates.keySet()) {
            int thisScore = (Integer)candidates.get(m);
            if (bestMethod != null && thisScore <= bestScore) continue;
            bestMethod = m;
            bestScore = thisScore;
        }
        return bestMethod;
    }
}

