/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.jsf;

import java.util.Map;
import java.util.Set;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.model.DataModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.contexts.Session;
import org.jboss.seam.core.FacesMessages;
import org.jboss.seam.core.Init;
import org.jboss.seam.core.Manager;
import org.jboss.seam.core.Pageflow;
import org.jboss.seam.core.Pages;

public class SeamPhaseListener
implements PhaseListener {
    private static final Log log = LogFactory.getLog(SeamPhaseListener.class);

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }

    public void beforePhase(PhaseEvent event) {
        log.trace((Object)("before phase: " + event.getPhaseId()));
        Lifecycle.setPhaseId(event.getPhaseId());
        FacesContext facesContext = event.getFacesContext();
        if (event.getPhaseId() == PhaseId.RESTORE_VIEW) {
            Lifecycle.beginRequest(facesContext.getExternalContext());
        } else if (event.getPhaseId() == PhaseId.RENDER_RESPONSE) {
            this.callPageActions(event);
            FacesMessages.instance().beforeRenderResponse();
            Manager.instance().prepareBackswitch(event);
            if (facesContext.getResponseComplete()) {
                SeamPhaseListener.beforeSaveState(facesContext);
                Lifecycle.endRequest(facesContext.getExternalContext());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callPageActions(PhaseEvent event) {
        Lifecycle.setPhaseId(PhaseId.INVOKE_APPLICATION);
        boolean actionsWereCalled = false;
        try {
            actionsWereCalled = this.callAction(event.getFacesContext()) || actionsWereCalled;
            actionsWereCalled = Pages.instance().callAction() || actionsWereCalled;
        }
        finally {
            Lifecycle.setPhaseId(PhaseId.RENDER_RESPONSE);
            if (actionsWereCalled) {
                FacesMessages.afterPhase();
                this.afterPageActions();
            }
        }
    }

    protected void afterPageActions() {
    }

    private boolean callAction(FacesContext facesContext) {
        String action;
        String outcome;
        boolean result = false;
        String fromAction = outcome = (String)facesContext.getExternalContext().getRequestParameterMap().get("actionOutcome");
        if (outcome == null && (action = (String)facesContext.getExternalContext().getRequestParameterMap().get("actionMethod")) != null) {
            String expression = "#{" + action + "}";
            if (!this.isActionAllowed(facesContext, expression)) {
                return result;
            }
            result = true;
            MethodBinding actionBinding = facesContext.getApplication().createMethodBinding(expression, null);
            outcome = (String)actionBinding.invoke(facesContext, null);
            fromAction = expression;
        }
        if (outcome != null) {
            facesContext.getApplication().getNavigationHandler().handleNavigation(facesContext, fromAction, outcome);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isActionAllowed(FacesContext facesContext, String expression) {
        Map applicationMap = facesContext.getExternalContext().getApplicationMap();
        Set actions = (Set)applicationMap.get("org.jboss.seam.actions");
        if (actions == null) {
            return false;
        }
        Set set = actions;
        synchronized (set) {
            return actions.contains(expression);
        }
    }

    public void afterPhase(PhaseEvent event) {
        log.trace((Object)("after phase: " + event.getPhaseId()));
        FacesContext facesContext = event.getFacesContext();
        if (event.getPhaseId() == PhaseId.RESTORE_VIEW) {
            SeamPhaseListener.restoreAnyConversationContext(event);
        }
        FacesMessages.afterPhase();
        if (event.getPhaseId() == PhaseId.RENDER_RESPONSE) {
            if (!Init.instance().isClientSideConversations()) {
                Manager.instance().conversationTimeout(facesContext.getExternalContext());
            }
            Lifecycle.endRequest(facesContext.getExternalContext());
        } else if (event.getPhaseId() != PhaseId.RESTORE_VIEW && facesContext.getResponseComplete()) {
            SeamPhaseListener.beforeSaveState(facesContext);
            Lifecycle.endRequest(facesContext.getExternalContext());
        }
        Lifecycle.setPhaseId(null);
    }

    static void beforeSaveState(FacesContext ctx) {
        log.debug((Object)"Before saving state");
        SeamPhaseListener.storeAnyConversationContext(ctx);
    }

    private static void restoreAnyConversationContext(PhaseEvent event) {
        Lifecycle.resumePage();
        ExternalContext externalContext = event.getFacesContext().getExternalContext();
        Map parameters = SeamPhaseListener.getParameters(event);
        Manager.instance().restoreConversation(parameters);
        Lifecycle.resumeConversation(externalContext);
        if (Init.instance().isJbpmInstalled()) {
            Pageflow.instance().validatePageflow();
        }
        Manager.instance().handleConversationPropagation(parameters);
        SeamPhaseListener.selectDataModelRow(parameters);
        log.debug((Object)("After restore view, conversation context: " + Contexts.getConversationContext()));
    }

    private static void selectDataModelRow(Map parameters) {
        String dataModelSelection = (String)parameters.get("dataModelSelection");
        if (dataModelSelection != null) {
            int loc = dataModelSelection.indexOf(91);
            String name = dataModelSelection.substring(0, loc);
            int index = Integer.parseInt(dataModelSelection.substring(loc + 1, dataModelSelection.length() - 1));
            Object value = Contexts.lookupInStatefulContexts(name);
            if (value != null) {
                ((DataModel)value).setRowIndex(index);
            }
        }
    }

    static void storeAnyConversationContext(FacesContext ctx) {
        Lifecycle.flushClientConversation();
        if (!Contexts.isConversationContextActive()) {
            log.debug((Object)"No active conversation context");
        } else {
            Session session = Session.getSession(ctx.getExternalContext(), true);
            Manager.instance().storeConversation(session, ctx.getExternalContext().getResponse());
        }
        Lifecycle.flushPage();
    }

    private static Map getParameters(PhaseEvent event) {
        return event.getFacesContext().getExternalContext().getRequestParameterMap();
    }

    private static Map getAttributes(FacesContext facesContext) {
        return facesContext.getViewRoot().getAttributes();
    }
}

