/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.jsf;

import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.core.Init;
import org.jboss.seam.jsf.SeamPhaseListener;
import org.jboss.seam.util.Transactions;

public class SeamExtendedManagedPersistencePhaseListener
extends SeamPhaseListener {
    private static final Log log = LogFactory.getLog(SeamExtendedManagedPersistencePhaseListener.class);

    public void beforePhase(PhaseEvent event) {
        boolean beginTran;
        boolean bl = beginTran = event.getPhaseId() == PhaseId.RESTORE_VIEW || event.getPhaseId() == PhaseId.RENDER_RESPONSE && !Init.instance().isClientSideConversations();
        if (beginTran) {
            this.begin();
        }
        super.beforePhase(event);
    }

    public void afterPhase(PhaseEvent event) {
        boolean commitTran;
        boolean bl = commitTran = event.getPhaseId() == PhaseId.INVOKE_APPLICATION || event.getFacesContext().getRenderResponse() || event.getFacesContext().getResponseComplete() || event.getPhaseId() == PhaseId.RENDER_RESPONSE && !Init.instance().isClientSideConversations();
        if (commitTran) {
            this.commit();
        }
        super.afterPhase(event);
    }

    protected void afterPageActions() {
        this.commit();
        this.begin();
    }

    private void begin() {
        try {
            if (!Transactions.isTransactionActiveOrMarkedRollback()) {
                log.debug((Object)"beginning transaction");
                Transactions.getUserTransaction().begin();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not start transaction", e);
        }
    }

    private void commit() {
        try {
            if (Transactions.isTransactionActive()) {
                log.debug((Object)"committing transaction");
                Transactions.getUserTransaction().commit();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not commit transaction", e);
        }
    }
}

