/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import org.jboss.seam.Component;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.FacesMessages;
import org.jboss.seam.core.Jbpm;
import org.jboss.seam.core.Manager;
import org.jboss.seam.jbpm.Page;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;

@Scope(value=ScopeType.CONVERSATION)
@Name(value="org.jboss.seam.core.pageflow")
@Intercept(value=InterceptionType.NEVER)
public class Pageflow {
    private int counter;
    private ProcessInstance processInstance;

    public boolean isInProcess() {
        return this.processInstance != null;
    }

    public ProcessInstance getProcessInstance() {
        return this.processInstance;
    }

    public void setProcessInstance(ProcessInstance processInstance) {
        this.processInstance = processInstance;
    }

    public static Pageflow instance() {
        if (!Contexts.isConversationContextActive()) {
            throw new IllegalStateException("No active conversation context");
        }
        return (Pageflow)Component.getInstance(Pageflow.class, ScopeType.CONVERSATION, true);
    }

    public int getPageflowCounter() {
        return this.counter;
    }

    public void validatePageflow() {
        if (this.processInstance != null) {
            if (this.getPage().isBackEnabled()) {
                String pageNodeName = (String)Contexts.getPageContext().get(Manager.PAGEFLOW_NODE_NAME);
                if (pageNodeName != null && !pageNodeName.equals(this.getNode().getName())) {
                    this.reposition(pageNodeName);
                }
            } else {
                Integer counter = (Integer)Contexts.getPageContext().get(Manager.PAGEFLOW_COUNTER);
                if (counter != null && this.getPageflowCounter() != counter.intValue()) {
                    this.illegalNavigationError();
                }
            }
        }
    }

    private void illegalNavigationError() {
        FacesContext context = FacesContext.getCurrentInstance();
        this.navigate(context);
        FacesMessages.instance().addFromResourceBundle(FacesMessage.SEVERITY_WARN, "org.jboss.seam.IllegalNavigation", "Illegal navigation");
        context.renderResponse();
    }

    public Node getNode() {
        if (this.processInstance == null) {
            return null;
        }
        Token pageFlowToken = this.processInstance.getRootToken();
        return pageFlowToken.getNode();
    }

    public void reposition(String nodeName) {
        Node node = this.processInstance.getProcessDefinition().getNode(nodeName);
        this.processInstance.getRootToken().setNode(node);
    }

    public Page getPage() {
        return (Page)this.getNode();
    }

    private void navigate(FacesContext context) {
        Page page = this.getPage();
        if (!page.isRedirect()) {
            UIViewRoot viewRoot = context.getApplication().getViewHandler().createView(context, page.getViewId());
            context.setViewRoot(viewRoot);
        } else {
            Manager.instance().redirect(page.getViewId());
        }
        ++this.counter;
    }

    public boolean hasDefaultTransition() {
        return this.getNode().getLeavingTransition(null) != null;
    }

    private boolean isNullOutcome(String outcome) {
        return outcome == null || "".equals(outcome);
    }

    public boolean hasTransition(String outcome) {
        return this.isNullOutcome(outcome) ? this.hasDefaultTransition() : this.getNode().getLeavingTransition(outcome) != null;
    }

    public void navigate(FacesContext context, String outcome) {
        if (this.isNullOutcome(outcome)) {
            if (this.hasDefaultTransition()) {
                this.processInstance.signal((String)null);
                this.navigate(context);
            }
        } else {
            this.processInstance.signal(outcome);
            this.navigate(context);
        }
    }

    public void begin(String processDefinitionName) {
        ProcessDefinition pd = Jbpm.instance().getPageflowProcessDefinition(processDefinitionName);
        ProcessInstance pi = pd.createProcessInstance();
        this.setProcessInstance(pi);
    }
}

