/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.AnnotationConfiguration;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.annotations.Unwrap;
import org.jboss.seam.util.Naming;

@Scope(value=ScopeType.APPLICATION)
@Intercept(value=InterceptionType.NEVER)
@Startup(depends={"org.jboss.seam.core.microcontainer"})
@Name(value="org.jboss.seam.core.hibernate")
public class Hibernate {
    private SessionFactory sessionFactory;
    private String cfgResourceName;

    @Unwrap
    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    @Create
    public void startup() throws Exception {
        AnnotationConfiguration acfg = new AnnotationConfiguration();
        if (this.cfgResourceName == null) {
            acfg.configure();
        } else {
            acfg.configure(this.cfgResourceName);
        }
        Hashtable hash = Naming.getInitialContextProperties();
        Properties prefixed = new Properties();
        for (Map.Entry entry : hash.entrySet()) {
            prefixed.setProperty("hibernate.jndi." + (String)entry.getKey(), (String)entry.getValue());
        }
        acfg.getProperties().putAll((Map<?, ?>)prefixed);
        this.sessionFactory = acfg.buildSessionFactory();
    }

    @Destroy
    public void shutdown() {
        this.sessionFactory.close();
    }

    public String getCfgResourceName() {
        return this.cfgResourceName;
    }

    public void setCfgResourceName(String cfgFileName) {
        this.cfgResourceName = cfgFileName;
    }
}

