/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.hibernate.validator.InvalidValue;
import org.jboss.seam.Component;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.ResourceBundle;
import org.jboss.seam.util.Template;

@Scope(value=ScopeType.CONVERSATION)
@Name(value="facesMessages")
@Intercept(value=InterceptionType.NEVER)
public class FacesMessages {
    private List<Runnable> tasks = new ArrayList<Runnable>();
    private List<FacesMessage> facesMessages = new ArrayList<FacesMessage>();
    private Map<String, List<FacesMessage>> keyedFacesMessages = new HashMap<String, List<FacesMessage>>();

    public void beforeRenderResponse() {
        for (FacesMessage facesMessage : this.facesMessages) {
            FacesContext.getCurrentInstance().addMessage(null, facesMessage);
        }
        for (Map.Entry entry : this.keyedFacesMessages.entrySet()) {
            for (FacesMessage msg : (List)entry.getValue()) {
                FacesContext.getCurrentInstance().addMessage((String)entry.getKey(), msg);
            }
        }
        this.clear();
    }

    private void runTasks() {
        for (Runnable task : this.tasks) {
            task.run();
        }
        this.tasks.clear();
    }

    public static void afterPhase() {
        FacesMessages instance;
        if (Contexts.isConversationContextActive() && (instance = (FacesMessages)Component.getInstance(FacesMessages.class, ScopeType.CONVERSATION, false)) != null) {
            instance.runTasks();
        }
    }

    public void clear() {
        this.facesMessages.clear();
        this.keyedFacesMessages.clear();
    }

    public void add(FacesMessage facesMessage) {
        this.facesMessages.add(facesMessage);
    }

    public void add(String id, FacesMessage facesMessage) {
        String clientId = this.getClientId(id);
        List<FacesMessage> list = this.keyedFacesMessages.get(clientId);
        if (list == null) {
            list = new ArrayList<FacesMessage>();
            this.keyedFacesMessages.put(clientId, list);
        }
        list.add(facesMessage);
    }

    public void add(String id, String messageTemplate) {
        this.add(id, FacesMessage.SEVERITY_INFO, messageTemplate);
    }

    public void add(final String id, final FacesMessage.Severity severity, final String messageTemplate) {
        this.tasks.add(new Runnable(){

            public void run() {
                FacesMessages.this.add(id, FacesMessages.this.createFacesMessage(severity, messageTemplate));
            }
        });
    }

    public static FacesMessages instance() {
        if (!Contexts.isConversationContextActive()) {
            throw new IllegalStateException("No active conversation context");
        }
        return (FacesMessages)Component.getInstance(FacesMessages.class, ScopeType.CONVERSATION, true);
    }

    public void add(String messageTemplate) {
        this.add(FacesMessage.SEVERITY_INFO, messageTemplate);
    }

    public void add(final FacesMessage.Severity severity, final String messageTemplate) {
        this.tasks.add(new Runnable(){

            public void run() {
                FacesMessages.this.add(FacesMessages.this.createFacesMessage(severity, messageTemplate));
            }
        });
    }

    public void addFromResourceBundle(String key) {
        this.addFromResourceBundle(FacesMessage.SEVERITY_INFO, key);
    }

    public void addFromResourceBundle(FacesMessage.Severity severity, String key) {
        this.addFromResourceBundle(severity, key, key);
    }

    public void addFromResourceBundle(FacesMessage.Severity severity, String key, String defaultMessageTemplate) {
        String messageTemplate = defaultMessageTemplate;
        java.util.ResourceBundle resourceBundle = ResourceBundle.instance();
        if (resourceBundle != null) {
            try {
                String bundleMessage = resourceBundle.getString(key);
                if (bundleMessage != null) {
                    messageTemplate = bundleMessage;
                }
            }
            catch (MissingResourceException mre) {
                // empty catch block
            }
        }
        this.add(severity, messageTemplate);
    }

    public void add(InvalidValue iv) {
        this.add(iv.getPropertyName(), FacesMessage.SEVERITY_WARN, iv.getMessage());
    }

    private FacesMessage createFacesMessage(FacesMessage.Severity severity, String messageTemplate) {
        return new FacesMessage(severity, Template.render(messageTemplate), null);
    }

    private String getClientId(String id) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return FacesMessages.getClientId((UIComponent)facesContext.getViewRoot(), id, facesContext);
    }

    private static String getClientId(UIComponent component, String id, FacesContext facesContext) {
        String componentId = component.getId();
        if (componentId != null && componentId.equals(id)) {
            return component.getClientId(facesContext);
        }
        Iterator iter = component.getFacetsAndChildren();
        while (iter.hasNext()) {
            UIComponent child = (UIComponent)iter.next();
            String clientId = FacesMessages.getClientId(child, id, facesContext);
            if (clientId == null) continue;
            return clientId;
        }
        return null;
    }
}

