/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.buildmagic.task;

import java.io.File;
import java.util.Hashtable;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.jboss.tools.buildmagic.task.FindRoot;
import org.jboss.tools.buildmagic.task.ResolveProperties;
import org.jboss.tools.buildmagic.task.util.TaskLogger;

public class Property
extends org.apache.tools.ant.taskdefs.Property {
    public static final int STRING = 0;
    public static final int INTEGER = 1;
    public static final int FLOAT = 2;
    public static final int BOOLEAN = 3;
    public static final int PATH = 4;
    protected final TaskLogger log = new TaskLogger((Task)this);
    protected String type;
    protected String separator;
    protected boolean override;
    protected boolean filter;
    protected boolean resolve;
    protected boolean force;
    protected boolean system;
    protected FindRoot findRoot;

    public void setType(String type) {
        this.type = type;
    }

    public void setSeparator(String sep) {
        this.separator = sep;
    }

    public void setOverride(boolean override) {
        this.override = override;
    }

    public void setFilter(boolean filter) {
        this.filter = filter;
    }

    public void setSystem(boolean system) {
        this.system = system;
    }

    public void setResolve(String resolve) {
        if (resolve.equals("force")) {
            this.resolve = true;
            this.force = true;
        } else {
            this.resolve = new Boolean(resolve);
        }
    }

    public FindRoot createFindRoot() {
        this.findRoot = new FindRoot(this.log);
        return this.findRoot;
    }

    public void addText(String text) {
        this.value = this.value == null ? text : this.value + text;
    }

    public Element createElement() {
        return new Element();
    }

    public Element createAppend() {
        return new Element(0);
    }

    public Element createPrepend() {
        return new Element(1);
    }

    public void execute() throws BuildException {
        if (this.findRoot != null) {
            this.findRoot.setProperty(this.getName());
            File root = this.findRoot.getRoot();
            this.value = root.getAbsolutePath();
        }
        if (this.resolve) {
            this.log.debug("resolving property: " + this.name + "(force: " + this.force + ")");
            Hashtable props = this.project.getProperties();
            this.value = ResolveProperties.subst(this.value, props, this.force);
        }
        this.convertType();
        if (this.system) {
            this.log.verbose("setting system proeprty: " + this.name + "=" + this.value);
            System.setProperty(this.name, this.value);
            this.project.setUserProperty(this.name, this.value);
        }
        super.execute();
        if (this.filter) {
            this.log.debug("adding filter for property: " + this.name);
            this.project.addFilter(this.name, this.value);
        }
    }

    protected void addProperty(String n, String v) {
        if (this.userProperty) {
            if (this.override || this.project.getUserProperty(n) == null) {
                this.project.setUserProperty(n, v);
                if (this.override) {
                    this.log.debug("overrode user property value for " + n);
                }
            } else {
                this.log.debug("Override ignored for " + n);
            }
        } else if (this.override || this.project.getProperty(n) == null) {
            this.project.setProperty(n, v);
            if (this.override) {
                this.log.debug("overrode property value for " + n);
            }
        } else {
            this.log.debug("Override ignored for " + n);
        }
    }

    protected int parseType() throws BuildException {
        this.log.debug("parsing type: " + this.type);
        if (this.type == null || this.type.equals("string")) {
            return 0;
        }
        if (this.type.equals("integer")) {
            return 1;
        }
        if (this.type.equals("float")) {
            return 2;
        }
        if (this.type.equals("boolean")) {
            return 3;
        }
        if (this.type.equals("path") || this.type.equals("file") || this.type.equals("dir")) {
            return 4;
        }
        throw new BuildException("invalid property type: " + this.type);
    }

    protected void convertType() throws BuildException {
        int code = this.parseType();
        switch (code) {
            case 1: {
                try {
                    this.log.debug("converting value to an integer");
                    this.value = new Long(this.value).toString();
                    break;
                }
                catch (Exception e) {
                    throw new BuildException("property value is not an integer: " + this.value);
                }
            }
            case 2: {
                try {
                    this.log.debug("converting value to an floating point");
                    this.value = new Double(this.value).toString();
                    break;
                }
                catch (Exception e) {
                    throw new BuildException("property value is not a floating point number: " + this.value);
                }
            }
            case 3: {
                this.value = new Boolean(this.value).toString();
                break;
            }
            case 4: {
                this.log.debug("converting value to a path");
                Path path = new Path(null, this.value);
                this.value = path.toString();
                break;
            }
        }
        this.log.debug("converted value: " + this.value);
    }

    public class Element {
        public static final int APPEND = 0;
        public static final int PREPEND = 1;
        protected int mode = 0;

        public Element() {
        }

        public Element(int mode) {
            this.mode = mode;
        }

        public void setMode(String mode) throws BuildException {
            if (mode.equals("append")) {
                this.mode = 0;
            } else if (mode.equals("prepend")) {
                this.mode = 1;
            } else {
                throw new BuildException("Invalid property element mode: " + mode);
            }
        }

        public int getMode() {
            return this.mode;
        }

        protected void appendCurrentValue(StringBuffer buff) {
            if (Property.this.value != null) {
                buff.append(Property.this.value);
                if (Property.this.separator != null) {
                    buff.append(Property.this.separator);
                }
            }
        }

        public void setValue(String s) {
            StringBuffer buff = new StringBuffer();
            switch (this.mode) {
                case 0: {
                    this.appendCurrentValue(buff);
                    buff.append(s);
                    break;
                }
                case 1: {
                    buff.append(s);
                    this.appendCurrentValue(buff);
                    break;
                }
                default: {
                    throw new BuildException("Invalid property element mode: " + this.mode);
                }
            }
            Property.this.log.debug("new value: " + buff);
            Property.this.value = buff.toString();
        }
    }
}

