/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm.recovery;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class HexDump {
    public static String fromBuffer(byte[] buffer) {
        int n;
        int N = 16;
        StringBuffer sb = new StringBuffer("\n");
        int i = 0;
        while ((n = Math.min(16, buffer.length - i)) != 0) {
            int j;
            sb.append(HexDump.toHexString(i) + ": ");
            for (j = 0; j < n; ++j) {
                sb.append(HexDump.toHexString(buffer[i + j]) + " ");
            }
            for (j = n; j < 16; ++j) {
                sb.append("   ");
            }
            sb.append("  ");
            for (j = 0; j < n; ++j) {
                sb.append(HexDump.toDisplayableChar(buffer[i + j]));
            }
            sb.append("\n");
            i += n;
        }
        return sb.toString();
    }

    private static String toHexString(byte b) {
        String hexStr;
        int i = b;
        if (i < 0) {
            i -= -256;
        }
        return (hexStr = Integer.toHexString(i)).length() < 2 ? "0" + hexStr : hexStr;
    }

    private static String toHexString(int n) {
        String hexStr = Integer.toHexString(n);
        while (hexStr.length() < 8) {
            hexStr = " " + hexStr;
        }
        return hexStr;
    }

    private static char toDisplayableChar(byte b) {
        char c = (char)b;
        if (c >= ' ' && c < '\u007f') {
            return c;
        }
        return '.';
    }

    public static void main(String[] args) throws IOException {
        byte[] ibuf = new byte[4096];
        if (args.length > 1) {
            System.err.println("HexDump usage: java HexDump [file]");
            System.exit(1);
        }
        InputStream in = args.length == 0 ? System.in : new FileInputStream(args[0]);
        int n = in.read(ibuf);
        while (n > 0) {
            byte[] buf = new byte[n];
            System.arraycopy(ibuf, 0, buf, 0, n);
            System.out.print(HexDump.fromBuffer(buf));
            n = in.read(ibuf);
        }
        if (args.length != 0) {
            in.close();
        }
    }
}

