/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.modules.ejb.dd;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import xdoclet.XDocletException;
import xdoclet.modules.ejb.EjbTagsHandler;
import xdoclet.modules.ejb.intf.InterfaceTagsHandler;
import xdoclet.util.DocletUtil;
import xjavadoc.ClassIterator;
import xjavadoc.MethodIterator;
import xjavadoc.TagIterator;
import xjavadoc.XClass;
import xjavadoc.XCollections;
import xjavadoc.XDoc;
import xjavadoc.XJavaDoc;
import xjavadoc.XMethod;
import xjavadoc.XTag;

public class SecurityTagsHandler
extends EjbTagsHandler {
    protected transient String currentSecurityRoleName;

    public String securityRoleName() throws XDocletException {
        return this.currentSecurityRoleName;
    }

    public void forAllSecurityRoles(String template) throws XDocletException {
        Collection classes = XJavaDoc.getInstance().getSourceClasses();
        HashSet<String> roleSet = new HashSet<String>();
        ClassIterator i = XCollections.classIterator((Collection)classes);
        while (i.hasNext()) {
            XClass clazz = i.next();
            SecurityTagsHandler.setCurrentClass((XClass)clazz);
            if (this.hasPermission(SecurityTagsHandler.getCurrentClass().getDoc())) {
                Collection permissions = SecurityTagsHandler.getCurrentClass().getDoc().getTags("ejb.permission");
                TagIterator k = XCollections.tagIterator((Collection)permissions);
                while (k.hasNext()) {
                    XTag tag = k.next();
                    String roleName = tag.getAttributeValue("role-name");
                    if (roleName == null) continue;
                    roleSet.addAll(Arrays.asList(DocletUtil.tokenizeDelimitedToArray((String)roleName, (String)",")));
                }
            }
            Collection methods = SecurityTagsHandler.getCurrentClass().getMethods();
            MethodIterator j = XCollections.methodIterator((Collection)methods);
            while (j.hasNext()) {
                XMethod method = j.next();
                SecurityTagsHandler.setCurrentMethod((XMethod)method);
                if (!this.hasPermission(SecurityTagsHandler.getCurrentMethod().getDoc()) || !InterfaceTagsHandler.isInterfaceMethod(SecurityTagsHandler.getCurrentMethod())) continue;
                Collection permissions = SecurityTagsHandler.getCurrentMethod().getDoc().getTags("ejb.permission");
                TagIterator k = XCollections.tagIterator((Collection)permissions);
                while (k.hasNext()) {
                    XTag tag = k.next();
                    String role_name = tag.getAttributeValue("role-name");
                    if (role_name == null) continue;
                    roleSet.addAll(Arrays.asList(DocletUtil.tokenizeDelimitedToArray((String)role_name, (String)",")));
                }
            }
            Collection finders = SecurityTagsHandler.getCurrentClass().getDoc().getTags("ejb:finder");
            TagIterator j2 = XCollections.tagIterator((Collection)finders);
            while (j2.hasNext()) {
                XTag tag = j2.next();
                String roleName = tag.getAttributeValue("role-name");
                if (roleName == null) continue;
                roleSet.addAll(Arrays.asList(DocletUtil.tokenizeDelimitedToArray((String)roleName, (String)",")));
            }
            Collection pk = SecurityTagsHandler.getCurrentClass().getDoc().getTags("ejb:pk");
            TagIterator j3 = XCollections.tagIterator((Collection)pk);
            while (j3.hasNext()) {
                XTag tag = j3.next();
                String roleName = tag.getAttributeValue("role-name");
                if (roleName == null) continue;
                roleSet.addAll(Arrays.asList(DocletUtil.tokenizeDelimitedToArray((String)roleName, (String)",")));
            }
        }
        Iterator roleEnum = roleSet.iterator();
        while (roleEnum.hasNext()) {
            this.currentSecurityRoleName = (String)roleEnum.next();
            this.generate(template);
        }
    }

    private final boolean hasPermission(XDoc doc) throws XDocletException {
        return doc.hasTag("ejb:permission");
    }
}

