/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html.images;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.Serializable;
import java.util.Date;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.ajax4jsf.framework.resource.GifRenderer;
import org.ajax4jsf.framework.resource.InternetResourceBuilder;
import org.ajax4jsf.framework.resource.Java2Dresource;
import org.ajax4jsf.framework.resource.ResourceContext;
import org.ajax4jsf.framework.resource.ResourceRenderer;
import org.ajax4jsf.framework.skin.Skin;
import org.ajax4jsf.framework.skin.SkinFactory;
import org.ajax4jsf.framework.util.HtmlColor;
import org.ajax4jsf.framework.util.HtmlDimensions;
import org.richfaces.component.UISeparator;

public class SimpleSeparatorImage
extends Java2Dresource {
    private static final int LINE_TYPE_DOTTED = 1;
    private static final int LINE_TYPE_DASHED = 2;
    private static final int LINE_TYPE_DOUBLE = 3;
    private static final int LINE_TYPE_SOLID = 4;

    public SimpleSeparatorImage() {
        this.setRenderer((ResourceRenderer)new GifRenderer());
        this.setLastModified(new Date(InternetResourceBuilder.getInstance().getStartTime()));
    }

    protected RenderedImage getImage(ResourceContext context) {
        SimpleSeparatorData separatorData = (SimpleSeparatorData)this.restoreData(context);
        Color color = new Color(separatorData.getColor());
        int height = separatorData.getHeight();
        int lineType = separatorData.getLineType();
        if (height <= 0) {
            height = 1;
        }
        Graphics2D g2d = null;
        switch (lineType) {
            case 1: {
                BufferedImage bufferedImage = new BufferedImage(3 * height, height, 2);
                g2d = bufferedImage.createGraphics();
                g2d.setColor(color);
                g2d.fillRect(0, 0, height, height);
                return bufferedImage;
            }
            case 2: {
                BufferedImage bufferedImage = new BufferedImage(4 * height, height, 2);
                g2d = bufferedImage.createGraphics();
                g2d.setColor(color);
                g2d.fillRect(0, 0, 3 * height, height);
                return bufferedImage;
            }
            case 3: {
                BufferedImage bufferedImage = new BufferedImage(1, height, 2);
                int lineHeight = Math.round((float)height / 3.0f);
                g2d = bufferedImage.createGraphics();
                g2d.setColor(color);
                g2d.fillRect(0, 0, 1, lineHeight);
                g2d.fillRect(0, height - lineHeight, 1, lineHeight);
                return bufferedImage;
            }
            case 4: {
                BufferedImage bufferedImage = new BufferedImage(1, height, 2);
                g2d = bufferedImage.createGraphics();
                g2d.setColor(color);
                g2d.fillRect(0, 0, 1, height);
                return bufferedImage;
            }
        }
        return null;
    }

    protected Object getDataToStore(FacesContext context, Object data) {
        SimpleSeparatorData separatorData = new SimpleSeparatorData();
        Skin skin = SkinFactory.getInstance().getSkin(context);
        String tmp = (String)((UIComponent)data).getAttributes().get("height");
        separatorData.setHeight(HtmlDimensions.decode((String)(tmp == null ? "6" : tmp)).intValue());
        tmp = (String)skin.getParameter(context, "headerBackgroundColor");
        separatorData.setColor(HtmlColor.decode((String)(tmp == null ? "#4169E1" : tmp)).getRGB());
        tmp = ((UISeparator)((Object)data)).getLineType();
        int lineType = 4;
        if (tmp.equalsIgnoreCase("dotted")) {
            lineType = 1;
        } else if (tmp.equalsIgnoreCase("dashed")) {
            lineType = 2;
        } else if (tmp.equalsIgnoreCase("double") && separatorData.getHeight() > 2) {
            lineType = 3;
        }
        separatorData.setLineType(lineType);
        return separatorData;
    }

    protected static class SimpleSeparatorData
    implements Serializable {
        private static final long serialVersionUID = -4420043779436390358L;
        private int height;
        private int color;
        private int lineType;

        protected SimpleSeparatorData() {
        }

        public int getHeight() {
            return this.height;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public int getColor() {
            return this.color;
        }

        public void setColor(int color) {
            this.color = color;
        }

        public int getLineType() {
            return this.lineType;
        }

        public void setLineType(int lineType) {
            this.lineType = lineType;
        }
    }
}

