/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.framework.renderer.AjaxRendererUtils;
import org.ajax4jsf.framework.renderer.ComponentVariables;
import org.ajax4jsf.framework.renderer.ComponentsVariableResolver;
import org.ajax4jsf.framework.renderer.HeaderResourcesRendererBase;
import org.ajax4jsf.framework.renderer.RendererBase;
import org.ajax4jsf.framework.util.javascript.JSFunction;
import org.richfaces.component.UIDatascroller;
import org.richfaces.event.DataScrollerEvent;
import org.richfaces.renderkit.html.ControlsState;

public class DataScrollerRenderer
extends HeaderResourcesRendererBase {
    static /* synthetic */ Class class$org$richfaces$component$UIDatascroller;

    protected Class getComponentClass() {
        return class$org$richfaces$component$UIDatascroller == null ? (class$org$richfaces$component$UIDatascroller = DataScrollerRenderer.class$("org.richfaces.component.UIDatascroller")) : class$org$richfaces$component$UIDatascroller;
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        UIDatascroller scroller = (UIDatascroller)component;
        UIData dataTable = scroller.getDataTable();
        ComponentVariables variables = ComponentsVariableResolver.getVariables((RendererBase)this, (UIComponent)component);
        variables.setVariable("dataTable", (Object)dataTable);
        if (scroller.getPageCount(dataTable) != 1 || scroller.isRenderIfSinglePage()) {
            variables.setVariable("rendered", (Object)Boolean.TRUE);
            super.encodeBegin(context, component);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ComponentVariables variables = ComponentsVariableResolver.getVariables((RendererBase)this, (UIComponent)component);
        if (Boolean.TRUE.equals(variables.getVariable("rendered"))) {
            super.encodeEnd(context, component);
        }
    }

    public void decode(FacesContext context, UIComponent component) {
        String param = (String)this.getParamMap(context).get(component.getClientId(context));
        UIDatascroller scroller = (UIDatascroller)component;
        if (param != null) {
            new DataScrollerEvent((UIComponent)scroller, String.valueOf(scroller.getPageIndex()), param).queue();
        }
    }

    public ControlsState getControlsState(FacesContext context, UIDatascroller datascroller, UIData dataTable) {
        int pageIndex = datascroller.getPageIndex(dataTable);
        int pageCount = datascroller.getPageCount(dataTable);
        int minPageIdx = 1;
        int maxPageIdx = pageCount;
        int fastStep = datascroller.getFastStep();
        if (fastStep <= 1) {
            fastStep = 1;
        }
        boolean useFirst = true;
        boolean useLast = true;
        boolean useBackFast = true;
        boolean useForwFast = true;
        ControlsState controlsState = new ControlsState();
        if (pageIndex <= minPageIdx) {
            useFirst = false;
        }
        if (pageIndex >= maxPageIdx) {
            useLast = false;
        }
        if (pageIndex - fastStep < minPageIdx) {
            useBackFast = false;
        }
        if (pageIndex + fastStep > maxPageIdx) {
            useForwFast = false;
        }
        String boundaryControls = datascroller.getBoundaryControls();
        String stepControls = datascroller.getStepControls();
        String fastControls = datascroller.getFastControls();
        boolean isAuto = "auto".equals(boundaryControls);
        if (isAuto || "show".equals(boundaryControls)) {
            if (isAuto) {
                controlsState.setFirstRendered(useFirst);
                controlsState.setLastRendered(useLast);
            }
            controlsState.setFirstEnabled(useFirst);
            controlsState.setLastEnabled(useLast);
        } else {
            controlsState.setFirstRendered(false);
            controlsState.setLastRendered(false);
        }
        isAuto = "auto".equals(stepControls);
        if (isAuto || "show".equals(stepControls)) {
            if (isAuto) {
                controlsState.setPreviousRendered(useFirst);
                controlsState.setNextRendered(useLast);
            }
            controlsState.setPreviousEnabled(useFirst);
            controlsState.setNextEnabled(useLast);
        } else {
            controlsState.setPreviousRendered(false);
            controlsState.setNextRendered(false);
        }
        isAuto = "auto".equals(fastControls);
        if (isAuto || "show".equals(fastControls)) {
            if (isAuto) {
                controlsState.setFastForwardRendered(useForwFast);
                controlsState.setFastRewindRendered(useBackFast);
            }
            controlsState.setFastForwardEnabled(useForwFast);
            controlsState.setFastRewindEnabled(useBackFast);
        } else {
            controlsState.setFastForwardRendered(false);
            controlsState.setFastRewindRendered(false);
        }
        return controlsState;
    }

    public void renderPager(FacesContext context, UIComponent component) throws IOException {
        int start;
        int pages;
        int pageCount;
        ComponentVariables variables = ComponentsVariableResolver.getVariables((RendererBase)this, (UIComponent)component);
        UIData data = (UIData)variables.getVariable("dataTable");
        ResponseWriter out = context.getResponseWriter();
        UIDatascroller scroller = (UIDatascroller)component;
        int currentPage = scroller.getPageIndex(data);
        int maxPages = scroller.getMaxPages();
        if (maxPages <= 1) {
            maxPages = 1;
        }
        if ((pageCount = scroller.getPageCount(data)) <= 1) {
            return;
        }
        int delta = maxPages / 2;
        if (pageCount > maxPages && currentPage > delta) {
            pages = maxPages;
            start = currentPage - pages / 2 - 1;
            if (start + pages > pageCount) {
                start = pageCount - pages;
            }
        } else {
            pages = pageCount < maxPages ? pageCount : maxPages;
            start = 0;
        }
        int size = start + pages;
        for (int i = start; i < size; ++i) {
            boolean isCurrentPage = i + 1 == currentPage;
            out.startElement("td", component);
            if (isCurrentPage) {
                out.writeAttribute("align", (Object)"center", null);
                out.writeAttribute("class", (Object)"dr-dscr-act rich-datascr-act", null);
                out.writeAttribute("style", (Object)("" + scroller.getSelectedStyle()), null);
            } else {
                out.writeAttribute("align", (Object)"center", null);
                out.writeAttribute("class", (Object)"dr-dscr-inact rich-datascr-inact", null);
                out.writeAttribute("onclick", (Object)this.getOnClick(context, component, Integer.toString(i + 1)), null);
            }
            out.writeText((Object)Integer.toString(i + 1), null);
            out.endElement("td");
        }
    }

    private Map getParamMap(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap();
    }

    public String getOnClick(FacesContext context, UIComponent component, String value) {
        JSFunction function = AjaxRendererUtils.buildAjaxFunction((UIComponent)component, (FacesContext)context);
        UIDatascroller scroller = (UIDatascroller)component;
        Map eventOptions = AjaxRendererUtils.buildEventOptions((FacesContext)context, (UIComponent)component);
        Map parameters = (Map)eventOptions.get("parameters");
        parameters.put(scroller.getClientId(context), value);
        function.addParameter((Object)eventOptions);
        StringBuffer buffer = new StringBuffer();
        function.appendScript(buffer);
        buffer.append("; return false;");
        String script = buffer.toString();
        return script;
    }

    public boolean getRendersChildren() {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

