/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.ajax.repeat.DataVisitor;
import org.ajax4jsf.framework.renderer.AjaxRendererUtils;
import org.ajax4jsf.framework.renderer.ComponentVariables;
import org.ajax4jsf.framework.renderer.ComponentsVariableResolver;
import org.ajax4jsf.framework.renderer.RendererBase;
import org.ajax4jsf.framework.renderer.RendererUtils;
import org.ajax4jsf.framework.util.javascript.JSFunction;
import org.ajax4jsf.framework.util.javascript.JSReference;
import org.ajax4jsf.framework.util.javascript.ScriptUtils;
import org.richfaces.component.LastElementAware;
import org.richfaces.component.TreeRowKey;
import org.richfaces.component.UITree;
import org.richfaces.component.UITreeNode;
import org.richfaces.component.nsutils.NSUtils;
import org.richfaces.renderkit.CompositeRenderer;
import org.richfaces.renderkit.DnDParametersEncoder;
import org.richfaces.renderkit.DraggableRendererContributor;
import org.richfaces.renderkit.DropzoneRendererContributor;
import org.richfaces.renderkit.Flag;
import org.richfaces.renderkit.StringHolder;
import org.richfaces.renderkit.TreeDataModelEventNavigator;

public abstract class TreeRendererBase
extends CompositeRenderer {
    public TreeRendererBase() {
        this.addContributor(DraggableRendererContributor.getInstance());
        this.addContributor(DropzoneRendererContributor.getInstance());
        this.addParameterEncoder(DnDParametersEncoder.getInstance());
    }

    public void writeNamespace(FacesContext context, UIComponent component) throws IOException {
        NSUtils.writeNameSpace(context, component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encodeAjaxChildren(FacesContext context, UIComponent component, String path, Set ids, Set renderedAreas) throws IOException {
        block12: {
            super.encodeAjaxChildren(context, component, path, ids, renderedAreas);
            try {
                String inputId;
                if (!(component instanceof UITree)) break block12;
                UITree tree = (UITree)component;
                tree.captureOrigValue();
                boolean encodeScripts = false;
                tree.setRowKey(null);
                ResponseWriter responseWriter = context.getResponseWriter();
                responseWriter.startElement("div", (UIComponent)tree);
                this.writeNamespace(context, component);
                ArrayList<String> encodedAreaIds = new ArrayList<String>();
                try {
                    Set ajaxKeys = tree.getAjaxKeys();
                    if (ajaxKeys != null) {
                        Iterator ajaxKeysItr = ajaxKeys.iterator();
                        while (ajaxKeysItr.hasNext()) {
                            TreeRowKey key = (TreeRowKey)ajaxKeysItr.next();
                            tree.setRowKey(key);
                            String id = tree.getNodeFacet().getClientId(context);
                            if (!ids.isEmpty() && !ids.contains(id) && !ids.contains(tree.getClientId(context))) continue;
                            this.writeContent(context, tree, key);
                            encodeScripts = true;
                            renderedAreas.add(id);
                            encodedAreaIds.add(id);
                        }
                        ajaxKeys.clear();
                    }
                }
                catch (Exception e) {
                    throw new FacesException((Throwable)e);
                }
                finally {
                    tree.setRowKey(null);
                    tree.restoreOrigValue();
                }
                if (encodeScripts) {
                    this.writeScript(context, tree, encodedAreaIds, renderedAreas);
                }
                if ((inputId = this.encodeSelectionStateInput(context, tree)) != null) {
                    renderedAreas.add(inputId);
                }
                responseWriter.endElement("div");
            }
            finally {
                ComponentsVariableResolver.removeVariables((RendererBase)this, (UIComponent)component);
            }
        }
    }

    public String encodeSelectionStateInput(FacesContext context, UITree tree) throws IOException {
        ComponentVariables variables = ComponentsVariableResolver.getVariables((RendererBase)this, (UIComponent)tree);
        Object object = variables.getVariable("selectionId");
        if (object != null) {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("input", (UIComponent)tree);
            writer.writeAttribute("type", (Object)"hidden", null);
            String selectionHolderInputId = tree.getSelectionStateInputName(context);
            writer.writeAttribute("id", (Object)selectionHolderInputId, null);
            writer.writeAttribute("name", (Object)selectionHolderInputId, null);
            writer.writeAttribute("value", object, null);
            writer.endElement("input");
            return selectionHolderInputId;
        }
        return null;
    }

    protected String getAjaxScript(FacesContext context, UITree tree) {
        String id = tree.getBaseClientId(context);
        JSFunction function = AjaxRendererUtils.buildAjaxFunction((UIComponent)tree, (FacesContext)context);
        Map eventOptions = AjaxRendererUtils.buildEventOptions((FacesContext)context, (UIComponent)tree);
        Map parameters = (Map)eventOptions.get("parameters");
        parameters.remove(id);
        parameters.put(id + ":selectedNode", new JSReference("event.selectedNode"));
        function.addParameter((Object)eventOptions);
        StringBuffer buffer = new StringBuffer();
        function.appendScript(buffer);
        buffer.append("; return false;");
        return buffer.toString();
    }

    protected String getDragIndicatorId(FacesContext context, UITree tree) {
        UIComponent component;
        String dragIndicator;
        if (tree.getAttributes().get("dragIndicator") instanceof String && (dragIndicator = (String)tree.getAttributes().get("dragIndicator")) != null && (component = tree.getParent().findComponent(dragIndicator)) != null) {
            return component.getClientId(context);
        }
        return "";
    }

    protected String getScriptContributions(FacesContext context, UITree tree) {
        return super.getScriptContributions(this.getJavaScriptVarName(context, tree), context, (UIComponent)tree);
    }

    protected String getJavaScriptVarName(FacesContext context, UITree tree) {
        String id = tree.getBaseClientId(context);
        return "Richfaces_Tree_" + id.replaceAll("[^A-Za-z0-9_]", "_");
    }

    private void writeScript(FacesContext context, UITree tree, List encodedAreaIds, Set renderedAreas) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = tree.getBaseClientId(context);
        String scriptId = clientId + ':' + "script";
        writer.startElement("div", (UIComponent)tree);
        this.getUtils().writeAttribute(writer, "id", (Object)scriptId);
        writer.startElement("script", (UIComponent)tree);
        this.getUtils().writeAttribute(writer, "type", (Object)"text/javascript");
        String varName = this.getJavaScriptVarName(context, tree);
        writer.writeText((Object)(varName + ".getNodeElements(" + ScriptUtils.toScript((Object)encodedAreaIds) + ");"), null);
        writer.endElement("script");
        writer.endElement("div");
        renderedAreas.add(scriptId);
        renderedAreas.add(tree.getClientId(context) + ':' + "input");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        this.writeContent(context, (UITree)component, null);
    }

    public void writeContent(FacesContext context, UITree input) throws IOException {
        this.writeContent(context, input, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeContent(final FacesContext context, final UITree input, TreeRowKey key) throws IOException {
        final ResponseWriter writer = context.getResponseWriter();
        final Flag droppedDownToLevelFlag = new Flag();
        TreeRowKey rowKey = key;
        TreeDataModelEventNavigator levelNavigator = new TreeDataModelEventNavigator(input, rowKey){

            public void afterDown() throws IOException {
                TreeRendererBase.this.openLevelDownTable(context, input, writer);
            }

            public void afterUp(int levels) throws IOException {
                for (int i = 0; i < levels; ++i) {
                    TreeRendererBase.this.closeLevelDownTable(context, input, writer);
                    writer.endElement("td");
                    writer.endElement("tr");
                }
            }

            public void beforeDown() throws IOException {
                droppedDownToLevelFlag.setFlag();
                Object rowKey = this.getTree().getRowKey();
                String id = rowKey == null ? this.getTree().getClientId(context) + ':' : this.getTree().getNodeFacet().getClientId(context) + ':';
                writer.startElement("tr", (UIComponent)input);
                TreeRendererBase.this.getUtils().writeAttribute(writer, "id", (Object)(id + "childs"));
                if (!this.getTree().isExpanded()) {
                    TreeRendererBase.this.getUtils().writeAttribute(writer, "style", (Object)"display: none;");
                }
                if (this.getRowKey() != null) {
                    writer.startElement("td", (UIComponent)input);
                    if (!this.isStackedLastElement() && this.getTree().isShowConnectingLines()) {
                        TreeRendererBase.this.getUtils().writeAttribute(writer, "class", (Object)"dr-tree-h-ic-line");
                    }
                    writer.endElement("td");
                }
                writer.startElement("td", (UIComponent)input);
                TreeRendererBase.this.getUtils().writeAttribute(writer, "colspan", (Object)"2");
                TreeRendererBase.this.getUtils().writeAttribute(writer, "id", (Object)(id + "childs:td"));
                TreeRendererBase.this.getUtils().writeAttribute(writer, "valign", (Object)"top");
            }

            public void beforeUp(int levels) {
            }
        };
        StringHolder selectionValueHolder = new StringHolder();
        try {
            input.captureOrigValue();
            if (key != null) {
                droppedDownToLevelFlag.setFlag();
                this.openLevelDownTable(context, input, writer);
                input.setRowKey(key);
            } else {
                input.setRowKey(null);
            }
            input.walk(context, new DataVisitorWithLastElement(writer, selectionValueHolder, droppedDownToLevelFlag, input, levelNavigator), key, null);
            if (key != null) {
                this.closeLevelDownTable(context, input, writer);
            }
            levelNavigator.followRowKey(null);
            ComponentVariables variables = ComponentsVariableResolver.getVariables((RendererBase)this, (UIComponent)input);
            String value = selectionValueHolder.getValue();
            if (value != null) {
                variables.setVariable("selectionId", (Object)value);
            } else if (rowKey == null) {
                variables.setVariable("selectionId", (Object)"");
            }
        }
        finally {
            input.setRowKey(null);
            input.restoreOrigValue();
        }
    }

    private void openLevelDownTable(FacesContext context, UITree tree, ResponseWriter writer) throws IOException {
        writer.startElement("table", (UIComponent)tree);
        UITreeNode node = tree.getNodeFacet();
        RendererUtils utils = this.getUtils();
        utils.writeAttribute(writer, "border", (Object)"0");
        utils.writeAttribute(writer, "cellpadding", (Object)"0");
        utils.writeAttribute(writer, "cellspacing", (Object)"0");
        utils.writeAttribute(writer, "id", (Object)node.getClientId(context));
        utils.writeAttribute(writer, "style", (Object)"width: 100%;");
        utils.writeAttribute(writer, "rich:nodeId", (Object)node.getId());
        writer.startElement("tbody", (UIComponent)tree);
    }

    private void closeLevelDownTable(FacesContext context, UITree tree, ResponseWriter writer) throws IOException {
        writer.endElement("tbody");
        writer.endElement("table");
    }

    private class DataVisitorWithLastElement
    implements DataVisitor,
    LastElementAware {
        private boolean isLastElement = false;
        private final ResponseWriter writer;
        private final StringHolder holder;
        private final Flag flag;
        private final UITree tree;
        private final TreeDataModelEventNavigator navigator;

        private DataVisitorWithLastElement(ResponseWriter writer, StringHolder holder, Flag flag, UITree tree, TreeDataModelEventNavigator navigator) {
            this.writer = writer;
            this.holder = holder;
            this.flag = flag;
            this.tree = tree;
            this.navigator = navigator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(FacesContext context, Object rowKey, Object argument) throws IOException {
            this.navigator.followRowKey((TreeRowKey)rowKey);
            if (this.tree.isSelected()) {
                this.holder.setValue(this.tree.getNodeFacet().getClientId(context));
            }
            if (!this.flag.isFlagSet()) {
                TreeRendererBase.this.closeLevelDownTable(context, this.tree, this.writer);
                TreeRendererBase.this.openLevelDownTable(context, this.tree, this.writer);
            } else {
                this.flag.resetFlag();
            }
            UITreeNode nodeFacet = this.tree.getNodeFacet();
            Object oldAttrValue = nodeFacet.getAttributes().get("isLastElement");
            try {
                nodeFacet.getAttributes().put("isLastElement", new Boolean(this.isLastElement));
                TreeRendererBase.this.renderChild(context, (UIComponent)nodeFacet);
            }
            finally {
                if (oldAttrValue != null) {
                    nodeFacet.getAttributes().put("isLastElement", oldAttrValue);
                } else {
                    nodeFacet.getAttributes().remove("isLastElement");
                }
            }
        }

        public void setLastElement() {
            this.isLastElement = true;
            this.navigator.setLastElement();
        }

        public void resetLastElement() {
            this.isLastElement = false;
            this.navigator.resetLastElement();
        }
    }
}

