/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.richfaces.org.apache.commons.lang.StringEscapeUtils;

public class TemplateUtil {
    private static final Pattern PARAMETER_REPLACER_PATTERN = Pattern.compile("(\\\\)?\\{([^\\}]+)\\}");

    public static String replaceParams(String string, String paramsVarName) {
        Matcher m = PARAMETER_REPLACER_PATTERN.matcher(string);
        StringBuffer sb = new StringBuffer("\"");
        int lastPosition = 0;
        while (m.find()) {
            String firstGroup = m.group(1);
            if (firstGroup == null || firstGroup.length() == 0) {
                sb.append(StringEscapeUtils.escapeJavaScript(string.substring(lastPosition, m.start(2) - 1)));
                String paramAccess = paramsVarName + "['" + m.group(2) + "']";
                sb.append("\" + ((!!" + paramAccess + ") ? " + paramAccess + " : \"\") + \"");
            } else {
                StringBuffer sbUnEsc = new StringBuffer();
                sbUnEsc.append(string.substring(lastPosition, m.end(1) - 1));
                sbUnEsc.append("{");
                sbUnEsc.append(m.group(2));
                sbUnEsc.append("}");
                sb.append(StringEscapeUtils.escapeJavaScript(sbUnEsc.toString()));
            }
            lastPosition = m.end(2) + 1;
        }
        if (lastPosition < string.length()) {
            sb.append(StringEscapeUtils.escapeJavaScript(string.substring(lastPosition)));
        }
        sb.append("\"");
        return sb.toString();
    }

    public static void main(String[] args) {
        System.out.println(TemplateUtil.replaceParams("test string \" \n with \\{pa\\rams} {name} \"and {value}1", "params"));
    }
}

