/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.util.Map;
import org.ajax4jsf.ajax.repeat.UIDataAdaptor;

public class TableHolder {
    private UIDataAdaptor table;
    private int rowCounter;
    private int gridRowCounter;
    private String[] rowClasses;
    private String[] columnsClasses;

    public TableHolder(UIDataAdaptor table) {
        this.table = table;
        this.rowCounter = 0;
        this.gridRowCounter = 0;
        Map attributes = table.getAttributes();
        String classes = (String)attributes.get("rowClasses");
        if (null != classes) {
            this.rowClasses = classes.split(",");
        }
        if (null != (classes = (String)attributes.get("columnClasses"))) {
            this.columnsClasses = classes.split(",");
        }
    }

    public UIDataAdaptor getTable() {
        return this.table;
    }

    public int getRowCounter() {
        return this.rowCounter;
    }

    public int nextRow() {
        return ++this.rowCounter;
    }

    public String getRowClass() {
        int row = this.rowCounter;
        return this.getRowClass(row);
    }

    public String getRowClass(int row) {
        String rowClass = null;
        if (null != this.rowClasses) {
            rowClass = this.rowClasses[row % this.rowClasses.length];
        }
        return rowClass;
    }

    public String getColumnClass(int columnNumber) {
        String columnClass = null;
        if (null != this.columnsClasses) {
            columnClass = this.columnsClasses[columnNumber % this.columnsClasses.length];
        }
        return columnClass;
    }

    public int getGridRowCounter() {
        return this.gridRowCounter;
    }

    public void setGridRowCounter(int gridRowCounter) {
        this.gridRowCounter = gridRowCounter;
    }
}

