/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component.state;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.faces.application.FacesMessage;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import org.ajax4jsf.ajax.repeat.DataComponentState;
import org.ajax4jsf.ajax.repeat.DataVisitor;
import org.ajax4jsf.ajax.repeat.Range;
import org.richfaces.component.CacheableTreeDataModel;
import org.richfaces.component.TreeRowKey;
import org.richfaces.component.UITree;
import org.richfaces.component.preserve.TreeDataBatchLocator;
import org.richfaces.component.preserve.TreeDataLocator;
import org.richfaces.component.state.TreeRange;
import org.richfaces.component.state.events.TreeStateCommandsListener;

public class TreeState
implements DataComponentState,
TreeStateCommandsListener,
StateHolder {
    private static final TreeRange RANGE_UNCONSTRAINED = new TreeRange(){

        public boolean processChildren(TreeRowKey rowKey) {
            return true;
        }

        public boolean processNode(TreeRowKey rowKey) {
            return true;
        }
    };
    private TreeRowKey selectedNode = null;
    private Set expandedNodes = new HashSet();
    private Set queuedExpandedNodes = new HashSet();
    private Set queuedCollapsedNodes = new HashSet();
    private UITree tree;
    private boolean _transient;
    private boolean stopInCollapsed;
    private transient TreeRange treeRange = null;
    private CacheableTreeDataModel treeDataModel;

    public TreeState(UITree tree, boolean stopInCollapsed) {
        this.stopInCollapsed = stopInCollapsed;
        this.tree = tree;
    }

    public boolean isExpanded(TreeRowKey rowKey) {
        if (rowKey == null) {
            return true;
        }
        return this.expandedNodes.contains(rowKey) || this.queuedExpandedNodes.contains(rowKey);
    }

    public boolean isSelected(TreeRowKey rowKey) {
        return this.selectedNode != null && this.selectedNode.equals(rowKey);
    }

    public boolean setSelected(TreeRowKey rowKey) {
        if (this.selectedNode == null) {
            if (rowKey != null) {
                this.selectedNode = rowKey;
                return true;
            }
            return false;
        }
        if (rowKey != null) {
            if (!this.selectedNode.equals(rowKey)) {
                this.selectedNode = rowKey;
                return true;
            }
            return false;
        }
        this.selectedNode = null;
        return true;
    }

    public Range getRange() {
        if (this.treeRange != null) {
            return this.treeRange;
        }
        if (this.stopInCollapsed) {
            return new TreeRange(){

                public boolean processChildren(TreeRowKey rowKey) {
                    if (rowKey == null) {
                        return true;
                    }
                    return TreeState.this.expandedNodes.contains(rowKey);
                }

                public boolean processNode(TreeRowKey rowKey) {
                    return true;
                }
            };
        }
        return RANGE_UNCONSTRAINED;
    }

    public boolean isTransient() {
        return this._transient;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] _state = (Object[])state;
        this.expandedNodes = (Set)_state[0];
        this._transient = (Boolean)_state[1];
        this.stopInCollapsed = (Boolean)_state[2];
        this.selectedNode = (TreeRowKey)_state[3];
        this.queuedExpandedNodes = (Set)_state[4];
        this.queuedCollapsedNodes = (Set)_state[5];
        this.treeDataModel = (CacheableTreeDataModel)((Object)UIComponentBase.restoreAttachedState((FacesContext)context, (Object)_state[6]));
        ValueBinding treeDataLocatorBinding = this.tree.getValueBinding("treeDataLocator");
        if (treeDataLocatorBinding != null) {
            Object object = treeDataLocatorBinding.getValue(context);
            if (object instanceof TreeDataLocator) {
                final TreeDataLocator treeDataLocator = (TreeDataLocator)object;
                if (this.treeDataModel != null) {
                    try {
                        this.treeDataModel.walk(context, new DataVisitor(){

                            public void process(FacesContext arg0, Object arg1, Object arg2) throws IOException {
                                TreeState.this.treeDataModel.setRowKey(arg1);
                                TreeState.this.treeDataModel.setRowData(treeDataLocator.createData(TreeState.this.treeDataModel.getRowData(), (TreeRowKey)arg1));
                            }
                        }, null, null);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                TreeDataBatchLocator treeDataBatchLocator = (TreeDataBatchLocator)object;
            }
        }
    }

    public Object saveState(FacesContext context) {
        Object[] state = new Object[7];
        state[0] = this.expandedNodes;
        state[1] = new Boolean(this._transient);
        state[2] = new Boolean(this.stopInCollapsed);
        state[3] = this.selectedNode;
        state[4] = this.queuedExpandedNodes;
        state[5] = this.queuedCollapsedNodes;
        if (!"request".equals(this.tree.getPreserveModel())) {
            ValueBinding treeDataLocatorBinding = this.tree.getValueBinding("treeDataLocator");
            if (treeDataLocatorBinding != null) {
                Object object = treeDataLocatorBinding.getValue(context);
                if (object instanceof TreeDataLocator) {
                    final TreeDataLocator treeDataLocator = (TreeDataLocator)object;
                    if (this.treeDataModel != null) {
                        try {
                            this.treeDataModel.walk(context, new DataVisitor(){

                                public void process(FacesContext arg0, Object arg1, Object arg2) throws IOException {
                                    TreeState.this.treeDataModel.setRowKey(arg1);
                                    TreeState.this.treeDataModel.setRowData(treeDataLocator.createLocator(TreeState.this.treeDataModel.getRowData(), (TreeRowKey)arg1));
                                }
                            }, null, null);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    TreeDataBatchLocator treeDataBatchLocator = (TreeDataBatchLocator)object;
                }
            }
            state[6] = UIComponentBase.saveAttachedState((FacesContext)context, (Object)((Object)this.treeDataModel));
        }
        return state;
    }

    public void setTransient(boolean newTransientValue) {
        this._transient = newTransientValue;
    }

    public boolean isStopInCollapsed() {
        return this.stopInCollapsed;
    }

    public void setStopInCollapsed(boolean stopInCollapsed) {
        this.stopInCollapsed = stopInCollapsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visitNodes(TreeRange treeRange, TreeRowKey rootKey) throws IOException {
        try {
            this.treeRange = treeRange;
            Object oldKey = this.tree.getRowKey();
            this.tree.walkModel(FacesContext.getCurrentInstance(), new Visitor(rootKey), rootKey, null);
            this.tree.setRowKey(oldKey);
        }
        finally {
            this.treeRange = null;
        }
    }

    public void expandAll() throws IOException {
        FacesContext context = FacesContext.getCurrentInstance();
        this.queuedCollapsedNodes.clear();
        this.visitNodes(RANGE_UNCONSTRAINED, null);
    }

    public void collapseAll() throws IOException {
        this.expandedNodes.clear();
        this.queuedExpandedNodes.clear();
    }

    public void collapseNode(TreeRowKey rowKey) throws IOException {
        this.expandedNodes.remove(rowKey);
        this.queuedExpandedNodes.remove(rowKey);
        this.queuedCollapsedNodes.add(rowKey);
    }

    public void expandNode(final TreeRowKey rowKey) throws IOException {
        FacesContext context = FacesContext.getCurrentInstance();
        if (this.treeDataModel == null) {
            TreeRange range = new TreeRange(){

                public boolean processChildren(TreeRowKey nextKey) {
                    return true;
                }

                public boolean processNode(TreeRowKey nextKey) {
                    return rowKey == null && nextKey == null || nextKey.equals(rowKey) || nextKey.isSubKey(rowKey);
                }
            };
            this.visitNodes(range, rowKey);
        } else {
            final TreeRange expandedRange = (TreeRange)this.getRange();
            TreeRange range = new TreeRange(){

                public boolean processChildren(TreeRowKey key) {
                    return expandedRange.processChildren(key) || key == null || key.isSubKey(rowKey);
                }

                public boolean processNode(TreeRowKey key) {
                    return expandedRange.processNode(key) || key == null || key.isSubKey(rowKey) || key.equals(rowKey);
                }
            };
            this.visitNodes(range, rowKey);
        }
    }

    public void transferQueuedNodes() {
        this.expandedNodes.addAll(this.queuedExpandedNodes);
        this.queuedExpandedNodes.clear();
        this.expandedNodes.removeAll(this.queuedCollapsedNodes);
        this.queuedCollapsedNodes.clear();
    }

    public CacheableTreeDataModel getTreeDataModel() {
        return this.treeDataModel;
    }

    public void setTreeDataModel(CacheableTreeDataModel treeDataModel) {
        this.treeDataModel = treeDataModel;
    }

    private final class Visitor
    implements DataVisitor {
        private TreeRowKey key;

        public Visitor(TreeRowKey key) {
            this.key = key;
        }

        public void process(FacesContext context, Object rowKey, Object argument) throws IOException {
            TreeState.this.tree.setRowKey(rowKey);
            if (TreeState.this.tree.isRowAvailable()) {
                TreeRowKey nextKey = (TreeRowKey)rowKey;
                if (!TreeState.this.tree.isLeaf() && nextKey != null && (this.key == null || nextKey.isSubKey(this.key) || nextKey.equals(this.key))) {
                    if (TreeState.this.tree.isImmediate()) {
                        TreeState.this.queuedExpandedNodes.add(nextKey);
                    } else {
                        TreeState.this.expandedNodes.add(nextKey);
                    }
                    TreeState.this.queuedCollapsedNodes.remove(nextKey);
                }
            } else {
                FacesMessage message = new FacesMessage("Row key: " + rowKey + " isn't available!");
                message.setSeverity(FacesMessage.SEVERITY_ERROR);
                context.addMessage(TreeState.this.tree.getBaseClientId(context), message);
            }
        }
    }
}

