/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.util;

import java.io.UnsupportedEncodingException;

public class UnicodeUtil {
    public static final int CharWidthC = 2;
    private static boolean encodingAvailable = true;

    private UnicodeUtil() {
    }

    public static char[] bigUnicode2Chars(byte[] byArray, int n, int n2) {
        char[] cArray = new char[n2 / 2];
        int n3 = n2 / 2;
        int n4 = 0;
        while (n4 < n3) {
            int n5;
            int n6 = byArray[n + 2 * n4];
            if (n6 < 0) {
                n6 += 256;
            }
            if ((n5 = byArray[n + (2 * n4 + 1)]) < 0) {
                n5 += 256;
            }
            int n7 = (n6 << 8) + n5;
            cArray[n4] = (char)n7;
            ++n4;
        }
        return cArray;
    }

    public static char[] bigUnicode2Chars(byte[] byArray) {
        return UnicodeUtil.bigUnicode2Chars(byArray, 0, byArray.length);
    }

    public static String bigUnicode2String(byte[] byArray) {
        String string;
        if (encodingAvailable) {
            try {
                string = new String(byArray, "UTF-16BE");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string = new String(UnicodeUtil.bigUnicode2Chars(byArray));
                encodingAvailable = false;
            }
        } else {
            string = new String(UnicodeUtil.bigUnicode2Chars(byArray));
        }
        return string;
    }

    public static byte[] char2BigUnicode(char[] cArray) {
        int n = cArray.length;
        byte[] byArray = new byte[cArray.length * 2];
        UnicodeUtil.charIntoBytes(cArray, byArray, 0);
        return byArray;
    }

    public static void charIntoBytes(char[] cArray, byte[] byArray, int n) {
        int n2 = cArray.length;
        int n3 = 0;
        while (n3 < n2) {
            char c = cArray[n3];
            byArray[n3 * 2 + n] = (byte)(c / 256);
            byArray[n3 * 2 + n + 1] = (byte)(c % 256);
            ++n3;
        }
    }
}

