/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import EDU.oswego.cs.dl.util.concurrent.CopyOnWriteArraySet;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.transaction.Status;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.DataNode;
import org.jboss.cache.ExtendedTreeCacheListener;
import org.jboss.cache.Fqn;
import org.jboss.cache.GlobalTransaction;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.Node;
import org.jboss.cache.NodeNotExistsException;
import org.jboss.cache.OptimisticTransactionEntry;
import org.jboss.cache.OptimisticTreeNode;
import org.jboss.cache.RegionNotEmptyException;
import org.jboss.cache.ReplicationException;
import org.jboss.cache.ReplicationQueue;
import org.jboss.cache.SuspectException;
import org.jboss.cache.TransactionEntry;
import org.jboss.cache.TransactionManagerLookup;
import org.jboss.cache.TransactionTable;
import org.jboss.cache.TreeCacheListener;
import org.jboss.cache.TreeCacheMBean;
import org.jboss.cache.TreeNode;
import org.jboss.cache.Version;
import org.jboss.cache.buddyreplication.BuddyGroup;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.cache.buddyreplication.BuddyNotInitException;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.Option;
import org.jboss.cache.eviction.EvictionPolicy;
import org.jboss.cache.factories.InterceptorChainFactory;
import org.jboss.cache.factories.NodeFactory;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.loader.CacheLoaderManager;
import org.jboss.cache.loader.NodeData;
import org.jboss.cache.lock.IdentityLock;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.lock.LockStrategyFactory;
import org.jboss.cache.lock.LockingException;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.cache.marshall.JBCMethodCall;
import org.jboss.cache.marshall.MethodCallFactory;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jboss.cache.marshall.Region;
import org.jboss.cache.marshall.RegionManager;
import org.jboss.cache.marshall.RegionNameConflictException;
import org.jboss.cache.marshall.RegionNotFoundException;
import org.jboss.cache.marshall.VersionAwareMarshaller;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.statetransfer.StateTransferFactory;
import org.jboss.cache.statetransfer.StateTransferGenerator;
import org.jboss.cache.statetransfer.StateTransferIntegrator;
import org.jboss.cache.util.MBeanConfigurator;
import org.jboss.invocation.MarshalledValueOutputStream;
import org.jboss.system.ServiceMBeanSupport;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.View;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class TreeCache
extends ServiceMBeanSupport
implements TreeCacheMBean,
Cloneable,
MembershipListener {
    private static final String CREATE_MUX_CHANNEL = "createMultiplexerChannel";
    private static final String[] MUX_TYPES = new String[]{"java.lang.String", "java.lang.String"};
    private static final String JBOSS_SERVER_DOMAIN = "jboss";
    private boolean forceAnycast = false;
    public static final short DEFAULT_REPLICATION_VERSION = Version.getVersionShort();
    protected DataNode root = NodeFactory.getInstance().createRootDataNode((byte)1, this);
    private final Set listeners = new CopyOnWriteArraySet();
    protected boolean hasListeners = false;
    TreeCacheListener evictionPolicyListener = null;
    static final Object NULL = new Object();
    protected JChannel channel = null;
    protected String mux_serviceName = null;
    protected String mux_stackName = "udp";
    protected boolean using_mux = false;
    protected boolean coordinator = false;
    protected static final Log log = LogFactory.getLog((Class)TreeCache.class);
    protected String cluster_name = "TreeCache-Group";
    protected String cluster_props = null;
    protected final Vector members = new Vector();
    protected RpcDispatcher disp = null;
    protected MessageListener ml = new MessageListenerAdaptor(log);
    protected boolean use_repl_queue = false;
    protected int repl_queue_max_elements = 1000;
    protected long repl_queue_interval = 5000L;
    protected boolean use_interceptor_mbeans = true;
    private final TransactionTable tx_table = new TransactionTable();
    private final Map lock_table = new ConcurrentHashMap();
    protected boolean fetchInMemoryState = true;
    protected boolean usingEviction = false;
    private short replication_version = DEFAULT_REPLICATION_VERSION;
    private String repl_version_string = Version.getVersionString(DEFAULT_REPLICATION_VERSION);
    protected long lock_acquisition_timeout = 10000L;
    protected long state_fetch_timeout = this.lock_acquisition_timeout + 5000L;
    protected long sync_repl_timeout = 15000L;
    protected String eviction_policy_class = null;
    protected int cache_mode = 1;
    protected boolean inactiveOnStartup = false;
    protected boolean isStandalone = false;
    protected Set internalFqns = new CopyOnWriteArraySet();
    protected boolean isStateSet = false;
    protected Exception setStateException;
    private final Object stateLock = new Object();
    protected IsolationLevel isolationLevel = IsolationLevel.REPEATABLE_READ;
    private ThreadLocal invocationContextContainer = new ThreadLocal();
    protected Element evictConfig_ = null;
    protected String evictionInterceptorClass = "org.jboss.cache.interceptors.EvictionInterceptor";
    protected boolean useRegionBasedMarshalling = false;
    protected VersionAwareMarshaller marshaller_ = null;
    protected RegionManager regionManager_ = null;
    protected org.jboss.cache.eviction.RegionManager evictionRegionManager_ = null;
    protected Interceptor interceptor_chain = null;
    protected TransactionManagerLookup tm_lookup = null;
    protected String tm_lookup_class = null;
    protected TransactionManager tm = null;
    protected Element cacheLoaderConfig = null;
    protected CacheLoaderManager cacheLoaderManager;
    protected CacheLoaderConfig cloaderConfig;
    protected boolean sync_commit_phase = false;
    protected boolean sync_rollback_phase = false;
    protected EvictionPolicy eviction_policy_provider;
    protected ReplicationQueue repl_queue = null;
    public static final String SEPARATOR = "/";
    public static final int LOCAL = 1;
    public static final int REPL_ASYNC = 2;
    public static final int REPL_SYNC = 3;
    public static final int INVALIDATION_ASYNC = 4;
    public static final int INVALIDATION_SYNC = 5;
    public static final String UNINITIALIZED = "jboss:internal:uninitialized";
    protected boolean nodeLockingOptimistic = false;
    protected boolean useCreateService = false;
    protected Element buddyReplicationConfig;
    protected BuddyManager buddyManager;
    protected final Set activationChangeNodes = new HashSet();

    public TreeCache(String cluster_name, String props, long state_fetch_timeout) throws Exception {
        if (cluster_name != null) {
            this.cluster_name = cluster_name;
        }
        if (props != null) {
            this.cluster_props = props;
        }
        this.state_fetch_timeout = state_fetch_timeout;
    }

    public TreeCache() throws Exception {
    }

    public TreeCache(JChannel channel) throws Exception {
        this.channel = channel;
    }

    public String getVersion() {
        return Version.printVersion();
    }

    public DataNode getRoot() {
        return this.root;
    }

    public Object getLocalAddress() {
        return this.channel != null ? this.channel.getLocalAddress() : null;
    }

    public Vector getMembers() {
        return this.members;
    }

    public boolean isCoordinator() {
        return this.coordinator;
    }

    public String getClusterName() {
        return this.cluster_name;
    }

    public void setClusterName(String name) {
        this.cluster_name = name;
    }

    public String getClusterProperties() {
        return this.cluster_props;
    }

    public void setClusterProperties(String cluster_props) {
        this.cluster_props = cluster_props;
    }

    public String getMultiplexerService() {
        return this.mux_serviceName;
    }

    public void setMultiplexerService(String serviceName) {
        this.mux_serviceName = serviceName;
    }

    public String getMultiplexerStack() {
        return this.mux_stackName;
    }

    public void setMultiplexerStack(String name) {
        this.mux_stackName = name;
    }

    public boolean isUsingMultiplexer() {
        return this.using_mux;
    }

    public boolean isForceAnycast() {
        return this.forceAnycast;
    }

    public void setForceAnycast(boolean b) {
        this.forceAnycast = b;
    }

    public TransactionTable getTransactionTable() {
        return this.tx_table;
    }

    public Map getLockTable() {
        return this.lock_table;
    }

    public String dumpTransactionTable() {
        return this.tx_table.toString(true);
    }

    public boolean getDeadlockDetection() {
        return false;
    }

    public void setDeadlockDetection(boolean dt) {
        log.warn((Object)"Using deprecated configuration element 'DeadlockDetection'.  Will be ignored.");
    }

    public String getInterceptorChain() {
        String retval = InterceptorChainFactory.printInterceptorChain(this.interceptor_chain);
        if (retval == null || retval.length() == 0) {
            return "<empty>";
        }
        return retval;
    }

    public void setInterceptorChain(Interceptor i) {
        this.interceptor_chain = i;
    }

    public List getInterceptors() {
        return InterceptorChainFactory.asList(this.interceptor_chain);
    }

    public Element getCacheLoaderConfiguration() {
        return this.cacheLoaderConfig;
    }

    public void setCacheLoaderConfiguration(Element cache_loader_config) {
        if (this.cloaderConfig != null) {
            log.warn((Object)"Specified CacheLoaderConfig XML block will be ignored, because deprecated setters are used!");
        }
        this.cacheLoaderConfig = cache_loader_config;
    }

    public CacheLoader getCacheLoader() {
        if (this.cacheLoaderManager == null) {
            return null;
        }
        return this.cacheLoaderManager.getCacheLoader();
    }

    public void setPojoCacheConfig(Element config) throws CacheException {
        log.warn((Object)"setPojoCacheConfig(): You have a PojoCache config that is not used in TreeCache.");
    }

    public Element getPojoCacheConfig() {
        return null;
    }

    public MessageListener getMessageListener() {
        return this.ml;
    }

    public boolean isInactiveOnStartup() {
        return this.inactiveOnStartup;
    }

    public void setInactiveOnStartup(boolean inactiveOnStartup) {
        this.inactiveOnStartup = inactiveOnStartup;
    }

    public boolean getSyncCommitPhase() {
        return this.sync_commit_phase;
    }

    public void setSyncCommitPhase(boolean sync_commit_phase) {
        this.sync_commit_phase = sync_commit_phase;
    }

    public boolean getSyncRollbackPhase() {
        return this.sync_rollback_phase;
    }

    public void setSyncRollbackPhase(boolean sync_rollback_phase) {
        this.sync_rollback_phase = sync_rollback_phase;
    }

    public void setEvictionPolicyConfig(Element config) {
        this.evictConfig_ = config;
        if (log.isDebugEnabled()) {
            log.debug((Object)("setEvictionPolicyConfig(): " + config));
        }
    }

    public Element getEvictionPolicyConfig() {
        return this.evictConfig_;
    }

    public String getEvictionInterceptorClass() {
        return this.evictionInterceptorClass;
    }

    public boolean isUsingEviction() {
        return this.usingEviction;
    }

    public void setIsUsingEviction(boolean usingEviction) {
        this.usingEviction = usingEviction;
    }

    public void setClusterConfig(Element config) {
        StringBuffer buffer = new StringBuffer();
        NodeList stack = config.getChildNodes();
        int length = stack.getLength();
        for (int s = 0; s < length; ++s) {
            org.w3c.dom.Node node = stack.item(s);
            if (node.getNodeType() != 1) continue;
            Element tag = (Element)node;
            String protocol = tag.getTagName();
            buffer.append(protocol);
            NamedNodeMap attrs = tag.getAttributes();
            int attrLength = attrs.getLength();
            if (attrLength > 0) {
                buffer.append('(');
            }
            for (int a = 0; a < attrLength; ++a) {
                Attr attr = (Attr)attrs.item(a);
                String name = attr.getName();
                String value = attr.getValue();
                buffer.append(name);
                buffer.append('=');
                buffer.append(value);
                if (a >= attrLength - 1) continue;
                buffer.append(';');
            }
            if (attrLength > 0) {
                buffer.append(')');
            }
            buffer.append(':');
        }
        buffer.setLength(buffer.length() - 1);
        this.setClusterProperties(buffer.toString());
        if (log.isDebugEnabled()) {
            log.debug((Object)("setting cluster properties from xml to: " + this.cluster_props));
        }
    }

    public long getInitialStateRetrievalTimeout() {
        return this.state_fetch_timeout;
    }

    public void setInitialStateRetrievalTimeout(long timeout) {
        this.state_fetch_timeout = timeout;
    }

    public String getCacheMode() {
        return this.mode2String(this.cache_mode);
    }

    public int getCacheModeInternal() {
        return this.cache_mode;
    }

    private String mode2String(int mode) {
        switch (mode) {
            case 1: {
                return "LOCAL";
            }
            case 2: {
                return "REPL_ASYNC";
            }
            case 3: {
                return "REPL_SYNC";
            }
            case 4: {
                return "INVALIDATION_ASYNC";
            }
            case 5: {
                return "INVALIDATION_SYNC";
            }
        }
        throw new RuntimeException("setCacheMode(): caching mode " + mode + " is invalid");
    }

    public void setNodeLockingScheme(String s) {
        if (s != null) {
            this.setNodeLockingOptimistic(s.trim().equalsIgnoreCase("OPTIMISTIC"));
        }
    }

    public String getNodeLockingScheme() {
        return this.nodeLockingOptimistic ? "OPTIMISTIC" : "PESSIMISTIC";
    }

    protected void setNodeLockingOptimistic(boolean b) {
        this.nodeLockingOptimistic = b;
        if (b) {
            this.root = NodeFactory.getInstance().createRootDataNode((byte)3, this);
            this.isolationLevel = null;
        }
    }

    public boolean isNodeLockingOptimistic() {
        return this.nodeLockingOptimistic;
    }

    public void setCacheMode(String mode) throws Exception {
        int m = this.string2Mode(mode);
        this.setCacheMode(m);
    }

    public void setCacheMode(int mode) {
        if (mode != 1 && mode != 2 && mode != 3 && mode != 4 && mode != 5) {
            throw new IllegalArgumentException("setCacheMode(): caching mode " + mode + " is invalid");
        }
        this.cache_mode = mode;
    }

    public long getSyncReplTimeout() {
        return this.sync_repl_timeout;
    }

    public void setSyncReplTimeout(long timeout) {
        this.sync_repl_timeout = timeout;
    }

    public boolean getUseReplQueue() {
        return this.use_repl_queue;
    }

    public void setUseReplQueue(boolean flag) {
        this.use_repl_queue = flag;
        if (flag) {
            if (this.repl_queue == null) {
                this.repl_queue = new ReplicationQueue(this, this.repl_queue_interval, this.repl_queue_max_elements);
                if (this.repl_queue_interval >= 0L) {
                    this.repl_queue.start();
                }
            }
        } else if (this.repl_queue != null) {
            this.repl_queue.stop();
            this.repl_queue = null;
        }
    }

    public long getReplQueueInterval() {
        return this.repl_queue_interval;
    }

    public void setReplQueueInterval(long interval) {
        this.repl_queue_interval = interval;
        if (this.repl_queue != null) {
            this.repl_queue.setInterval(interval);
        }
    }

    public int getReplQueueMaxElements() {
        return this.repl_queue_max_elements;
    }

    public void setReplQueueMaxElements(int max_elements) {
        this.repl_queue_max_elements = max_elements;
        if (this.repl_queue != null) {
            this.repl_queue.setMax_elements(max_elements);
        }
    }

    public ReplicationQueue getReplQueue() {
        return this.repl_queue;
    }

    public String getIsolationLevel() {
        return this.isolationLevel.toString();
    }

    public void setIsolationLevel(String level) {
        IsolationLevel tmp_level = IsolationLevel.stringToIsolationLevel(level);
        if (tmp_level == null) {
            throw new IllegalArgumentException("TreeCache.setIsolationLevel(): level \"" + level + "\" is invalid");
        }
        this.setIsolationLevel(tmp_level);
    }

    public void setIsolationLevel(IsolationLevel level) {
        this.isolationLevel = level;
        LockStrategyFactory.setIsolationLevel(level);
    }

    public IsolationLevel getIsolationLevelClass() {
        return this.isolationLevel;
    }

    public boolean getFetchStateOnStartup() {
        return !this.inactiveOnStartup && this.buddyManager == null && (this.fetchInMemoryState || this.getFetchPersistentState());
    }

    public void setFetchStateOnStartup(boolean flag) {
        log.warn((Object)"Calls to setFetchStateOnStartup are ignored; configure state transfer using setFetchInMemoryState and any cache loader's FetchPersistentState property");
    }

    public void setFetchInMemoryState(boolean flag) {
        this.fetchInMemoryState = flag;
    }

    public boolean getFetchInMemoryState() {
        return this.fetchInMemoryState;
    }

    public boolean getFetchPersistentState() {
        return this.cacheLoaderManager != null && this.cacheLoaderManager.isFetchPersistentState();
    }

    public long getLockAcquisitionTimeout() {
        return this.lock_acquisition_timeout;
    }

    public void setLockAcquisitionTimeout(long timeout) {
        this.lock_acquisition_timeout = timeout;
    }

    public String getEvictionPolicyClass() {
        return this.eviction_policy_class;
    }

    public void setEvictionPolicyClass(String eviction_policy_class) {
        this.eviction_policy_class = eviction_policy_class;
    }

    public int getEvictionThreadWakeupIntervalSeconds() {
        return this.evictionRegionManager_.getEvictionThreadWakeupIntervalSeconds();
    }

    public void setTransactionManagerLookup(TransactionManagerLookup l) {
        this.tm_lookup = l;
    }

    public String getTransactionManagerLookupClass() {
        return this.tm_lookup_class;
    }

    public void setTransactionManagerLookupClass(String cl) throws Exception {
        this.tm_lookup_class = cl;
    }

    public TransactionManager getTransactionManager() {
        return this.tm;
    }

    public boolean getUseInterceptorMbeans() {
        return this.use_interceptor_mbeans;
    }

    public void setUseInterceptorMbeans(boolean useMbeans) {
        this.use_interceptor_mbeans = useMbeans;
    }

    public TreeCache getInstance() {
        return this;
    }

    public void fetchState(long timeout) throws ChannelClosedException, ChannelNotConnectedException {
        if (this.channel == null) {
            throw new ChannelNotConnectedException();
        }
        boolean rc = this.channel.getState(null, timeout);
        if (log.isDebugEnabled()) {
            if (rc) {
                log.debug((Object)"fetchState(): state was retrieved successfully");
            } else {
                log.debug((Object)"fetchState(): state could not be retrieved (first member)");
            }
        }
    }

    public void setEvictionListener(TreeCacheListener listener) {
        this.evictionPolicyListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTreeCacheListener(TreeCacheListener listener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
            this.hasListeners = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTreeCacheListener(TreeCacheListener listener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
            this.hasListeners = !this.listeners.isEmpty();
        }
    }

    public Collection getTreeCacheListeners() {
        return Collections.unmodifiableCollection(this.listeners);
    }

    public void createService() throws Exception {
        this._createService();
    }

    protected void _createService() throws Exception {
        MBeanServer mbserver;
        if (this.tm_lookup == null && this.tm_lookup_class != null) {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(this.tm_lookup_class);
            this.tm_lookup = (TransactionManagerLookup)clazz.newInstance();
        }
        try {
            if (this.tm_lookup != null) {
                this.tm = this.tm_lookup.getTransactionManager();
            } else {
                log.warn((Object)"No transaction manager lookup class has been defined. Transactions cannot be used");
            }
        }
        catch (Exception e) {
            log.debug((Object)"failed looking up TransactionManager, will not use transactions", (Throwable)e);
        }
        if ((this.cacheLoaderConfig != null || this.cloaderConfig != null) && this.cacheLoaderManager == null) {
            this.initialiseCacheLoaderManager();
        }
        this.createEvictionPolicy();
        this.interceptor_chain = new InterceptorChainFactory().buildInterceptorChain(this);
        boolean bl = this.isStandalone = this.getServiceName() == null;
        if (this.use_interceptor_mbeans && (mbserver = this.getMBeanServer()) != null) {
            MBeanConfigurator.registerInterceptors(mbserver, this, this.isStandalone);
        }
        switch (this.cache_mode) {
            case 1: {
                log.debug((Object)"cache mode is local, will not create the channel");
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                log.debug((Object)("cache mode is " + this.mode2String(this.cache_mode)));
                if (this.channel != null) {
                    log.info((Object)"channel is already running");
                    return;
                }
                if (this.mux_serviceName != null) {
                    this.channel = this.getMultiplexerChannel(this.mux_serviceName, this.mux_stackName);
                }
                if (this.channel != null) {
                    this.using_mux = true;
                    log.info((Object)("Created Multiplexer Channel for cache cluster " + this.cluster_name + " using stack " + this.getMultiplexerStack()));
                } else {
                    int jgVer;
                    if (this.cluster_props == null) {
                        this.cluster_props = this.getDefaultProperties();
                        log.debug((Object)"setting cluster properties to default value");
                    }
                    this.channel = new JChannel(this.cluster_props);
                    for (jgVer = 241; jgVer >= 100; jgVer /= 10) {
                    }
                    if (jgVer < 23) {
                        this.channel.setOpt(4, (Object)Boolean.TRUE);
                    }
                }
                this.channel.setOpt(5, (Object)Boolean.TRUE);
                this.channel.setOpt(6, (Object)Boolean.TRUE);
                this.disp = new RpcDispatcher((Channel)this.channel, this.ml, (MembershipListener)this, (Object)this);
                this.disp.setMarshaller((RpcDispatcher.Marshaller)this.getMarshaller());
                break;
            }
            default: {
                throw new IllegalArgumentException("cache mode " + this.cache_mode + " is invalid");
            }
        }
        this.useCreateService = true;
    }

    public void startService() throws Exception {
        if (!this.useCreateService) {
            this._createService();
        }
        if (this.cacheLoaderManager != null) {
            this.cacheLoaderManager.startCacheLoader();
        }
        boolean startBuddyManager = false;
        switch (this.cache_mode) {
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.channel.connect(this.cluster_name);
                if (log.isInfoEnabled()) {
                    log.info((Object)("TreeCache local address is " + this.channel.getLocalAddress()));
                }
                if (this.getFetchStateOnStartup()) {
                    try {
                        this.fetchStateOnStartup();
                    }
                    catch (Exception e) {
                        this.channel.disconnect();
                        this.channel.close();
                        throw e;
                    }
                }
                startBuddyManager = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("cache mode " + this.cache_mode + " is invalid");
            }
        }
        if (this.cacheLoaderManager != null) {
            this.cacheLoaderManager.preloadCache();
        }
        this.determineCoordinator();
        if (this.buddyManager != null && startBuddyManager) {
            this.buddyManager.init(this);
            if (this.use_repl_queue) {
                log.warn((Object)"Replication queue not supported when using buddy replication.  Disabling repliction queue.");
                this.use_repl_queue = false;
                this.repl_queue = null;
            }
        }
        this.notifyCacheStarted();
    }

    public void destroyService() {
        MBeanServer mbserver;
        if (this.use_interceptor_mbeans && (mbserver = this.getMBeanServer()) != null) {
            try {
                MBeanConfigurator.unregisterInterceptors(mbserver, this, this.isStandalone);
            }
            catch (Exception e) {
                log.error((Object)"failed unregistering cache interceptor mbeans ", (Throwable)e);
            }
        }
    }

    public void stopService() {
        if (this.channel != null) {
            log.info((Object)"stopService(): closing the channel");
            this.channel.close();
            this.channel = null;
        }
        if (this.disp != null) {
            log.info((Object)"stopService(): stopping the dispatcher");
            this.disp.stop();
            this.disp = null;
        }
        if (this.members != null && this.members.size() > 0) {
            this.members.clear();
        }
        this.coordinator = false;
        if (this.repl_queue != null) {
            this.repl_queue.stop();
        }
        if (this.cacheLoaderManager != null) {
            this.cacheLoaderManager.stopCacheLoader();
        }
        this.notifyCacheStopped();
        this.listeners.clear();
        this.hasListeners = false;
        this.evictionPolicyListener = null;
        this.useCreateService = false;
    }

    public void setBuddyReplicationConfig(Element config) {
        if (config != null) {
            this.buddyReplicationConfig = config;
            this.buddyManager = new BuddyManager(config);
            if (!this.buddyManager.isEnabled()) {
                this.buddyManager = null;
            } else {
                this.internalFqns.add(BuddyManager.BUDDY_BACKUP_SUBTREE_FQN);
            }
        }
    }

    public Element getBuddyReplicationConfig() {
        return this.buddyReplicationConfig;
    }

    public BuddyManager getBuddyManager() {
        return this.buddyManager;
    }

    public Set getInternalFqns() {
        return Collections.unmodifiableSet(this.internalFqns);
    }

    protected void createEvictionPolicy() {
        this.evictionRegionManager_ = new org.jboss.cache.eviction.RegionManager();
        if (this.eviction_policy_class != null && this.eviction_policy_class.length() > 0 || org.jboss.cache.eviction.RegionManager.isUsingNewStyleConfiguration(this.getEvictionPolicyConfig())) {
            this.evictionRegionManager_.configure(this);
            this.usingEviction = true;
        } else {
            this.usingEviction = false;
            log.debug((Object)"Not using an EvictionPolicy");
        }
    }

    public void setEvictionPolicyProvider(EvictionPolicy policy) {
        log.debug((Object)"Using deprecated configuration element 'EvictionPolicyProvider'.  This is only provided for 1.2.x backward compatibility and may disappear in future releases.");
        this.eviction_policy_provider = policy;
    }

    public void setUseMarshalling(boolean isTrue) {
        log.warn((Object)"Using deprecated configuration element 'UseMarshalling'.  See 'UseRegionBasedMarshalling' instead.");
        this.useRegionBasedMarshalling = isTrue;
    }

    public boolean getUseMarshalling() {
        return this.useRegionBasedMarshalling;
    }

    public void setUseRegionBasedMarshalling(boolean isTrue) {
        this.useRegionBasedMarshalling = isTrue;
    }

    public boolean getUseRegionBasedMarshalling() {
        return this.useRegionBasedMarshalling;
    }

    public void load(String fqn) throws Exception {
        if (this.cacheLoaderManager != null) {
            this.cacheLoaderManager.preload(Fqn.fromString(fqn), true, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean determineCoordinator() {
        Vector vector = this.members;
        synchronized (vector) {
            Address coord = this.getCoordinator();
            this.coordinator = coord == null ? false : coord.equals(this.getLocalAddress());
            return this.coordinator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Address getCoordinator() {
        if (this.channel == null) {
            return null;
        }
        Vector vector = this.members;
        synchronized (vector) {
            if (this.members.size() == 0) {
                log.debug((Object)"getCoordinator(): waiting on viewAccepted()");
                try {
                    this.members.wait();
                }
                catch (InterruptedException iex) {
                    log.error((Object)"getCoordinator(): Interrupted while waiting for members to be set", (Throwable)iex);
                }
            }
            return this.members.size() > 0 ? (Address)this.members.get(0) : null;
        }
    }

    public byte[] getStateBytes() {
        return this.getMessageListener().getState();
    }

    public void setStateBytes(byte[] state) {
        this.getMessageListener().setState(state);
    }

    public void registerClassLoader(String fqn, ClassLoader cl) throws RegionNameConflictException {
        if (!this.useRegionBasedMarshalling) {
            throw new IllegalStateException("useRegionBasedMarshalling is false; cannot use this method");
        }
        this.getMarshaller().registerClassLoader(fqn, cl);
    }

    public void unregisterClassLoader(String fqn) throws RegionNotFoundException {
        if (!this.useRegionBasedMarshalling) {
            throw new IllegalStateException("useRegionBasedMarshalling is false; cannot use this method");
        }
        this.getMarshaller().unregisterClassLoader(fqn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateRegion(String subtreeFqn) throws RegionNotEmptyException, RegionNameConflictException, CacheException {
        Object region;
        if (!this.useRegionBasedMarshalling) {
            throw new IllegalStateException("TreeCache.activateRegion(). useRegionBasedMarshalling flag is not set!");
        }
        Fqn fqn = Fqn.fromString(subtreeFqn);
        DataNode subtreeRoot = this.findNode(fqn);
        if (!this.isNodeEmpty(subtreeRoot)) {
            throw new RegionNotEmptyException("Node " + subtreeRoot.getFqn() + " already exists and is not empty");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("activating " + fqn));
        }
        try {
            List queue;
            Set set = this.activationChangeNodes;
            synchronized (set) {
                this.activationChangeNodes.add(fqn);
            }
            region = this.regionManager_.getRegion(fqn);
            if (region == null) {
                region = this.regionManager_.createRegion(fqn, null, true);
            }
            ((Region)region).startQueuing();
            ClassLoader cl = ((Region)region).getClassLoader();
            if (BuddyManager.isBackupFqn(fqn)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Not attempting to load state for a buddy backup Fqn that has just been activated: " + fqn));
                }
            } else if (this.buddyManager == null) {
                if (subtreeRoot == null) {
                    subtreeRoot = this.createSubtreeRootNode(fqn);
                }
                this.loadState(subtreeRoot, cl);
            } else {
                List buddies = this.buddyManager.getBuddyAddresses();
                Iterator it = buddies.iterator();
                while (it.hasNext()) {
                    Address buddy = (Address)it.next();
                    Object[] sources = new Object[]{buddy};
                    Fqn base = new Fqn(BuddyManager.BUDDY_BACKUP_SUBTREE_FQN, BuddyManager.getGroupNameFromAddress(buddy));
                    Fqn buddyRoot = new Fqn(base, fqn);
                    subtreeRoot = this.findNode(buddyRoot);
                    if (subtreeRoot == null) {
                        subtreeRoot = this.createSubtreeRootNode(buddyRoot);
                    }
                    this._loadState(fqn, subtreeRoot, sources, cl);
                }
            }
            List list = queue = ((Region)region).getMethodCallQueue();
            synchronized (list) {
                this.processQueuedMethodCalls(queue);
                ((Region)region).activate();
            }
        }
        catch (Throwable t) {
            log.error((Object)("failed to activate " + subtreeFqn), t);
            try {
                this.inactivateRegion(subtreeFqn);
            }
            catch (Exception e) {
                log.error((Object)("failed inactivating " + subtreeFqn), (Throwable)e);
            }
            if (t instanceof RegionNameConflictException) {
                throw (RegionNameConflictException)t;
            }
            if (t instanceof RegionNotEmptyException) {
                throw (RegionNotEmptyException)t;
            }
            if (t instanceof CacheException) {
                throw (CacheException)t;
            }
            throw new CacheException(t.getClass().getName() + " " + t.getLocalizedMessage(), t);
        }
        finally {
            region = this.activationChangeNodes;
            synchronized (region) {
                this.activationChangeNodes.remove(fqn);
            }
        }
    }

    private boolean isNodeEmpty(DataNode node) {
        boolean empty = true;
        if (node != null) {
            Set keys;
            empty = node.hasChildren() ? false : (keys = node.getDataKeys()) == null || keys.size() == 0;
        }
        return empty;
    }

    private void loadState(DataNode subtreeRoot, ClassLoader cl) throws Exception {
        Object[] mbrArray = this.getMembers().toArray();
        this._loadState(subtreeRoot.getFqn(), subtreeRoot, mbrArray, cl);
    }

    public void _loadState(Fqn subtreeRoot, Fqn integrationRoot, Object[] sources, ClassLoader cl) throws Exception {
        Node target = this.findNode(integrationRoot);
        if (target == null) {
            Option option = new Option();
            option.setCacheModeLocal(true);
            this.put(integrationRoot, null, option);
            target = this.findNode(integrationRoot);
        }
        this._loadState(subtreeRoot, target, sources, cl);
    }

    public void _loadState(Fqn subtreeRoot, DataNode integrationRoot, Object[] sources, ClassLoader cl) throws Exception {
        long[] timeouts = new long[]{400L, 800L, 1600L};
        Object ourself = this.getLocalAddress();
        boolean stateSet = false;
        TimeoutException timeoutException = null;
        Object timeoutTarget = null;
        boolean trace = log.isTraceEnabled();
        for (int i = 0; i < timeouts.length; ++i) {
            timeoutException = null;
            Boolean force = i == timeouts.length - 1 ? Boolean.TRUE : Boolean.FALSE;
            JBCMethodCall psmc = MethodCallFactory.create(MethodDeclarations.getPartialStateMethod, new Object[]{subtreeRoot, new Long(timeouts[i]), force, Boolean.FALSE});
            JBCMethodCall replPsmc = MethodCallFactory.create(MethodDeclarations.replicateMethod, new Object[]{psmc});
            for (int j = 0; j < sources.length; ++j) {
                Object target = sources[j];
                if (ourself.equals(target)) continue;
                Vector<Object> targets = new Vector<Object>();
                targets.add(target);
                List responses = null;
                try {
                    responses = this.callRemoteMethods(targets, (MethodCall)replPsmc, true, true, this.sync_repl_timeout);
                }
                catch (Exception t) {
                    if (!(t.getCause() instanceof TimeoutException)) {
                        throw t;
                    }
                    timeoutException = (TimeoutException)t.getCause();
                    timeoutTarget = target;
                    if (!trace) continue;
                    log.trace((Object)("TreeCache.activateRegion(): " + ourself + " got a TimeoutException from " + target));
                    continue;
                }
                Object rsp = null;
                if (responses != null && responses.size() > 0) {
                    rsp = responses.get(0);
                    if (rsp instanceof byte[]) {
                        this._setState((byte[])rsp, integrationRoot, cl);
                        stateSet = true;
                        if (!log.isDebugEnabled()) break;
                        log.debug((Object)("TreeCache.activateRegion(): " + ourself + " got state from " + target));
                        break;
                    }
                    if (rsp instanceof TimeoutException) {
                        timeoutException = rsp;
                        timeoutTarget = target;
                        if (trace) {
                            log.trace((Object)("TreeCache.activateRegion(): " + ourself + " got a TimeoutException from " + target));
                        }
                    }
                }
                if (!trace) continue;
                log.trace((Object)("TreeCache.activateRegion(): " + ourself + " No usable response from node " + target + (rsp == null ? "" : " -- received " + rsp)));
            }
            if (stateSet || timeoutException == null) break;
        }
        if (!stateSet) {
            if (timeoutException != null) {
                throw new CacheException("Failed getting state due to timeout on " + timeoutTarget, timeoutException);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"TreeCache.activateRegion(): No nodes able to give state");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataNode createSubtreeRootNode(Fqn subtree) throws CacheException {
        DataNode parent = this.root;
        DataNode child = null;
        Object owner = this.getOwnerForLock();
        Object name = null;
        NodeFactory factory = NodeFactory.getInstance();
        byte type = this.isNodeLockingOptimistic() ? (byte)3 : 1;
        for (int i = 0; i < subtree.size(); ++i) {
            name = subtree.get(i);
            child = (DataNode)parent.getChild(name);
            if (child == null) {
                try {
                    parent.acquire(owner, this.state_fetch_timeout, 2);
                }
                catch (InterruptedException e) {
                    log.error((Object)("Interrupted while locking" + parent.getFqn()), (Throwable)e);
                    throw new CacheException(e.getLocalizedMessage(), e);
                }
                try {
                    child = factory.createDataNode(type, name, subtree.getFqnChild(i + 1), parent, null, this);
                    parent.addChild(name, child);
                }
                finally {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("forcing release of locks in " + parent.getFqn()));
                    }
                    try {
                        parent.releaseForce();
                    }
                    catch (Throwable t) {
                        log.error((Object)"failed releasing locks", t);
                    }
                }
            }
            parent = child;
        }
        return child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void inactivateRegion(String subtreeFqn) throws RegionNameConflictException, CacheException {
        Throwable t22;
        boolean subtreeLocked;
        boolean parentLocked;
        TreeNode subtreeRoot;
        TreeNode parent;
        Fqn fqn;
        block29: {
            Set buddies;
            if (!this.useRegionBasedMarshalling) {
                throw new IllegalStateException("TreeCache.inactivate(). useRegionBasedMarshalling flag is not set!");
            }
            fqn = Fqn.fromString(subtreeFqn);
            parent = null;
            subtreeRoot = null;
            parentLocked = false;
            subtreeLocked = false;
            if (log.isDebugEnabled()) {
                log.debug((Object)("inactivating " + fqn));
            }
            Set set = this.activationChangeNodes;
            synchronized (set) {
                this.activationChangeNodes.add(fqn);
            }
            boolean inactive = this.marshaller_.isInactive(subtreeFqn);
            if (!inactive) {
                this.marshaller_.inactivate(subtreeFqn);
            }
            ArrayList<Fqn> list = new ArrayList<Fqn>();
            list.add(fqn);
            if (this.buddyManager != null && (buddies = this.getChildrenNames(BuddyManager.BUDDY_BACKUP_SUBTREE_FQN)) != null) {
                Iterator it = buddies.iterator();
                while (it.hasNext()) {
                    Fqn base = new Fqn(BuddyManager.BUDDY_BACKUP_SUBTREE_FQN, it.next());
                    list.add(new Fqn(base, fqn));
                }
            }
            Iterator it = list.iterator();
            while (it.hasNext()) {
                Fqn subtree = (Fqn)it.next();
                subtreeRoot = this.findNode(subtree);
                if (subtreeRoot == null) continue;
                Object owner = this.getOwnerForLock();
                subtreeRoot.acquireAll(owner, this.state_fetch_timeout, 2);
                subtreeLocked = true;
                parent = (DataNode)subtreeRoot.getParent();
                if (parent != null) {
                    parent.acquire(owner, this.state_fetch_timeout, 2);
                    parentLocked = true;
                }
                this._evictSubtree(subtree);
                if (parent != null) {
                    log.debug((Object)"forcing release of locks in parent");
                    parent.releaseAllForce();
                }
                parentLocked = false;
                log.debug((Object)"forcing release of all locks in subtree");
                subtreeRoot.releaseAllForce();
                subtreeLocked = false;
            }
            Object var13_15 = null;
            if (!parentLocked) break block29;
            log.debug((Object)"forcing release of locks in parent");
            try {
                parent.releaseAllForce();
            }
            catch (Throwable t22) {
                log.error((Object)"failed releasing locks", t22);
            }
        }
        if (subtreeLocked) {
            log.debug((Object)"forcing release of all locks in subtree");
            try {
                subtreeRoot.releaseAllForce();
            }
            catch (Throwable t22) {
                log.error((Object)"failed releasing locks", t22);
            }
        }
        Set set = this.activationChangeNodes;
        synchronized (set) {
            this.activationChangeNodes.remove(fqn);
        }
        {
            catch (InterruptedException ie) {
                throw new CacheException("Interrupted while acquiring lock", ie);
            }
        }
        catch (Throwable throwable) {
            Throwable t22;
            Object var13_16 = null;
            if (parentLocked) {
                log.debug((Object)"forcing release of locks in parent");
                try {
                    parent.releaseAllForce();
                }
                catch (Throwable t22) {
                    log.error((Object)"failed releasing locks", t22);
                }
            }
            if (subtreeLocked) {
                log.debug((Object)"forcing release of all locks in subtree");
                try {
                    subtreeRoot.releaseAllForce();
                }
                catch (Throwable t22) {
                    log.error((Object)"failed releasing locks", t22);
                }
            }
            Set set2 = this.activationChangeNodes;
            synchronized (set2) {
                this.activationChangeNodes.remove(fqn);
            }
            throw throwable;
        }
    }

    protected void _evictSubtree(Fqn subtree) throws CacheException {
        Set children;
        if (!this.exists(subtree)) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("_evictSubtree(" + subtree + ")"));
        }
        if ((children = this.getChildrenNames(subtree)) != null) {
            Object[] kids = children.toArray();
            for (int i = 0; i < kids.length; ++i) {
                Object s = kids[i];
                Fqn tmp = new Fqn(subtree, s);
                this._remove(null, tmp, false, false, true);
            }
        }
        this._remove(null, subtree, false, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _enqueueMethodCall(String subtree, MethodCall call) throws Throwable {
        List queue;
        JBCMethodCall jbcCall = (JBCMethodCall)call;
        Region region = this.regionManager_.getRegion(subtree);
        if (region == null) {
            throw new IllegalStateException("No region found for " + subtree);
        }
        List list = queue = region.getMethodCallQueue();
        synchronized (list) {
            switch (region.getStatus()) {
                case 0: {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("_enqueueMethodCall(): Invoking " + call.getName() + " on subtree " + subtree));
                    }
                    call.invoke((Object)this);
                    break;
                }
                case 2: {
                    JBCMethodCall mc;
                    if (jbcCall.getMethodId() == 13 && (mc = (JBCMethodCall)((Object)call.getArgs()[0])).getMethodId() == 19) {
                        return;
                    }
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("_enqueueMethodCall(): Enqueuing " + call.getName() + " " + call.getArgs() + " on subtree " + subtree));
                    }
                    queue.add(jbcCall);
                    break;
                }
                default: {
                    log.trace((Object)("_enqueueMethodCall(): Discarding " + call.getName() + " on subtree " + subtree));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processQueuedMethodCalls(List queue) throws Throwable {
        HashMap<Object, Object> gtxMap = new HashMap<Object, Object>();
        JBCMethodCall call = null;
        JBCMethodCall wrapped = null;
        Iterator iter = queue.iterator();
        block9: while (iter.hasNext()) {
            call = (JBCMethodCall)((Object)iter.next());
            boolean forgive = false;
            if (call.getMethodId() == 13) {
                Object[] args = call.getArgs();
                wrapped = (JBCMethodCall)((Object)args[0]);
                switch (wrapped.getMethodId()) {
                    case 10: {
                        args = wrapped.getArgs();
                        gtxMap.put(args[0], NULL);
                        break;
                    }
                    case 11: 
                    case 12: {
                        args = wrapped.getArgs();
                        if (gtxMap.remove(args[0]) != null) break;
                        continue block9;
                    }
                }
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("processing queued method call " + call.getName()));
            }
            try {
                call.invoke(this);
            }
            catch (Exception e) {
                if (forgive) continue;
                throw e;
            }
            finally {
                this.setInvocationContext(null);
            }
        }
    }

    public byte[] _getState(Fqn fqn, long timeout, boolean force, boolean suppressErrors) throws Throwable {
        return this._getState(fqn, this.fetchInMemoryState, this.getFetchPersistentState(), timeout, force, suppressErrors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] _getState(Fqn fqn, boolean fetchTransientState, boolean fetchPersistentState, long timeout, boolean force, boolean suppressErrors) throws Throwable {
        Node rootNode;
        if (this.marshaller_ != null) {
            Set set = this.activationChangeNodes;
            synchronized (set) {
                if (this.activationChangeNodes.contains(fqn)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("ignoring _getState() for " + fqn + " as it is being activated/inactivated"));
                    }
                    return null;
                }
            }
            if (this.marshaller_.isInactive(fqn.toString())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("ignoring _getState() for inactive region " + fqn));
                }
                return null;
            }
        }
        if ((rootNode = this.findNode(fqn)) == null) {
            return null;
        }
        boolean getRoot = rootNode.equals(this.root);
        if (fetchPersistentState && !getRoot && !this.cacheLoaderManager.isExtendedCacheLoader()) {
            throw new UnsupportedOperationException("Cache loader does not support ExtendedCacheLoader; partial state transfer not supported");
        }
        Object owner = this.getOwnerForLock();
        try {
            if (fetchTransientState || fetchPersistentState) {
                if (log.isDebugEnabled()) {
                    log.info((Object)("locking the subtree at " + fqn + " to transfer state"));
                }
                this.acquireLocksForStateTransfer(rootNode, owner, timeout, true, force);
            }
            StateTransferGenerator generator = StateTransferFactory.getStateTransferGenerator(this);
            byte[] byArray = generator.generateStateTransfer(rootNode, fetchTransientState, fetchPersistentState, suppressErrors);
            return byArray;
        }
        finally {
            this.releaseStateTransferLocks(rootNode, owner, true);
        }
    }

    protected byte[] _getAssociatedState(Fqn fqn, long timeout, boolean force) throws Exception {
        return null;
    }

    public void _setState(byte[] new_state, Fqn targetRoot, ClassLoader cl) throws Exception {
        Node target = this.findNode(targetRoot);
        if (target == null) {
            Option option = new Option();
            option.setCacheModeLocal(true);
            this.put(targetRoot, null, option);
            target = this.findNode(targetRoot);
        }
        this._setState(new_state, target, cl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _setState(byte[] new_state, DataNode targetRoot, ClassLoader cl) throws Exception {
        if (new_state == null) {
            log.info((Object)"new_state is null (may be first member in cluster)");
            return;
        }
        log.info((Object)("received the state (size=" + new_state.length + " bytes)"));
        Object owner = this.getOwnerForLock();
        try {
            this.acquireLocksForStateTransfer(targetRoot, owner, this.state_fetch_timeout, true, true);
            StateTransferIntegrator integrator = StateTransferFactory.getStateTransferIntegrator(new_state, targetRoot.getFqn(), this);
            try {
                integrator.integrateTransientState(targetRoot, cl);
                this.notifyAllNodesCreated(targetRoot);
            }
            catch (Throwable t) {
                log.error((Object)"failed setting transient state", t);
            }
            integrator.integratePersistentState();
        }
        finally {
            this.releaseStateTransferLocks(targetRoot, owner, true);
        }
    }

    public String getReplicationVersion() {
        return this.repl_version_string;
    }

    public void setReplicationVersion(String versionString) {
        short version;
        this.replication_version = version = Version.getVersionShort(versionString);
        this.repl_version_string = versionString;
        if (Version.isBefore124(version)) {
            Fqn.REL_123_COMPATIBLE = true;
        }
    }

    public short getReplicationVersionShort() {
        return this.replication_version;
    }

    public short getStateTransferVersion() {
        return this.getReplicationVersionShort();
    }

    public void setStateTransferVersion(short version) {
        this.setReplicationVersion(Version.getVersionString(version));
    }

    protected void acquireLocksForStateTransfer(DataNode root, Object lockOwner, long timeout, boolean lockChildren, boolean force) throws Exception {
        try {
            if (lockChildren) {
                root.acquireAll(lockOwner, timeout, 1);
            } else {
                root.acquire(lockOwner, timeout, 1);
            }
        }
        catch (TimeoutException te) {
            log.error((Object)("Caught TimeoutException acquiring locks on region " + root.getFqn()), (Throwable)te);
            if (force) {
                throw te;
            }
            throw te;
        }
    }

    protected void releaseStateTransferLocks(DataNode root, Object lockOwner, boolean childrenLocked) {
        try {
            if (childrenLocked) {
                root.releaseAll(lockOwner);
            } else {
                root.release(lockOwner);
            }
        }
        catch (Throwable t) {
            log.error((Object)"failed releasing locks", t);
        }
    }

    protected void forceAcquireLock(DataNode node, Object newOwner, boolean lockChildren) {
        IdentityLock lock = node.getLock();
        boolean acquired = lock.isOwner(newOwner);
        if (!acquired && log.isDebugEnabled()) {
            log.debug((Object)("Force acquiring lock on node " + node.getFqn()));
        }
        while (!acquired) {
            Iterator it;
            Object curOwner = null;
            boolean attempted = false;
            while (!acquired && (curOwner = lock.getWriterOwner()) != null) {
                acquired = this.acquireLockFromOwner(node, lock, curOwner, newOwner);
                attempted = true;
            }
            if (!acquired && this.isolationLevel == IsolationLevel.SERIALIZABLE && (it = lock.getReaderOwners().iterator()).hasNext()) {
                curOwner = it.next();
                acquired = this.acquireLockFromOwner(node, lock, it.next(), newOwner);
                attempted = true;
            }
            if (acquired || attempted) continue;
            try {
                acquired = node.acquire(newOwner, 1L, 1);
            }
            catch (Exception ignored) {}
        }
        if (lockChildren && node.hasChildren()) {
            Collection children = node.getChildren().values();
            Iterator it = children.iterator();
            while (it.hasNext()) {
                this.forceAcquireLock((DataNode)it.next(), newOwner, true);
            }
        }
    }

    private boolean acquireLockFromOwner(DataNode node, IdentityLock lock, Object curOwner, Object newOwner) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Attempting to acquire lock for node " + node.getFqn() + " from owner " + curOwner));
        }
        boolean acquired = false;
        boolean broken = false;
        int tryCount = 0;
        int lastStatus = Integer.MIN_VALUE;
        while (!broken && !acquired) {
            if (curOwner instanceof GlobalTransaction) {
                int status = this.breakTransactionLock((GlobalTransaction)curOwner, lock, lastStatus, tryCount);
                if (status == Integer.MIN_VALUE) {
                    broken = true;
                } else if (status != lastStatus) {
                    tryCount = 0;
                }
                lastStatus = status;
            } else if (tryCount > 0) {
                lock.release(curOwner);
                broken = true;
            }
            if (broken && log.isTraceEnabled()) {
                log.trace((Object)("Broke lock for node " + node.getFqn() + " held by owner " + curOwner));
            }
            try {
                acquired = node.acquire(newOwner, 1L, 1);
            }
            catch (Exception ignore) {
                // empty catch block
            }
            ++tryCount;
        }
        return acquired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int breakTransactionLock(GlobalTransaction gtx, IdentityLock lock, int lastStatus, int tryCount) {
        int status = 5;
        Transaction tx = this.tx_table.getLocalTransaction(gtx);
        if (tx != null) {
            try {
                status = tx.getStatus();
                if (status != lastStatus) {
                    tryCount = 0;
                }
                switch (status) {
                    case 0: 
                    case 1: 
                    case 5: 
                    case 7: {
                        if (tryCount == 0) {
                            if (log.isTraceEnabled()) {
                                log.trace((Object)("Attempting to break transaction lock held  by " + gtx + " by rolling back local tx"));
                            }
                            this.tm.resume(tx);
                            try {
                                tx.rollback();
                                break;
                            }
                            finally {
                                this.tm.suspend();
                            }
                        }
                        if (tryCount > 100) {
                            lock.release(gtx);
                            status = Integer.MIN_VALUE;
                        }
                        break;
                    }
                    case 8: 
                    case 9: {
                        if (tryCount < 10) break;
                    }
                    case 3: 
                    case 4: 
                    case 6: {
                        lock.release(gtx);
                        status = Integer.MIN_VALUE;
                        break;
                    }
                    case 2: {
                        if (tryCount == 0 && gtx.addr.equals(this.getLocalAddress())) {
                            if (log.isTraceEnabled()) {
                                log.trace((Object)("Attempting to break transaction lock held by " + gtx + " by marking local tx as " + "rollback-only"));
                            }
                            tx.setRollbackOnly();
                            break;
                        }
                        if (tryCount < 10) break;
                    }
                    default: {
                        lock.release(gtx);
                        status = Integer.MIN_VALUE;
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)("Exception breaking locks held by " + gtx), (Throwable)e);
                lock.release(gtx);
                status = Integer.MIN_VALUE;
            }
        } else if (gtx == lock.getWriterOwner() || lock.getReaderOwners().contains(gtx)) {
            lock.release(gtx);
            status = Integer.MIN_VALUE;
        }
        return status;
    }

    private void removeLocksForDeadMembers(DataNode node, Vector deadMembers) {
        HashSet<Object> deadOwners = new HashSet<Object>();
        IdentityLock lock = node.getLock();
        Object owner = lock.getWriterOwner();
        if (this.isLockOwnerDead(owner, deadMembers)) {
            deadOwners.add(owner);
        }
        Iterator iter = lock.getReaderOwners().iterator();
        while (iter.hasNext()) {
            owner = iter.next();
            if (!this.isLockOwnerDead(owner, deadMembers)) continue;
            deadOwners.add(owner);
        }
        iter = deadOwners.iterator();
        while (iter.hasNext()) {
            this.breakTransactionLock(node, lock, (GlobalTransaction)iter.next());
        }
        if (node.hasChildren()) {
            Collection children = node.getChildren().values();
            Iterator it = children.iterator();
            while (it.hasNext()) {
                this.removeLocksForDeadMembers((DataNode)it.next(), deadMembers);
            }
        }
    }

    private void breakTransactionLock(DataNode node, IdentityLock lock, GlobalTransaction gtx) {
        boolean broken = false;
        int tryCount = 0;
        int lastStatus = Integer.MIN_VALUE;
        while (!broken && lock.isOwner(gtx)) {
            int status = this.breakTransactionLock(gtx, lock, lastStatus, tryCount);
            if (status == Integer.MIN_VALUE) {
                broken = true;
            } else if (status != lastStatus) {
                tryCount = 0;
            }
            lastStatus = status;
            if (broken && log.isTraceEnabled()) {
                log.trace((Object)("Broke lock for node " + node.getFqn() + " held by owner " + gtx));
            }
            ++tryCount;
        }
    }

    private boolean isLockOwnerDead(Object owner, Vector deadMembers) {
        boolean result = false;
        if (owner != null && owner instanceof GlobalTransaction) {
            Object addr = ((GlobalTransaction)owner).getAddress();
            result = deadMembers.contains(addr);
        }
        return result;
    }

    public void notifyCallForInactiveSubtree(String fqn) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fetchStateOnStartup() throws Exception {
        this.isStateSet = false;
        long start = System.currentTimeMillis();
        boolean rc = this.channel.getState(null, this.state_fetch_timeout);
        if (rc) {
            Object object = this.stateLock;
            synchronized (object) {
                while (!this.isStateSet) {
                    if (this.setStateException != null) {
                        throw this.setStateException;
                    }
                    try {
                        this.stateLock.wait();
                    }
                    catch (InterruptedException iex) {}
                }
            }
            long stop = System.currentTimeMillis();
            log.info((Object)("state was retrieved successfully (in " + (stop - start) + " milliseconds)"));
        } else {
            this.determineCoordinator();
            if (this.isCoordinator()) {
                log.info((Object)"State could not be retrieved (we are the first member in group)");
            } else {
                throw new CacheException("Initial state transfer failed: Channel.getState() returned false");
            }
        }
    }

    public Node get(String fqn) throws CacheException {
        return this.get(Fqn.fromString(fqn));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataNode get(Fqn fqn, Option option) throws CacheException {
        this.getInvocationContext().setOptionOverrides(option);
        try {
            Node node = this.get(fqn);
            return node;
        }
        finally {
            this.getInvocationContext().setOptionOverrides(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Fqn fqn, Object key, Option option) throws CacheException {
        this.getInvocationContext().setOptionOverrides(option);
        try {
            Object object = this.get(fqn, key);
            return object;
        }
        finally {
            this.getInvocationContext().setOptionOverrides(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Fqn fqn, Object key, boolean sendNodeEvent, Option option) throws CacheException {
        this.getInvocationContext().setOptionOverrides(option);
        try {
            Object object = this.get(fqn, key, sendNodeEvent);
            return object;
        }
        finally {
            this.getInvocationContext().setOptionOverrides(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Fqn fqn, Option option) throws CacheException {
        this.getInvocationContext().setOptionOverrides(option);
        try {
            this.remove(fqn);
        }
        finally {
            this.getInvocationContext().setOptionOverrides(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Fqn fqn, Object key, Option option) throws CacheException {
        this.getInvocationContext().setOptionOverrides(option);
        try {
            Object object = this.remove(fqn, key);
            return object;
        }
        finally {
            this.getInvocationContext().setOptionOverrides(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getChildrenNames(Fqn fqn, Option option) throws CacheException {
        this.getInvocationContext().setOptionOverrides(option);
        try {
            Set set = this.getChildrenNames(fqn);
            return set;
        }
        finally {
            this.getInvocationContext().setOptionOverrides(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Fqn fqn, Map data, Option option) throws CacheException {
        this.getInvocationContext().setOptionOverrides(option);
        try {
            this.put(fqn, data);
        }
        finally {
            this.getInvocationContext().setOptionOverrides(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Fqn fqn, Object key, Object value, Option option) throws CacheException {
        this.getInvocationContext().setOptionOverrides(option);
        try {
            this.put(fqn, key, value);
        }
        finally {
            this.getInvocationContext().setOptionOverrides(null);
        }
    }

    public Node get(Fqn fqn) throws CacheException {
        JBCMethodCall m = MethodCallFactory.create(MethodDeclarations.getNodeMethodLocal, new Object[]{fqn});
        return (Node)this.invokeMethod(m);
    }

    public Node _get(Fqn fqn) throws CacheException {
        return this.findNode(fqn);
    }

    public Map _getData(Fqn fqn) {
        Node n = this.findNode(fqn);
        if (n == null) {
            return null;
        }
        return n.getData();
    }

    public Set getKeys(String fqn) throws CacheException {
        return this.getKeys(Fqn.fromString(fqn));
    }

    public Set getKeys(Fqn fqn) throws CacheException {
        JBCMethodCall m = MethodCallFactory.create(MethodDeclarations.getKeysMethodLocal, new Object[]{fqn});
        return (Set)this.invokeMethod(m);
    }

    public Set _getKeys(Fqn fqn) throws CacheException {
        Node n = this.findNode(fqn);
        if (n == null) {
            return null;
        }
        Set keys = n.getDataKeys();
        if (keys == null) {
            return new HashSet(0);
        }
        return new HashSet(keys);
    }

    public Object get(String fqn, Object key) throws CacheException {
        return this.get(Fqn.fromString(fqn), key);
    }

    public Object get(Fqn fqn, Object key) throws CacheException {
        return this.get(fqn, key, true);
    }

    public Object _get(Fqn fqn, Object key, boolean sendNodeEvent) throws CacheException {
        Node n;
        if (log.isTraceEnabled()) {
            log.trace((Object)new StringBuffer("_get(").append("\"").append(fqn).append("\", ").append(key).append(", \"").append(sendNodeEvent).append("\")"));
        }
        if ((n = this.findNode(fqn)) == null) {
            return null;
        }
        if (sendNodeEvent) {
            this.notifyNodeVisited(fqn);
        }
        return n.get(key);
    }

    protected Object get(Fqn fqn, Object key, boolean sendNodeEvent) throws CacheException {
        JBCMethodCall m = MethodCallFactory.create(MethodDeclarations.getKeyValueMethodLocal, new Object[]{fqn, key, sendNodeEvent});
        return this.invokeMethod(m);
    }

    public Object peek(Fqn fqn, Object key) throws CacheException {
        return this.get(fqn, key, false);
    }

    public DataNode peek(Fqn fqn) {
        return this.findInternal(fqn, true);
    }

    public boolean exists(String fqn) {
        return this.exists(Fqn.fromString(fqn));
    }

    public boolean exists(Fqn fqn) {
        Node n = this.findInternal(fqn, false);
        return n != null;
    }

    private Node findInternal(Fqn fqn, boolean includeNodesMarkedAsRemoved) {
        if (fqn == null || fqn.size() == 0) {
            return (Node)this.root;
        }
        TreeNode n = this.root;
        int fqnSize = fqn.size();
        for (int i = 0; i < fqnSize; ++i) {
            Object obj = fqn.get(i);
            if ((n = n.getChild(obj)) == null) {
                return null;
            }
            if (includeNodesMarkedAsRemoved || !n.isMarkedForRemoval()) continue;
            return null;
        }
        return (Node)n;
    }

    public boolean exists(String fqn, Object key) {
        return this.exists(Fqn.fromString(fqn), key);
    }

    public boolean exists(Fqn fqn, Object key) {
        Node n = this.findInternal(fqn, false);
        return n != null && n.containsKey(key);
    }

    public void put(String fqn, Map data) throws CacheException {
        this.put(Fqn.fromString(fqn), data);
    }

    public void put(Fqn fqn, Map data) throws CacheException {
        GlobalTransaction tx = this.getCurrentTransaction();
        JBCMethodCall m = MethodCallFactory.create(MethodDeclarations.putDataMethodLocal, new Object[]{tx, fqn, data, Boolean.TRUE});
        this.invokeMethod(m);
    }

    public Object put(String fqn, Object key, Object value) throws CacheException {
        return this.put(Fqn.fromString(fqn), key, value);
    }

    public Object putFailFast(Fqn fqn, Object key, Object value, long timeout) throws CacheException {
        GlobalTransaction tx = this.getCurrentTransaction();
        JBCMethodCall m = MethodCallFactory.create(MethodDeclarations.putFailFastKeyValueMethodLocal, new Object[]{tx, fqn, key, value, Boolean.TRUE, new Long(timeout)});
        return this.invokeMethod(m);
    }

    public Object putFailFast(String fqn, Object key, Object value, long timeout) throws CacheException {
        GlobalTransaction tx = this.getCurrentTransaction();
        Fqn fqntmp = Fqn.fromString(fqn);
        JBCMethodCall m = MethodCallFactory.create(MethodDeclarations.putFailFastKeyValueMethodLocal, new Object[]{tx, fqntmp, key, value, Boolean.TRUE, new Long(timeout)});
        return this.invokeMethod(m);
    }

    public Object put(Fqn fqn, Object key, Object value) throws CacheException {
        GlobalTransaction tx = this.getCurrentTransaction();
        JBCMethodCall m = MethodCallFactory.create(MethodDeclarations.putKeyValMethodLocal, new Object[]{tx, fqn, key, value, Boolean.TRUE});
        return this.invokeMethod(m);
    }

    public void remove(String fqn) throws CacheException {
        this.remove(Fqn.fromString(fqn));
    }

    public void remove(Fqn fqn) throws CacheException {
        GlobalTransaction tx = this.getCurrentTransaction();
        JBCMethodCall m = MethodCallFactory.create(MethodDeclarations.removeNodeMethodLocal, new Object[]{tx, fqn, Boolean.TRUE});
        this.invokeMethod(m);
    }

    public void evict(Fqn fqn) throws CacheException {
        JBCMethodCall m = MethodCallFactory.create(MethodDeclarations.evictNodeMethodLocal, new Object[]{fqn});
        this.invokeMethod(m);
    }

    public Object remove(String fqn, Object key) throws CacheException {
        return this.remove(Fqn.fromString(fqn), key);
    }

    public Object remove(Fqn fqn, Object key) throws CacheException {
        GlobalTransaction tx = this.getCurrentTransaction();
        JBCMethodCall m = MethodCallFactory.create(MethodDeclarations.removeKeyMethodLocal, new Object[]{tx, fqn, key, Boolean.TRUE});
        return this.invokeMethod(m);
    }

    public void removeData(String fqn) throws CacheException {
        this.removeData(Fqn.fromString(fqn));
    }

    public void removeData(Fqn fqn) throws CacheException {
        GlobalTransaction tx = this.getCurrentTransaction();
        JBCMethodCall m = MethodCallFactory.create(MethodDeclarations.removeDataMethodLocal, new Object[]{tx, fqn, Boolean.TRUE});
        this.invokeMethod(m);
    }

    public void releaseAllLocks(String fqn) {
        this.releaseAllLocks(Fqn.fromString(fqn));
    }

    public void releaseAllLocks(Fqn fqn) {
        JBCMethodCall m = MethodCallFactory.create(MethodDeclarations.releaseAllLocksMethodLocal, new Object[]{fqn});
        try {
            this.invokeMethod(m);
        }
        catch (CacheException e) {
            log.error((Object)("failed releasing all locks for " + fqn), (Throwable)e);
        }
    }

    public String print(String fqn) {
        return this.print(Fqn.fromString(fqn));
    }

    public String print(Fqn fqn) {
        JBCMethodCall m = MethodCallFactory.create(MethodDeclarations.printMethodLocal, new Object[]{fqn});
        Object retval = null;
        try {
            retval = this.invokeMethod(m);
        }
        catch (Throwable e) {
            retval = e;
        }
        if (retval != null) {
            return retval.toString();
        }
        return "";
    }

    public Set getChildrenNames(String fqn) throws CacheException {
        return this.getChildrenNames(Fqn.fromString(fqn));
    }

    public Set getChildrenNames(Fqn fqn) throws CacheException {
        JBCMethodCall m = MethodCallFactory.create(MethodDeclarations.getChildrenNamesMethodLocal, new Object[]{fqn});
        return (Set)this.invokeMethod(m);
    }

    public Set _getChildrenNames(Fqn fqn) throws CacheException {
        Node n = this.findNode(fqn);
        if (n == null) {
            return null;
        }
        Map m = n.getChildren();
        if (m != null) {
            return new HashSet(m.keySet());
        }
        return null;
    }

    public boolean hasChild(Fqn fqn) {
        if (fqn == null) {
            return false;
        }
        TreeNode n = this.root;
        for (int i = 0; i < fqn.size(); ++i) {
            Object obj = fqn.get(i);
            if ((n = n.getChild(obj)) != null) continue;
            return false;
        }
        return n.hasChildren();
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean details) {
        StringBuffer sb = new StringBuffer();
        int indent = 0;
        if (!details) {
            sb.append(this.getClass().getName()).append(" [").append(this.getNumberOfNodes()).append(" nodes, ");
            sb.append(this.getNumberOfLocksHeld()).append(" locks]");
        } else {
            Map children = this.root.getChildren();
            if (children != null && children.size() > 0) {
                Collection nodes = children.values();
                Iterator it = nodes.iterator();
                while (it.hasNext()) {
                    ((DataNode)it.next()).print(sb, indent);
                    sb.append("\n");
                }
            } else {
                sb.append(SEPARATOR);
            }
        }
        return sb.toString();
    }

    public String printDetails() {
        StringBuffer sb = new StringBuffer();
        int indent = 2;
        Map children = this.root.getChildren();
        if (children != null && children.size() > 0) {
            Collection nodes = children.values();
            Iterator it = nodes.iterator();
            while (it.hasNext()) {
                ((DataNode)it.next()).printDetails(sb, indent);
                sb.append("\n");
            }
        } else {
            sb.append(SEPARATOR);
        }
        return sb.toString();
    }

    public String printLockInfo() {
        StringBuffer sb = new StringBuffer("\n");
        int indent = 0;
        sb.append("Root lock: ");
        if (this.root.isLocked()) {
            sb.append("\t(");
            this.root.getLock().toString(sb);
            sb.append(")");
        }
        sb.append("\n");
        Map children = this.root.getChildren();
        if (children != null && children.size() > 0) {
            Collection nodes = children.values();
            Iterator it = nodes.iterator();
            while (it.hasNext()) {
                ((DataNode)it.next()).printLockInfo(sb, indent);
                sb.append("\n");
            }
        } else {
            sb.append(SEPARATOR);
        }
        return sb.toString();
    }

    public int getNumberOfLocksHeld() {
        return this.numLocks((Node)this.root);
    }

    private int numLocks(Node n) {
        Map children;
        int num = 0;
        if (n.isLocked()) {
            ++num;
        }
        if ((children = n.getChildren(true)) != null) {
            Iterator it = children.values().iterator();
            while (it.hasNext()) {
                num += this.numLocks((Node)it.next());
            }
        }
        return num;
    }

    public int getNumberOfNodes() {
        return this.numNodes(this.root) - 1;
    }

    private int numNodes(DataNode n) {
        Map children;
        if (n == null) {
            return 0;
        }
        int count = 1;
        if (n.hasChildren() && (children = n.getChildren()) != null && children.size() > 0) {
            Collection child_nodes = children.values();
            Iterator it = child_nodes.iterator();
            while (it.hasNext()) {
                DataNode child = (DataNode)it.next();
                count += this.numNodes(child);
            }
        }
        return count;
    }

    public void realRemove(Fqn f, boolean skipMarkerCheck) {
        Node n = this.findInternal(f, true);
        if (n == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Performing a real remove for node " + f + ", marked for removal."));
        }
        if (skipMarkerCheck || n.isMarkedForRemoval()) {
            if (n.getFqn().isRoot()) {
                n.unmarkForRemoval(false);
                n.removeAllChildren();
            } else {
                n.getParent().removeChild(n.getName());
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Node " + f + " NOT marked for removal as expected, not removing!"));
        }
    }

    public int getNumberOfAttributes() {
        return this.numAttributes(this.root);
    }

    public int getNumberOfAttributes(Fqn fqn) {
        Node n = this.findNode(fqn);
        return this.numAttributes(n);
    }

    private int numAttributes(DataNode n) {
        Map children;
        if (n == null) {
            return 0;
        }
        int count = n.numAttributes();
        if (n.hasChildren() && (children = n.getChildren()) != null && children.size() > 0) {
            Collection child_nodes = children.values();
            Iterator it = child_nodes.iterator();
            while (it.hasNext()) {
                DataNode child = (DataNode)it.next();
                count += this.numAttributes(child);
            }
        }
        return count;
    }

    public List callRemoteMethods(List mbrs, MethodCall method_call, boolean synchronous, boolean exclude_self, long timeout) throws Exception {
        return this.callRemoteMethods(mbrs, method_call, synchronous ? 2 : 6, exclude_self, timeout);
    }

    public List callRemoteMethods(List mbrs, MethodCall method_call, int mode, boolean exclude_self, long timeout) throws Exception {
        RspList rsps;
        Object local_addr;
        Vector validMembers;
        if (this.disp == null) {
            return null;
        }
        Vector vector = validMembers = mbrs != null ? new Vector(mbrs) : new Vector(this.members);
        if (exclude_self && validMembers.size() > 0 && (local_addr = this.getLocalAddress()) != null) {
            validMembers.remove(local_addr);
        }
        if (validMembers.size() == 0) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"destination list is empty, discarding call");
            }
            return null;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("callRemoteMethods(): valid members are " + validMembers + " method: " + method_call));
        }
        if ((rsps = this.callRemoteMethodsViaReflection(validMembers, method_call, mode, timeout, this.forceAnycast || this.buddyManager != null && this.buddyManager.isEnabled())) == null) {
            throw new NotSerializableException("RpcDispatcher returned a null.  This is most often caused by args for " + method_call + " not being serializable.");
        }
        if (mode == 6) {
            return new ArrayList();
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("(" + this.getLocalAddress() + "): responses for method " + method_call.getName() + ":\n" + rsps));
        }
        ArrayList<Object> retval = new ArrayList<Object>(rsps.size());
        for (int i = 0; i < rsps.size(); ++i) {
            Rsp rsp = (Rsp)rsps.elementAt(i);
            if (rsp.wasSuspected() || !rsp.wasReceived()) {
                CacheException ex = rsp.wasSuspected() ? new SuspectException("Response suspected: " + rsp) : new TimeoutException("Response timed out: " + rsp);
                retval.add(new ReplicationException("rsp=" + rsp, ex));
                continue;
            }
            retval.add(rsp.getValue());
        }
        return retval;
    }

    private RspList callRemoteMethodsViaReflection(Vector validMembers, MethodCall method_call, int mode, long timeout, boolean anycast) throws Exception {
        if (anycast) {
            Method m = this.disp.getClass().getMethod("callRemoteMethods", Vector.class, MethodCall.class, Integer.TYPE, Long.TYPE, Boolean.TYPE);
            return (RspList)m.invoke((Object)this.disp, validMembers, method_call, new Integer(mode), new Long(timeout), anycast);
        }
        return this.disp.callRemoteMethods(validMembers, method_call, mode, timeout);
    }

    public List callRemoteMethods(List members, Method method, Object[] args, boolean synchronous, boolean exclude_self, long timeout) throws Exception {
        return this.callRemoteMethods(members, (MethodCall)MethodCallFactory.create(method, args), synchronous, exclude_self, timeout);
    }

    public List callRemoteMethods(Vector members, Method method, Object[] args, boolean synchronous, boolean exclude_self, long timeout) throws Exception {
        return this.callRemoteMethods((List)members, (MethodCall)MethodCallFactory.create(method, args), synchronous, exclude_self, timeout);
    }

    public List callRemoteMethods(Vector members, String method_name, Class[] types, Object[] args, boolean synchronous, boolean exclude_self, long timeout) throws Exception {
        Method method = this.getClass().getDeclaredMethod(method_name, types);
        return this.callRemoteMethods(members, method, args, synchronous, exclude_self, timeout);
    }

    public void _put(GlobalTransaction tx, Fqn fqn, Map data, boolean create_undo_ops, DataVersion dv) throws CacheException {
        this._put(tx, fqn, data, create_undo_ops, false, dv);
    }

    public void _put(GlobalTransaction tx, Fqn fqn, Map data, boolean create_undo_ops, boolean erase_contents, DataVersion dv) throws CacheException {
        this._put(tx, fqn, data, create_undo_ops, erase_contents);
    }

    public Object _put(GlobalTransaction tx, Fqn fqn, Object key, Object value, boolean create_undo_ops, DataVersion dv) throws CacheException {
        return this._put(tx, fqn, key, value, create_undo_ops);
    }

    public void _remove(GlobalTransaction tx, Fqn fqn, boolean create_undo_ops, DataVersion dv) throws CacheException {
        this._remove(tx, fqn, create_undo_ops, true);
    }

    public Object _remove(GlobalTransaction tx, Fqn fqn, Object key, boolean create_undo_ops, DataVersion dv) throws CacheException {
        return this._remove(tx, fqn, key, create_undo_ops);
    }

    public void _removeData(GlobalTransaction tx, Fqn fqn, boolean create_undo_ops, DataVersion dv) throws CacheException {
        this._removeData(tx, fqn, create_undo_ops, true);
    }

    public void _put(GlobalTransaction tx, String fqn, Map data, boolean create_undo_ops) throws CacheException {
        this._put(tx, Fqn.fromString(fqn), data, create_undo_ops);
    }

    public void _put(GlobalTransaction tx, Fqn fqn, Map data, boolean create_undo_ops) throws CacheException {
        this._put(tx, fqn, data, create_undo_ops, false);
    }

    public void _put(GlobalTransaction tx, Fqn fqn, Map data, boolean create_undo_ops, boolean erase_contents) throws CacheException {
        Node n;
        JBCMethodCall undo_op = null;
        if (log.isTraceEnabled()) {
            log.trace((Object)new StringBuffer("_put(").append(tx).append(", \"").append(fqn).append("\", ").append(data).append(")"));
        }
        if ((n = this.findNode(fqn)) == null) {
            String errStr = "node " + fqn + " not found (gtx=" + tx + ", caller=" + Thread.currentThread() + ")";
            if (log.isTraceEnabled()) {
                log.trace((Object)errStr);
            }
            throw new NodeNotExistsException(errStr);
        }
        this.notifyNodeModify(fqn, true);
        n.unmarkForRemoval(false);
        if (tx != null && create_undo_ops) {
            Map old_data = n.getData();
            undo_op = old_data == null ? MethodCallFactory.create(MethodDeclarations.removeDataMethodLocal, new Object[]{tx, fqn, Boolean.FALSE}) : MethodCallFactory.create(MethodDeclarations.putDataEraseMethodLocal, new Object[]{tx, fqn, new HashMap(old_data), Boolean.FALSE, Boolean.TRUE});
        }
        n.put(data, erase_contents);
        if (tx != null && create_undo_ops) {
            this.tx_table.addUndoOperation(tx, undo_op);
        }
        this.notifyNodeModified(fqn);
        this.notifyNodeModify(fqn, false);
    }

    public Object _put(GlobalTransaction tx, String fqn, Object key, Object value, boolean create_undo_ops) throws CacheException {
        return this._put(tx, Fqn.fromString(fqn), key, value, create_undo_ops);
    }

    public Object _put(GlobalTransaction tx, Fqn fqn, Object key, Object value, boolean create_undo_ops) throws CacheException {
        Node n = null;
        JBCMethodCall undo_op = null;
        Object old_value = null;
        if (log.isTraceEnabled()) {
            log.trace((Object)new StringBuffer("_put(").append(tx).append(", \"").append(fqn).append("\", ").append(key).append(", ").append(value).append(")"));
        }
        if ((n = this.findNode(fqn)) == null) {
            String errStr = "node " + fqn + " not found (gtx=" + tx + ", caller=" + Thread.currentThread() + ")";
            if (log.isTraceEnabled()) {
                log.trace((Object)errStr);
            }
            throw new NodeNotExistsException(errStr);
        }
        this.notifyNodeModify(fqn, true);
        old_value = n.put(key, value);
        n.unmarkForRemoval(false);
        if (tx != null && create_undo_ops) {
            undo_op = old_value == null ? MethodCallFactory.create(MethodDeclarations.removeKeyMethodLocal, new Object[]{tx, fqn, key, Boolean.FALSE}) : MethodCallFactory.create(MethodDeclarations.putKeyValMethodLocal, new Object[]{tx, fqn, key, old_value, Boolean.FALSE});
            this.tx_table.addUndoOperation(tx, undo_op);
        }
        this.notifyNodeModified(fqn);
        this.notifyNodeModify(fqn, false);
        return old_value;
    }

    public Object _put(GlobalTransaction tx, Fqn fqn, Object key, Object value, boolean create_undo_ops, long timeout) throws CacheException {
        return this._put(tx, fqn, key, value, create_undo_ops);
    }

    public void _remove(GlobalTransaction tx, String fqn, boolean create_undo_ops) throws CacheException {
        this._remove(tx, Fqn.fromString(fqn), create_undo_ops);
    }

    public void _remove(GlobalTransaction tx, Fqn fqn, boolean create_undo_ops) throws CacheException {
        this._remove(tx, fqn, create_undo_ops, true);
    }

    public void _remove(GlobalTransaction tx, Fqn fqn, boolean create_undo_ops, boolean sendNodeEvent) throws CacheException {
        this._remove(tx, fqn, create_undo_ops, sendNodeEvent, false);
    }

    public void _remove(GlobalTransaction tx, Fqn fqn, boolean create_undo_ops, boolean sendNodeEvent, boolean eviction) throws CacheException {
        this._remove(tx, fqn, create_undo_ops, sendNodeEvent, eviction, null);
    }

    public void _remove(GlobalTransaction tx, Fqn fqn, boolean create_undo_ops, boolean sendNodeEvent, boolean eviction, DataVersion version) throws CacheException {
        JBCMethodCall undo_op = null;
        if (log.isTraceEnabled()) {
            log.trace((Object)new StringBuffer("_remove(").append(tx).append(", \"").append(fqn).append("\")"));
        }
        if (tx != null) {
            try {
                int status = this.tx_table.getLocalTransaction(tx).getStatus();
                if (status == 1 || status == 4 || status == 9) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"This remove call is triggered by a transaction rollback, as a compensation operation.  Do a realRemove() instead.");
                    }
                    this.realRemove(fqn, true);
                    return;
                }
            }
            catch (Exception e) {
                log.warn((Object)"Unable to get a hold of the current transaction for a supposedly transactional call.  This may result in stale locks!", (Throwable)e);
            }
        }
        if (fqn.size() == 0) {
            Set children = this.getChildrenNames(fqn);
            if (children != null) {
                Object[] kids = children.toArray();
                for (int i = 0; i < kids.length; ++i) {
                    Object s = kids[i];
                    Fqn tmp = new Fqn(fqn, s);
                    try {
                        this._remove(tx, tmp, create_undo_ops, true, eviction);
                        continue;
                    }
                    catch (Exception e) {
                        log.error((Object)("failure removing node " + tmp));
                    }
                }
            }
            return;
        }
        Node n = this.findNode(fqn, version);
        if (n == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("node " + fqn + " not found"));
            }
            return;
        }
        if (sendNodeEvent) {
            this.notifyNodeRemove(fqn, true);
        } else {
            this.notifyNodeEvict(fqn, true);
        }
        TreeNode parent_node = n.getParent();
        if (this.isNodeLockingOptimistic() || eviction) {
            parent_node.removeChild(n.getName());
        } else {
            n.markForRemoval();
        }
        if (eviction) {
            parent_node.setChildrenLoaded(false);
        }
        if (tx != null && create_undo_ops && !eviction) {
            undo_op = MethodCallFactory.create(MethodDeclarations.addChildMethodLocal, new Object[]{tx, parent_node.getFqn(), n.getName(), n});
            this.tx_table.addUndoOperation(tx, undo_op);
        }
        if (sendNodeEvent) {
            this.notifyNodeRemoved(fqn);
            this.notifyNodeRemove(fqn, false);
        } else {
            this.notifyNodeEvicted(fqn);
            this.notifyNodeEvict(fqn, false);
        }
    }

    public Object _remove(GlobalTransaction tx, String fqn, Object key, boolean create_undo_ops) throws CacheException {
        return this._remove(tx, Fqn.fromString(fqn), key, create_undo_ops);
    }

    public Object _remove(GlobalTransaction tx, Fqn fqn, Object key, boolean create_undo_ops) throws CacheException {
        Node n = null;
        JBCMethodCall undo_op = null;
        Object old_value = null;
        if (log.isTraceEnabled()) {
            log.trace((Object)new StringBuffer("_remove(").append(tx).append(", \"").append(fqn).append("\", ").append(key).append(")"));
        }
        if ((n = this.findNode(fqn)) == null) {
            log.warn((Object)("node " + fqn + " not found"));
            return null;
        }
        this.notifyNodeModify(fqn, true);
        old_value = n.remove(key);
        if (tx != null && create_undo_ops && old_value != null) {
            undo_op = MethodCallFactory.create(MethodDeclarations.putKeyValMethodLocal, new Object[]{tx, fqn, key, old_value, Boolean.FALSE});
            this.tx_table.addUndoOperation(tx, undo_op);
        }
        this.notifyNodeModified(fqn);
        this.notifyNodeModify(fqn, false);
        return old_value;
    }

    public void _removeData(GlobalTransaction tx, String fqn, boolean create_undo_ops) throws CacheException {
        this._removeData(tx, Fqn.fromString(fqn), create_undo_ops);
    }

    public void _removeData(GlobalTransaction tx, Fqn fqn, boolean create_undo_ops) throws CacheException {
        this._removeData(tx, fqn, create_undo_ops, true);
    }

    public void _removeData(GlobalTransaction tx, Fqn fqn, boolean create_undo_ops, boolean sendNodeEvent) throws CacheException {
        this._removeData(tx, fqn, create_undo_ops, sendNodeEvent, false);
    }

    public void _removeData(GlobalTransaction tx, Fqn fqn, boolean create_undo_ops, boolean sendNodeEvent, boolean eviction) throws CacheException {
        this._removeData(tx, fqn, create_undo_ops, sendNodeEvent, eviction, null);
    }

    public void _removeData(GlobalTransaction tx, Fqn fqn, boolean create_undo_ops, boolean sendNodeEvent, boolean eviction, DataVersion version) throws CacheException {
        Node n = null;
        JBCMethodCall undo_op = null;
        Map old_data = null;
        if (log.isTraceEnabled()) {
            log.trace((Object)new StringBuffer("_removeData(").append(tx).append(", \"").append(fqn).append("\")"));
        }
        if ((n = this.findNode(fqn, version)) == null) {
            log.warn((Object)("node " + fqn + " not found"));
            return;
        }
        if (tx != null && create_undo_ops && (old_data = n.getData()) != null && !eviction) {
            undo_op = MethodCallFactory.create(MethodDeclarations.putDataMethodLocal, new Object[]{tx, fqn, new HashMap(old_data), Boolean.FALSE});
        }
        if (eviction) {
            this.notifyNodeEvict(fqn, true);
        } else {
            this.notifyNodeModify(fqn, true);
        }
        n.clear();
        if (eviction) {
            n.put(UNINITIALIZED, null);
        }
        if (sendNodeEvent) {
            this.notifyNodeVisited(fqn);
        } else if (eviction) {
            this.notifyNodeEvicted(fqn);
            this.notifyNodeEvict(fqn, false);
        } else {
            this.notifyNodeModified(fqn);
            this.notifyNodeModify(fqn, false);
        }
        if (tx != null && create_undo_ops) {
            this.tx_table.addUndoOperation(tx, undo_op);
        }
    }

    public void _evict(Fqn fqn) throws CacheException {
        if (!this.exists(fqn)) {
            return;
        }
        boolean create_undo_ops = false;
        boolean sendNodeEvent = false;
        boolean eviction = true;
        if (log.isTraceEnabled()) {
            log.trace((Object)("_evict(" + fqn + ")"));
        }
        if (this.hasChild(fqn)) {
            this._removeData(null, fqn, create_undo_ops, sendNodeEvent, eviction);
        } else {
            this._remove(null, fqn, create_undo_ops, sendNodeEvent, eviction);
        }
    }

    public void _evict(Fqn fqn, DataVersion version) throws CacheException {
        if (!this.exists(fqn)) {
            return;
        }
        boolean create_undo_ops = false;
        boolean sendNodeEvent = false;
        boolean eviction = true;
        if (log.isTraceEnabled()) {
            log.trace((Object)("_evict(" + fqn + ", " + version + ")"));
        }
        if (this.hasChild(fqn)) {
            this._removeData(null, fqn, create_undo_ops, sendNodeEvent, eviction, version);
        } else {
            this._remove(null, fqn, create_undo_ops, sendNodeEvent, eviction, version);
        }
    }

    public void _addChild(GlobalTransaction tx, Fqn parent_fqn, Object child_name, DataNode old_node) throws CacheException {
        if (log.isTraceEnabled()) {
            log.trace((Object)new StringBuffer("_addChild(").append(tx).append(", \"").append(parent_fqn).append("\", \"").append(child_name).append("\")"));
        }
        if (parent_fqn == null || child_name == null || old_node == null) {
            log.error((Object)"parent_fqn or child_name or node was null");
            return;
        }
        Node tmp = this.findNode(parent_fqn);
        if (tmp == null) {
            log.warn((Object)("node " + parent_fqn + " not found"));
            return;
        }
        tmp.addChild(child_name, old_node);
        old_node.unmarkForRemoval(true);
        this.notifyNodeCreated(new Fqn(parent_fqn, child_name));
    }

    public Object _replicate(MethodCall method_call) throws Throwable {
        if (log.isTraceEnabled()) {
            log.trace((Object)(this.getLocalAddress() + " received call " + method_call));
        }
        JBCMethodCall jbcCall = (JBCMethodCall)method_call;
        try {
            this.getInvocationContext().setOriginLocal(false);
            Object result = this.invokeMethod(method_call);
            if (jbcCall.getMethodId() == 3 || jbcCall.getMethodId() == 4 || jbcCall.getMethodId() == 6) {
                Object var4_5 = null;
                return var4_5;
            }
            Object object = result;
            return object;
        }
        catch (Exception ex) {
            if (jbcCall.getMethodId() == 4 && ex instanceof TimeoutException) {
                log.debug((Object)"ignoring timeout exception when replicating putFailFast");
                Object var4_7 = null;
                return var4_7;
            }
            log.warn((Object)("replication failure with method_call " + method_call + " exception: " + ex));
            throw ex;
        }
        finally {
            this.getInvocationContext().setOriginLocal(true);
        }
    }

    public void _replicate(List method_calls) throws Throwable {
        Iterator it = method_calls.iterator();
        while (it.hasNext()) {
            this._replicate((MethodCall)it.next());
        }
    }

    public List _clusteredGet(MethodCall methodCall, Boolean searchBackupSubtrees) {
        JBCMethodCall call = (JBCMethodCall)methodCall;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Clustered Get called with params: " + (Object)((Object)call) + ", " + searchBackupSubtrees));
        }
        Method m = call.getMethod();
        Object[] args = call.getArgs();
        Object callResults = null;
        try {
            Fqn fqn = (Fqn)args[0];
            if (log.isTraceEnabled()) {
                log.trace((Object)("Clustered get: invoking call " + m + " with Fqn " + fqn));
            }
            callResults = m.invoke((Object)this, args);
            boolean found = this.validResult(callResults, call, fqn);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Got result " + callResults + ", found=" + found));
            }
            if (found && callResults == null) {
                callResults = this.createEmptyResults(call);
            }
        }
        catch (Exception e) {
            log.warn((Object)"Problems processing clusteredGet call", (Throwable)e);
        }
        ArrayList<Object> results = new ArrayList<Object>(2);
        if (callResults != null) {
            results.add(Boolean.TRUE);
            results.add(callResults);
        } else {
            results.add(Boolean.FALSE);
            results.add(null);
        }
        return results;
    }

    public List _gravitateData(Fqn fqn, boolean searchSubtrees, boolean marshal) throws CacheException {
        ArrayList<Object> retval;
        Map children;
        Node backupSubtree;
        Node actualNode = this.findNode(fqn);
        Fqn backupNodeFqn = null;
        if (actualNode == null && searchSubtrees && (backupSubtree = this.findNode(BuddyManager.BUDDY_BACKUP_SUBTREE_FQN)) != null && (children = backupSubtree.getChildren()) != null) {
            Iterator childNames = children.keySet().iterator();
            while (childNames.hasNext() && actualNode == null) {
                backupNodeFqn = BuddyManager.getBackupFqn(childNames.next().toString(), fqn);
                actualNode = this.findNode(backupNodeFqn);
            }
        }
        if (actualNode == null) {
            retval = new ArrayList<Object>(1);
            retval.add(Boolean.FALSE);
        } else {
            retval = new ArrayList(3);
            retval.add(Boolean.TRUE);
            List list = this.getNodeData(new LinkedList(), actualNode);
            if (marshal) {
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
                    MarshalledValueOutputStream maos = new MarshalledValueOutputStream((OutputStream)baos);
                    maos.writeObject((Object)list);
                    maos.close();
                    retval.add(baos.toByteArray());
                }
                catch (IOException e) {
                    throw new CacheException("Failure marshalling subtree at " + fqn, e);
                }
            } else {
                retval.add(list);
            }
            if (backupNodeFqn == null) {
                backupNodeFqn = BuddyManager.getBackupFqn(BuddyManager.getGroupNameFromAddress(this.getLocalAddress()), fqn);
            }
            retval.add(backupNodeFqn);
        }
        return retval;
    }

    private List getNodeData(List list, DataNode node) {
        NodeData data = new NodeData(BuddyManager.getActualFqn(node.getFqn()), node.getData());
        list.add(data);
        Map children = node.getChildren();
        if (children != null) {
            Iterator i = children.keySet().iterator();
            while (i.hasNext()) {
                Object childName = i.next();
                DataNode childNode = (DataNode)children.get(childName);
                this.getNodeData(list, childNode);
            }
        }
        return list;
    }

    public void _remoteAssignToBuddyGroup(BuddyGroup group, Map state) throws Exception {
        if (this.buddyManager != null) {
            this.buddyManager.handleAssignToBuddyGroup(group, state);
        }
    }

    public void _remoteRemoveFromBuddyGroup(String groupName) throws BuddyNotInitException {
        if (this.buddyManager != null) {
            this.buddyManager.handleRemoveFromBuddyGroup(groupName);
        }
    }

    public void _remoteAnnounceBuddyPoolName(IpAddress address, String buddyPoolName) {
        if (this.buddyManager != null) {
            this.buddyManager.handlePoolNameBroadcast(address, buddyPoolName);
        }
    }

    public void _dataGravitationCleanup(GlobalTransaction gtx, Fqn primary, Fqn backup) throws Exception {
        JBCMethodCall backupDataCleanup;
        JBCMethodCall primaryDataCleanup;
        if (this.buddyManager.isDataGravitationRemoveOnFind()) {
            primaryDataCleanup = MethodCallFactory.create(MethodDeclarations.removeNodeMethodLocal, new Object[]{null, primary, Boolean.FALSE});
            backupDataCleanup = MethodCallFactory.create(MethodDeclarations.removeNodeMethodLocal, new Object[]{null, backup, Boolean.FALSE});
        } else {
            primaryDataCleanup = MethodCallFactory.create(MethodDeclarations.evictNodeMethodLocal, new Object[]{primary});
            backupDataCleanup = MethodCallFactory.create(MethodDeclarations.evictNodeMethodLocal, new Object[]{backup});
        }
        this.invokeMethod(primaryDataCleanup);
        this.invokeMethod(backupDataCleanup);
    }

    private boolean validResult(Object callResults, JBCMethodCall mc, Fqn fqn) {
        switch (mc.getMethodId()) {
            case 23: 
            case 24: {
                return callResults != null || this.exists(fqn);
            }
            case 16: {
                return (Boolean)callResults;
            }
        }
        return false;
    }

    private Object createEmptyResults(JBCMethodCall mc) {
        switch (mc.getMethodId()) {
            case 24: {
                return new HashMap(0);
            }
            case 23: {
                return new HashSet(0);
            }
        }
        return null;
    }

    public void _releaseAllLocks(Fqn fqn) {
        try {
            Node n = this.findNode(fqn);
            if (n == null) {
                log.error((Object)("releaseAllLocks(): node " + fqn + " not found"));
                return;
            }
            n.releaseAllForce();
        }
        catch (Throwable t) {
            log.error((Object)"releaseAllLocks(): failed", t);
        }
    }

    public String _print(Fqn fqn) {
        try {
            Node n = this.findNode(fqn);
            if (n == null) {
                return null;
            }
            return ((Object)n).toString();
        }
        catch (Throwable t) {
            return null;
        }
    }

    public void _lock(Fqn fqn, int lock_type, boolean recursive) throws TimeoutException, LockingException {
        log.warn((Object)"method _lock() should not be invoked on TreeCache");
    }

    public void optimisticPrepare(GlobalTransaction gtx, List modifications, Map data, Address address, boolean onePhaseCommit) {
        throw new UnsupportedOperationException("optimisticPrepare() should not be called on TreeCache directly");
    }

    public void prepare(GlobalTransaction global_tx, List modifications, Address coord, boolean onePhaseCommit) {
        throw new UnsupportedOperationException("prepare() should not be called on TreeCache directly");
    }

    public void commit(GlobalTransaction tx) {
        throw new UnsupportedOperationException("commit() should not be called on TreeCache directly");
    }

    public void rollback(GlobalTransaction tx) {
        throw new UnsupportedOperationException("rollback() should not be called on TreeCache directly");
    }

    public void addUndoOperation(GlobalTransaction gtx, MethodCall undo_op) {
        this.tx_table.addUndoOperation(gtx, undo_op);
    }

    public CacheLoaderManager getCacheLoaderManager() {
        return this.cacheLoaderManager;
    }

    public void setCacheLoaderManager(CacheLoaderManager cacheLoaderManager) {
        this.cacheLoaderManager = cacheLoaderManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void viewAccepted(View new_view) {
        Vector new_mbrs = new_view.getMembers();
        log.info((Object)("viewAccepted(): " + new_view));
        Vector vector = this.members;
        synchronized (vector) {
            boolean needNotification = false;
            if (new_mbrs != null) {
                Vector removed = (Vector)this.members.clone();
                removed.removeAll(new_mbrs);
                this.removeLocksForDeadMembers(this.root, removed);
                this.members.removeAllElements();
                this.members.addAll(new_view.getMembers());
                needNotification = true;
            }
            boolean bl = this.coordinator = this.members.size() != 0 && this.members.get(0).equals(this.getLocalAddress());
            if (needNotification) {
                this.notifyViewChange(new_view);
            }
            this.members.notifyAll();
        }
    }

    public void suspect(Address suspected_mbr) {
    }

    public void block() {
    }

    protected Transaction getLocalTransaction() {
        if (this.tm == null) {
            return null;
        }
        try {
            return this.tm.getTransaction();
        }
        catch (Throwable t) {
            return null;
        }
    }

    boolean isValid(Transaction tx) {
        if (tx == null) {
            return false;
        }
        int status = -1;
        try {
            status = tx.getStatus();
            return status == 0 || status == 7;
        }
        catch (SystemException e) {
            log.error((Object)"failed getting transaction status", (Throwable)e);
            return false;
        }
    }

    public GlobalTransaction getCurrentTransaction() {
        return this.getCurrentTransaction(true);
    }

    public GlobalTransaction getCurrentTransaction(boolean createIfNotExists) {
        Transaction tx = this.getLocalTransaction();
        if (tx == null) {
            return null;
        }
        if (!this.isValid(tx)) {
            int status = -1;
            try {
                status = tx.getStatus();
            }
            catch (SystemException e) {
                // empty catch block
            }
            log.warn((Object)("status is " + status + " (not ACTIVE or PREPARING); returning null)"));
            return null;
        }
        return this.getCurrentTransaction(tx, createIfNotExists);
    }

    public GlobalTransaction getCurrentTransaction(Transaction tx) {
        return this.getCurrentTransaction(tx, true);
    }

    public GlobalTransaction getCurrentTransaction(Transaction tx, boolean createIfNotExists) {
        GlobalTransaction gtx = this.tx_table.get(tx);
        if (gtx == null && createIfNotExists) {
            Address addr = (Address)this.getLocalAddress();
            gtx = GlobalTransaction.create(addr);
            this.tx_table.put(tx, gtx);
            TransactionEntry ent = this.isNodeLockingOptimistic() ? new OptimisticTransactionEntry() : new TransactionEntry();
            ent.setTransaction(tx);
            this.tx_table.put(gtx, ent);
            if (log.isTraceEnabled()) {
                log.trace((Object)("created new GTX: " + gtx + ", local TX=" + tx));
            }
        }
        return gtx;
    }

    protected Object invokeMethod(MethodCall m) throws CacheException {
        try {
            return this.interceptor_chain.invoke(m);
        }
        catch (Throwable t) {
            if (t instanceof CacheException) {
                throw (CacheException)t;
            }
            throw new RuntimeException(t);
        }
    }

    protected Object getOwnerForLock() {
        Object owner = this.getCurrentTransaction();
        if (owner == null) {
            owner = Thread.currentThread();
        }
        return owner;
    }

    protected Class loadClass(String classname) throws ClassNotFoundException {
        ClassLoader cl = this.getClass().getClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        return cl.loadClass(classname);
    }

    private Node findNode(Fqn fqn) {
        try {
            return this.findNode(fqn, null);
        }
        catch (CacheException e) {
            log.warn((Object)"Unexpected error", (Throwable)e);
            return null;
        }
    }

    private Node findNode(Fqn fqn, DataVersion version) throws CacheException {
        if (fqn == null) {
            return null;
        }
        Node toReturn = this.findInternal(fqn, false);
        if (version != null) {
            DataVersion nodeVersion = ((OptimisticTreeNode)toReturn).getVersion();
            if (log.isDebugEnabled()) {
                log.debug((Object)("looking for optimistic node [" + fqn + "] with version [" + version + "].  My version is [" + nodeVersion + "]"));
            }
            if (nodeVersion.newerThan(version)) {
                throw new CacheException("Unable to validate versions.");
            }
        }
        return toReturn;
    }

    public RegionManager getRegionManager() {
        if (this.regionManager_ == null) {
            this.regionManager_ = new RegionManager();
        }
        return this.regionManager_;
    }

    public org.jboss.cache.eviction.RegionManager getEvictionRegionManager() {
        return this.evictionRegionManager_;
    }

    public VersionAwareMarshaller getMarshaller() {
        if (this.marshaller_ == null) {
            this.marshaller_ = new VersionAwareMarshaller(this.getRegionManager(), this.inactiveOnStartup, this.useRegionBasedMarshalling, this.getReplicationVersion());
        }
        return this.marshaller_;
    }

    public void notifyNodeCreated(Fqn fqn) {
        if (this.evictionPolicyListener != null) {
            this.evictionPolicyListener.nodeCreated(fqn);
        }
        if (this.hasListeners) {
            Iterator it = this.listeners.iterator();
            while (it.hasNext()) {
                ((TreeCacheListener)it.next()).nodeCreated(fqn);
            }
        }
    }

    public void notifyNodeLoaded(Fqn fqn) {
        if (this.evictionPolicyListener != null) {
            this.evictionPolicyListener.nodeLoaded(fqn);
        }
        if (this.hasListeners) {
            Iterator it = this.listeners.iterator();
            while (it.hasNext()) {
                ((TreeCacheListener)it.next()).nodeLoaded(fqn);
            }
        }
    }

    public void notifyNodeActivate(Fqn fqn, boolean pre) {
        if (this.evictionPolicyListener != null && this.evictionPolicyListener instanceof ExtendedTreeCacheListener) {
            ((ExtendedTreeCacheListener)((Object)this.evictionPolicyListener)).nodeActivate(fqn, pre);
        }
        if (this.hasListeners) {
            Iterator it = this.listeners.iterator();
            while (it.hasNext()) {
                Object listener = it.next();
                if (!(listener instanceof ExtendedTreeCacheListener)) continue;
                ((ExtendedTreeCacheListener)listener).nodeActivate(fqn, pre);
            }
        }
    }

    public void notifyNodePassivate(Fqn fqn, boolean pre) {
        if (this.evictionPolicyListener != null && this.evictionPolicyListener instanceof ExtendedTreeCacheListener) {
            ((ExtendedTreeCacheListener)((Object)this.evictionPolicyListener)).nodePassivate(fqn, pre);
        }
        if (this.hasListeners) {
            Iterator it = this.listeners.iterator();
            while (it.hasNext()) {
                Object listener = it.next();
                if (!(listener instanceof ExtendedTreeCacheListener)) continue;
                ((ExtendedTreeCacheListener)listener).nodePassivate(fqn, pre);
            }
        }
    }

    public void notifyNodeRemove(Fqn fqn, boolean pre) {
        if (this.evictionPolicyListener != null && this.evictionPolicyListener instanceof ExtendedTreeCacheListener) {
            ((ExtendedTreeCacheListener)((Object)this.evictionPolicyListener)).nodeRemove(fqn, pre, this.getInvocationContext().isOriginLocal());
        }
        if (this.hasListeners) {
            Iterator it = this.listeners.iterator();
            while (it.hasNext()) {
                Object listener = it.next();
                if (!(listener instanceof ExtendedTreeCacheListener)) continue;
                ((ExtendedTreeCacheListener)listener).nodeRemove(fqn, pre, this.getInvocationContext().isOriginLocal());
            }
        }
    }

    public void notifyNodeRemoved(Fqn fqn) {
        if (this.evictionPolicyListener != null) {
            this.evictionPolicyListener.nodeRemoved(fqn);
        }
        if (this.hasListeners) {
            Iterator it = this.listeners.iterator();
            while (it.hasNext()) {
                ((TreeCacheListener)it.next()).nodeRemoved(fqn);
            }
        }
    }

    public void notifyNodeEvict(Fqn fqn, boolean pre) {
        if (this.evictionPolicyListener != null && this.evictionPolicyListener instanceof ExtendedTreeCacheListener) {
            ((ExtendedTreeCacheListener)((Object)this.evictionPolicyListener)).nodeEvict(fqn, pre);
        }
        if (this.hasListeners) {
            Iterator it = this.listeners.iterator();
            while (it.hasNext()) {
                Object listener = it.next();
                if (!(listener instanceof ExtendedTreeCacheListener)) continue;
                ((ExtendedTreeCacheListener)listener).nodeEvict(fqn, pre);
            }
        }
    }

    public void notifyNodeEvicted(Fqn fqn) {
        if (this.evictionPolicyListener != null) {
            this.evictionPolicyListener.nodeEvicted(fqn);
        }
        if (this.hasListeners) {
            Iterator it = this.listeners.iterator();
            while (it.hasNext()) {
                ((TreeCacheListener)it.next()).nodeEvicted(fqn);
            }
        }
    }

    public void notifyNodeModify(Fqn fqn, boolean pre) {
        if (this.evictionPolicyListener != null && this.evictionPolicyListener instanceof ExtendedTreeCacheListener) {
            ((ExtendedTreeCacheListener)((Object)this.evictionPolicyListener)).nodeModify(fqn, pre, this.getInvocationContext().isOriginLocal());
        }
        if (this.hasListeners) {
            Iterator it = this.listeners.iterator();
            while (it.hasNext()) {
                Object listener = it.next();
                if (!(listener instanceof ExtendedTreeCacheListener)) continue;
                ((ExtendedTreeCacheListener)listener).nodeModify(fqn, pre, this.getInvocationContext().isOriginLocal());
            }
        }
    }

    public void notifyNodeModified(Fqn fqn) {
        if (this.evictionPolicyListener != null) {
            this.evictionPolicyListener.nodeModified(fqn);
        }
        if (this.hasListeners) {
            Iterator it = this.listeners.iterator();
            while (it.hasNext()) {
                ((TreeCacheListener)it.next()).nodeModified(fqn);
            }
        }
    }

    public void notifyNodeVisited(Fqn fqn) {
        if (this.evictionPolicyListener != null) {
            this.evictionPolicyListener.nodeVisited(fqn);
        }
        if (this.hasListeners) {
            Iterator it = this.listeners.iterator();
            while (it.hasNext()) {
                ((TreeCacheListener)it.next()).nodeVisited(fqn);
            }
        }
    }

    protected void notifyCacheStarted() {
        if (this.evictionPolicyListener != null) {
            this.evictionPolicyListener.cacheStarted(this);
        }
        if (this.hasListeners) {
            Iterator it = this.listeners.iterator();
            while (it.hasNext()) {
                ((TreeCacheListener)it.next()).cacheStarted(this);
            }
        }
    }

    protected void notifyCacheStopped() {
        if (this.evictionPolicyListener != null) {
            this.evictionPolicyListener.cacheStopped(this);
        }
        if (this.hasListeners) {
            Iterator it = this.listeners.iterator();
            while (it.hasNext()) {
                ((TreeCacheListener)it.next()).cacheStopped(this);
            }
        }
    }

    protected void notifyViewChange(View v) {
        if (this.evictionPolicyListener != null) {
            this.evictionPolicyListener.viewChange(v);
        }
        if (this.hasListeners) {
            Iterator it = this.listeners.iterator();
            while (it.hasNext()) {
                ((TreeCacheListener)it.next()).viewChange(v);
            }
        }
    }

    protected void notifyAllNodesCreated(DataNode curr) {
        if (curr == null) {
            return;
        }
        this.notifyNodeCreated(curr.getFqn());
        Map children = curr.getChildren();
        if (children != null) {
            Iterator it = children.values().iterator();
            while (it.hasNext()) {
                DataNode n = (DataNode)it.next();
                this.notifyAllNodesCreated(n);
            }
        }
    }

    protected String getDefaultProperties() {
        return "UDP(mcast_addr=224.0.0.36;mcast_port=55566;ip_ttl=32;mcast_send_buf_size=150000;mcast_recv_buf_size=80000):PING(timeout=1000;num_initial_members=2):MERGE2(min_interval=5000;max_interval=10000):FD_SOCK:VERIFY_SUSPECT(timeout=1500):pbcast.NAKACK(gc_lag=50;max_xmit_size=8192;retransmit_timeout=600,1200,2400,4800):UNICAST(timeout=600,1200,2400,4800):pbcast.STABLE(desired_avg_gossip=20000):FRAG(frag_size=8192;down_thread=false;up_thread=false):pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=false;print_local_addr=true):pbcast.STATE_TRANSFER";
    }

    protected int string2Mode(String mode) {
        if (mode == null) {
            return -1;
        }
        String m = mode.toLowerCase().trim().replace('_', '-');
        if (m.equals("local")) {
            return 1;
        }
        if (m.equals("repl-async")) {
            return 2;
        }
        if (m.equals("repl-sync")) {
            return 3;
        }
        if (m.equals("invalidation-async")) {
            return 4;
        }
        if (m.equals("invalidation-sync")) {
            return 5;
        }
        return -1;
    }

    private void initialiseCacheLoaderManager() throws Exception {
        if (this.cacheLoaderManager == null) {
            this.cacheLoaderManager = new CacheLoaderManager();
        }
        if (this.cacheLoaderConfig != null) {
            this.cacheLoaderManager.setConfig(this.cacheLoaderConfig, this);
        } else {
            this.cacheLoaderManager.setConfig(this.cloaderConfig, this);
        }
    }

    public void setInvocationContext(InvocationContext invocationContext) {
        this.invocationContextContainer.set(invocationContext);
    }

    public InvocationContext getInvocationContext() {
        InvocationContext ctx = (InvocationContext)this.invocationContextContainer.get();
        if (ctx == null) {
            ctx = new InvocationContext();
            this.invocationContextContainer.set(ctx);
        }
        return ctx;
    }

    public void setCacheLoaderClass(String cache_loader_class) {
        log.warn((Object)"Using deprecated config element CacheLoaderClass.  This element will be removed in future, please use CacheLoaderConfiguration instead.");
        this.initDeprecatedCacheLoaderConfig();
        this.cloaderConfig.getFirstCacheLoaderConfig().setClassName(cache_loader_class);
    }

    public void setCacheLoaderConfig(Properties cache_loader_config) {
        log.warn((Object)"Using deprecated config element CacheLoaderConfig(Properties).  This element will be removed in future, please use CacheLoaderConfiguration instead.");
        this.initDeprecatedCacheLoaderConfig();
        this.cloaderConfig.getFirstCacheLoaderConfig().setProperties(cache_loader_config);
    }

    public void setCacheLoaderShared(boolean shared) {
        log.warn((Object)"Using deprecated config element CacheLoaderShared.  This element will be removed in future, please use CacheLoaderConfiguration instead.");
        this.initDeprecatedCacheLoaderConfig();
        this.cloaderConfig.setShared(shared);
    }

    public void setCacheLoaderPassivation(boolean passivate) {
        log.warn((Object)"Using deprecated config element CacheLoaderPassivation.  This element will be removed in future, please use CacheLoaderConfiguration instead.");
        this.initDeprecatedCacheLoaderConfig();
        this.cloaderConfig.setPassivation(passivate);
    }

    public void setCacheLoaderPreload(String list) {
        log.warn((Object)"Using deprecated config element CacheLoaderPreload.  This element will be removed in future, please use CacheLoaderConfiguration instead.");
        this.initDeprecatedCacheLoaderConfig();
        this.cloaderConfig.setPreload(list);
    }

    public void setCacheLoaderAsynchronous(boolean b) {
        log.warn((Object)"Using deprecated config element CacheLoaderAsynchronous.  This element will be removed in future, please use CacheLoaderConfiguration instead.");
        this.initDeprecatedCacheLoaderConfig();
        this.cloaderConfig.getFirstCacheLoaderConfig().setAsync(b);
    }

    public void setCacheLoaderFetchPersistentState(boolean flag) {
        log.warn((Object)"Using deprecated config element CacheLoaderFetchPersistentState.  This element will be removed in future, please use CacheLoaderConfiguration instead.");
        this.initDeprecatedCacheLoaderConfig();
        this.cloaderConfig.getFirstCacheLoaderConfig().setFetchPersistentState(flag);
    }

    public void setCacheLoaderFetchTransientState(boolean flag) {
        log.warn((Object)"Using deprecated config element CacheLoaderFetchTransientState.  This element will be removed in future, replaced with FetchInMemoryState.");
        this.setFetchInMemoryState(flag);
    }

    private void initDeprecatedCacheLoaderConfig() {
        if (this.cloaderConfig == null) {
            this.cloaderConfig = new CacheLoaderConfig();
            log.warn((Object)"Using legacy cache loader config mechanisms.");
            if (this.cacheLoaderConfig != null) {
                log.warn((Object)"Specified CacheLoaderConfiguration XML block will be ignored!");
            }
        }
        if (this.cloaderConfig.getIndividualCacheLoaderConfigs().size() == 0) {
            CacheLoaderConfig.IndividualCacheLoaderConfig first = new CacheLoaderConfig.IndividualCacheLoaderConfig();
            this.cloaderConfig.addIndividualCacheLoaderConfig(first);
        }
    }

    public void setCacheLoader(CacheLoader loader) {
        log.warn((Object)"Using deprecated config method setCacheLoader.  This element will be removed in future, please use CacheLoaderConfiguration instead.");
        try {
            if (this.cacheLoaderManager == null) {
                this.initialiseCacheLoaderManager();
            }
        }
        catch (Exception e) {
            log.warn((Object)"Problem setting cache loader.  Perhaps your cache loader config has not been set yet?");
        }
        this.cacheLoaderManager.setCacheLoader(loader);
    }

    public String getCacheLoaderClass() {
        return this.cacheLoaderManager == null ? null : this.cacheLoaderManager.getCacheLoaderConfig().getFirstCacheLoaderConfig().getClassName();
    }

    public boolean getCacheLoaderShared() {
        return false;
    }

    public boolean getCacheLoaderPassivation() {
        return this.cacheLoaderManager != null && this.cacheLoaderManager.getCacheLoaderConfig().isPassivation();
    }

    public boolean getCacheLoaderAsynchronous() {
        return this.cacheLoaderManager != null && this.cacheLoaderManager.getCacheLoaderConfig().getFirstCacheLoaderConfig().isAsync();
    }

    public String getCacheLoaderPreload() {
        return this.cacheLoaderManager == null ? null : this.cacheLoaderManager.getCacheLoaderConfig().getPreload();
    }

    public boolean getCacheLoaderFetchPersistentState() {
        return this.cacheLoaderManager != null && this.cacheLoaderManager.getCacheLoaderConfig().getFirstCacheLoaderConfig().isFetchPersistentState();
    }

    public boolean getCacheLoaderFetchTransientState() {
        return this.getFetchInMemoryState();
    }

    public Properties getCacheLoaderConfig() {
        if (this.cacheLoaderManager == null) {
            return null;
        }
        return this.cacheLoaderManager.getCacheLoaderConfig().getFirstCacheLoaderConfig().getProperties();
    }

    public void purgeCacheLoaders() throws Exception {
        if (this.cacheLoaderManager != null) {
            this.cacheLoaderManager.purgeLoaders(true);
        }
    }

    private JChannel getMultiplexerChannel(String serviceName, String stackName) {
        if (serviceName == null || serviceName.length() == 0) {
            return null;
        }
        MBeanServer mbserver = this.getMBeanServer();
        if (mbserver == null) {
            log.warn((Object)("Multiplexer service specified but MBean server not found.  Multiplexer will not be used for cache cluster " + this.cluster_name + "."));
            return null;
        }
        try {
            ObjectName muxName = new ObjectName(serviceName);
            if (!mbserver.isRegistered(muxName)) {
                log.warn((Object)("Multiplexer service specified but '" + serviceName + "' not registered." + "  Multiplexer will not be used for cache cluster " + this.cluster_name + "."));
                return null;
            }
            boolean muxFound = false;
            MBeanOperationInfo[] ops = mbserver.getMBeanInfo(muxName).getOperations();
            for (int i = 0; i < ops.length; ++i) {
                MBeanOperationInfo op = ops[i];
                if (!op.getName().equals(CREATE_MUX_CHANNEL)) continue;
                muxFound = true;
                break;
            }
            if (!muxFound) {
                log.warn((Object)("Multiplexer service registered but method 'createMultiplexerChannel' not found.  Multiplexer will not be used for cache cluster " + this.cluster_name + "." + "  Ensure that you are using JGroups version 2.3 or later."));
                return null;
            }
            Object[] params = new Object[]{stackName, this.cluster_name};
            return (JChannel)mbserver.invoke(muxName, CREATE_MUX_CHANNEL, params, MUX_TYPES);
        }
        catch (Exception e) {
            log.error((Object)("Multiplexer channel creation failed.  Multiplexer will not be used for cache cluster " + this.cluster_name + "."), (Throwable)e);
            return null;
        }
    }

    private MBeanServer getMBeanServer() {
        if (this.server != null) {
            return this.server;
        }
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        if (servers == null || servers.size() == 0) {
            return null;
        }
        for (int i = 0; i < servers.size(); ++i) {
            MBeanServer server = servers.get(i);
            if (!server.getDefaultDomain().equalsIgnoreCase(JBOSS_SERVER_DOMAIN)) continue;
            return server;
        }
        return servers.get(0);
    }

    static interface TransactionLockStatus
    extends Status {
        public static final int STATUS_BROKEN = Integer.MIN_VALUE;
    }

    class MessageListenerAdaptor
    implements MessageListener {
        final Log my_log;
        final boolean trace;

        MessageListenerAdaptor(Log log) {
            this.my_log = log;
            this.trace = this.my_log.isTraceEnabled();
        }

        public void receive(Message msg) {
            if (this.trace) {
                this.my_log.trace((Object)("Received message " + msg));
            }
        }

        public byte[] getState() {
            try {
                return TreeCache.this._getState(Fqn.ROOT, TreeCache.this.getInitialStateRetrievalTimeout(), true, true);
            }
            catch (Throwable t) {
                this.my_log.error((Object)("Caught " + t.getClass().getName() + " while responding to initial state transfer request;" + " returning null"));
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setState(byte[] new_state) {
            try {
                if (new_state == null) {
                    if (this.my_log.isDebugEnabled()) {
                        this.my_log.debug((Object)"transferred state is null (may be first member in cluster)");
                    }
                } else {
                    TreeCache.this._setState(new_state, TreeCache.this.root, null);
                }
                TreeCache.this.isStateSet = true;
            }
            catch (Throwable t) {
                this.my_log.error((Object)"failed setting state", t);
                TreeCache.this.setStateException = t instanceof Exception ? (Exception)t : new Exception(t);
            }
            finally {
                Object object = TreeCache.this.stateLock;
                synchronized (object) {
                    TreeCache.this.stateLock.notifyAll();
                }
            }
        }
    }
}

