/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservice.transport.jms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import javax.ejb.EJBException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.naming.InitialContext;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.jboss.logging.Logger;
import org.jboss.util.NestedRuntimeException;
import org.jboss.webservice.transport.jms.MessageDispatcher;
import org.jboss.webservice.transport.jms.MessageDispatcherFactory;

public abstract class JMSTransportSupport
implements MessageDrivenBean,
MessageListener {
    protected Logger log = Logger.getLogger(JMSTransportSupport.class);
    private QueueConnectionFactory queueFactory;

    public void onMessage(Message message) {
        try {
            ByteArrayInputStream reqMessage;
            SOAPMessage resMessage;
            String msgStr = null;
            if (message instanceof BytesMessage) {
                msgStr = this.getMessageStr((BytesMessage)message);
            } else if (message instanceof TextMessage) {
                msgStr = ((TextMessage)message).getText();
            } else {
                this.log.warn("Invalid message type: " + message);
                return;
            }
            this.log.debug("Incomming SOAP message: " + msgStr);
            String fromName = null;
            Destination destination = message.getJMSDestination();
            if (destination instanceof Queue) {
                fromName = "queue/" + ((Queue)destination).getQueueName();
            }
            if (destination instanceof Topic) {
                fromName = "topic/" + ((Topic)destination).getTopicName();
            }
            if ((resMessage = this.processSOAPMessage(fromName, reqMessage = new ByteArrayInputStream(msgStr.getBytes()))) != null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                resMessage.writeTo((OutputStream)baos);
                msgStr = new String(baos.toByteArray());
                this.log.debug("Outgoing SOAP message: " + msgStr);
                Queue replyQueue = this.getReplyQueue(message);
                if (replyQueue != null) {
                    this.sendResponse(replyQueue, msgStr);
                } else {
                    this.log.warn("No reply queue, ignore response message");
                }
            } else {
                this.log.debug("SOAP response message is null");
            }
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    protected SOAPMessage processSOAPMessage(String fromName, InputStream reqMessage) throws SOAPException, IOException, RemoteException {
        MessageDispatcher msgDispatcher = MessageDispatcherFactory.createMessageDispatcher();
        SOAPMessage resMessage = msgDispatcher.dipatchMessage(fromName, this, reqMessage);
        return resMessage;
    }

    private String getMessageStr(BytesMessage message) throws Exception {
        byte[] buffer = new byte[8192];
        ByteArrayOutputStream out = new ByteArrayOutputStream(buffer.length);
        int read = message.readBytes(buffer);
        while (read != -1) {
            out.write(buffer, 0, read);
            read = message.readBytes(buffer);
        }
        byte[] msgBytes = out.toByteArray();
        return new String(msgBytes);
    }

    protected Queue getReplyQueue(Message message) throws JMSException {
        Queue replyQueue = (Queue)message.getJMSReplyTo();
        return replyQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendResponse(Queue replyQueue, String msgStr) throws SOAPException, IOException, JMSException {
        QueueConnection qc = this.queueFactory.createQueueConnection();
        QueueSession session = qc.createQueueSession(false, 1);
        QueueSender sender = null;
        try {
            sender = session.createSender(replyQueue);
            TextMessage responseMessage = session.createTextMessage(msgStr);
            sender.send(responseMessage);
            this.log.info("Sent response");
        }
        finally {
            try {
                sender.close();
            }
            catch (JMSException ignored) {}
            try {
                session.close();
            }
            catch (JMSException ignored) {}
            try {
                qc.close();
            }
            catch (JMSException ignored) {}
        }
    }

    public void ejbCreate() {
        try {
            InitialContext ctx = new InitialContext();
            this.queueFactory = (QueueConnectionFactory)ctx.lookup("java:/ConnectionFactory");
        }
        catch (Exception e) {
            throw new NestedRuntimeException(e);
        }
    }

    public void ejbRemove() throws EJBException {
    }

    public void setMessageDrivenContext(MessageDrivenContext ctx) throws EJBException {
    }
}

