/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web;

import java.net.URL;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.web.AbstractWebContainer;
import org.jboss.web.AbstractWebDeployer;
import org.jboss.web.WebApplication;
import org.jboss.web.WebModuleMBean;

public class WebModule
extends ServiceMBeanSupport
implements WebModuleMBean {
    private DeploymentInfo di;
    private AbstractWebContainer container;
    private AbstractWebDeployer deployer;

    public WebModule(DeploymentInfo di, AbstractWebContainer container, AbstractWebDeployer deployer) {
        this.di = di;
        this.container = container;
        this.deployer = deployer;
    }

    protected void startService() throws Exception {
        this.startModule();
    }

    protected void stopService() throws Exception {
        this.stopModule();
    }

    protected void destroyService() {
        this.di = null;
        this.container = null;
        this.deployer = null;
    }

    public synchronized void startModule() throws DeploymentException {
        URL warURL = this.di.localUrl != null ? this.di.localUrl : this.di.url;
        WebApplication webApp = this.deployer.start(this.di);
        this.di.context.put("org.jboss.web.AbstractWebContainer.webApp", webApp);
        this.container.addDeployedApp(warURL, webApp);
    }

    public synchronized void stopModule() throws DeploymentException {
        URL warURL = this.di.localUrl != null ? this.di.localUrl : this.di.url;
        String warUrl = warURL.toString();
        try {
            WebApplication webApp = this.container.removeDeployedApp(warURL);
            if (this.deployer != null && webApp != null) {
                this.deployer.stop(this.di);
            } else {
                this.log.debug("Failed to find deployer/deployment for war: " + warUrl);
            }
        }
        catch (DeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeploymentException("Error during stop", e);
        }
    }
}

