/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm.remoting.server;

import java.lang.reflect.Proxy;
import java.rmi.AccessException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.UnexpectedException;
import javax.transaction.HeuristicCommitException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionRolledbackException;
import org.jboss.logging.Logger;
import org.jboss.tm.CoordinatorFactory;
import org.jboss.tm.GlobalId;
import org.jboss.tm.LocalId;
import org.jboss.tm.ResourceFactory;
import org.jboss.tm.StringRemoteRefConverter;
import org.jboss.tm.TMUtil;
import org.jboss.tm.TransactionImpl;
import org.jboss.tm.TxManager;
import org.jboss.tm.XidImpl;
import org.jboss.tm.remoting.Invocation;
import org.jboss.tm.remoting.RemoteProxy;
import org.jboss.tm.remoting.interfaces.Coordinator;
import org.jboss.tm.remoting.interfaces.HeuristicHazardException;
import org.jboss.tm.remoting.interfaces.RecoveryCoordinator;
import org.jboss.tm.remoting.interfaces.Resource;
import org.jboss.tm.remoting.interfaces.Status;
import org.jboss.tm.remoting.interfaces.Terminator;
import org.jboss.tm.remoting.interfaces.TransactionInactiveException;
import org.jboss.tm.remoting.interfaces.TransactionNotPreparedException;
import org.jboss.tm.remoting.interfaces.TxPropagationContext;
import org.jboss.tm.remoting.interfaces.Vote;
import org.jboss.tm.remoting.server.DistributedTransactionManager;

public class DTMServant
implements Invocation.ITransactionFactory,
Invocation.ICoordinator,
Invocation.ITerminator,
Invocation.IResource,
Invocation.IRecoveryCoordinator,
Invocation.ISynchronization,
CoordinatorFactory,
ResourceFactory,
StringRemoteRefConverter {
    private static final Logger log = Logger.getLogger(DTMServant.class);
    private DistributedTransactionManager dtm;

    public DTMServant(DistributedTransactionManager dtm) {
        this.dtm = dtm;
    }

    public TxPropagationContext create(long targetId, int timeout) throws RemoteException {
        log.trace("TransactionFactory.create");
        try {
            TransactionManager tm = TMUtil.getTransactionManager();
            if (timeout != 0) {
                tm.setTransactionTimeout(timeout);
            }
            tm.begin();
            TransactionImpl tx = (TransactionImpl)tm.suspend();
            XidImpl xid = tx.getXid();
            long localId = xid.getLocalIdValue();
            TxPropagationContext tpc = tx.getPropagationContext();
            tpc.terminator = (Terminator)RemoteProxy.create(Terminator.class, localId, this.dtm.getLocators());
            return tpc;
        }
        catch (SystemException e) {
            if (log.isTraceEnabled()) {
                log.trace("Unexpected exception: ", e);
            }
            throw new UnexpectedException("Unexpected " + e, e);
        }
        catch (NotSupportedException e) {
            if (log.isTraceEnabled()) {
                log.trace("Unexpected exception: ", e);
            }
            throw new UnexpectedException("Unexpected " + e, e);
        }
    }

    public TxPropagationContext recreate(long targetId, TxPropagationContext tpc) throws RemoteException {
        log.trace("TransactionFactory.recreate");
        if (tpc == null) {
            throw new IllegalArgumentException("recreate: TxPropagationContext parameter cannot be null");
        }
        TxManager tm = (TxManager)TMUtil.getTransactionManager();
        TransactionImpl tx = tm.importExternalTransaction(tpc.formatId, tpc.globalId, tpc.coordinator, tpc.timeout * 1000);
        Coordinator subCoordinator = (Coordinator)RemoteProxy.create(Coordinator.class, tx.getLocalIdValue(), this.dtm.getLocators());
        return new TxPropagationContext(tpc.formatId, tpc.globalId, tpc.timeout, subCoordinator, null);
    }

    public Status getStatus(long targetId) throws RemoteException {
        int status;
        LocalId localId;
        Transaction tx;
        if (log.isTraceEnabled()) {
            log.trace("Coordinator.getStatus, targetId=" + Long.toHexString(targetId));
        }
        if ((tx = TMUtil.getTransaction(localId = new LocalId(targetId))) == null) {
            log.trace("RemoteException in getStatus: transaction not found");
            throw new NoSuchObjectException("No transaction.");
        }
        try {
            status = tx.getStatus();
        }
        catch (SystemException e) {
            if (log.isTraceEnabled()) {
                log.trace("Unexpected exception: ", e);
            }
            throw new UnexpectedException("Unexpected " + e, e);
        }
        return DTMServant.javaxToJBoss(status);
    }

    public boolean isSameTransaction(long targetId, Coordinator c) throws RemoteException {
        if (log.isTraceEnabled()) {
            log.trace("Coordinator.isSameTransaction, targetId=" + Long.toHexString(targetId));
        }
        return this.getTransactionId(targetId).equals(c.getTransactionId());
    }

    public int hashTransaction(long targetId) throws RemoteException {
        if (log.isTraceEnabled()) {
            log.trace("Coordinator.hashTransaction, targetId=" + Long.toHexString(targetId));
        }
        return this.getTransactionId(targetId).hashCode();
    }

    public RecoveryCoordinator registerResource(long targetId, Resource r) throws RemoteException, TransactionInactiveException {
        LocalId localId;
        TransactionImpl tx;
        if (log.isTraceEnabled()) {
            log.trace("Coordinator.registerResource, targetId=" + Long.toHexString(targetId));
        }
        if ((tx = (TransactionImpl)TMUtil.getTransaction(localId = new LocalId(targetId))) == null) {
            log.trace("RemoteException in registerResource: transaction not found");
            throw new NoSuchObjectException("No transaction.");
        }
        try {
            tx.enlistRemoteResource(r);
        }
        catch (RollbackException e) {
            if (log.isTraceEnabled()) {
                log.trace("Exception: ", e);
            }
            TransactionRolledbackException ex = new TransactionRolledbackException(e.toString());
            ex.detail = e;
            throw ex;
        }
        catch (IllegalStateException e) {
            if (log.isTraceEnabled()) {
                log.trace("Exception: ", e);
            }
            throw new TransactionInactiveException(e);
        }
        RecoveryCoordinator rc = (RecoveryCoordinator)RemoteProxy.create(RecoveryCoordinator.class, targetId, this.dtm.getLocators());
        return rc;
    }

    public void registerSynchronization(long targetId, final org.jboss.tm.remoting.interfaces.Synchronization sync) throws RemoteException, TransactionInactiveException {
        LocalId localId;
        Transaction tx;
        if (log.isTraceEnabled()) {
            log.trace("Coordinator.registerSynchronization, targetId=" + Long.toHexString(targetId));
        }
        if ((tx = TMUtil.getTransaction(localId = new LocalId(targetId))) == null) {
            log.trace("RemoteException in registerSynchronization: transaction not found");
            throw new NoSuchObjectException("No transaction.");
        }
        try {
            tx.registerSynchronization(new Synchronization(){

                public void beforeCompletion() {
                    block2: {
                        try {
                            sync.beforeCompletion();
                        }
                        catch (RemoteException e) {
                            if (!log.isTraceEnabled()) break block2;
                            log.trace("RemoteException in beforeCompletion: " + e);
                        }
                    }
                }

                public void afterCompletion(int status) {
                    block2: {
                        try {
                            sync.afterCompletion(DTMServant.javaxToJBoss(status));
                        }
                        catch (RemoteException e) {
                            if (!log.isTraceEnabled()) break block2;
                            log.trace("RemoteException in afterCompletion: " + e);
                        }
                    }
                }
            });
        }
        catch (RollbackException e) {
            if (log.isTraceEnabled()) {
                log.trace("Exception: ", e);
            }
            TransactionRolledbackException ex = new TransactionRolledbackException(e.toString());
            ex.detail = e;
            throw ex;
        }
        catch (IllegalStateException e) {
            if (log.isTraceEnabled()) {
                log.trace("Unexpected exception: ", e);
            }
            throw new TransactionInactiveException(e);
        }
        catch (SystemException e) {
            if (log.isTraceEnabled()) {
                log.trace("Unexpected exception: ", e);
            }
            throw new UnexpectedException("Unexpected " + e, e);
        }
    }

    public void rollbackOnly(long targetId) throws RemoteException, TransactionInactiveException {
        LocalId localId;
        Transaction tx;
        if (log.isTraceEnabled()) {
            log.trace("Coordinator.rollbackOnly, targetId=" + Long.toHexString(targetId));
        }
        if ((tx = TMUtil.getTransaction(localId = new LocalId(targetId))) == null) {
            log.trace("RemoteException in rollbackOnly: transaction not found");
            throw new NoSuchObjectException("No transaction.");
        }
        try {
            tx.setRollbackOnly();
        }
        catch (IllegalStateException e) {
            if (log.isTraceEnabled()) {
                log.trace("Unexpected exception: ", e);
            }
            throw new TransactionInactiveException(e);
        }
        catch (SystemException e) {
            if (log.isTraceEnabled()) {
                log.trace("Unexpected exception: ", e);
            }
            throw new UnexpectedException("Unexpected " + e, e);
        }
    }

    public TxPropagationContext getTransactionContext(long targetId) throws RemoteException, TransactionInactiveException {
        LocalId localId;
        TransactionImpl tx;
        if (log.isTraceEnabled()) {
            log.trace("Coordinator.getTransactionContext, targetId=" + Long.toHexString(targetId));
        }
        if ((tx = (TransactionImpl)TMUtil.getTransaction(localId = new LocalId(targetId))) == null) {
            log.trace("RemoteException in getTransactionContext: transaction not found");
            throw new NoSuchObjectException("No transaction.");
        }
        TxPropagationContext txPropagationContext = tx.getPropagationContext();
        if (txPropagationContext != null) {
            return tx.getPropagationContext();
        }
        throw new TransactionInactiveException();
    }

    public GlobalId getTransactionId(long targetId) throws RemoteException {
        LocalId localId;
        TransactionImpl tx;
        if (log.isTraceEnabled()) {
            log.trace("Coordinator.getTransactionId, targetId=" + Long.toHexString(targetId));
        }
        if ((tx = (TransactionImpl)TMUtil.getTransaction(localId = new LocalId(targetId))) == null) {
            log.trace("RemoteException in getTransactionId: transaction not found");
            throw new NoSuchObjectException("No transaction.");
        }
        return tx.getGlobalId();
    }

    public void commit(long targetId, boolean reportHeuristics) throws RemoteException, HeuristicMixedException, HeuristicHazardException {
        LocalId localId;
        Transaction tx;
        if (log.isTraceEnabled()) {
            log.trace("Terminator.commit, targetId=" + Long.toHexString(targetId));
        }
        if ((tx = TMUtil.getTransaction(localId = new LocalId(targetId))) == null) {
            log.trace("RemoteException in commit: transaction not found");
            throw new NoSuchObjectException("No transaction.");
        }
        try {
            tx.commit();
        }
        catch (RollbackException e) {
            if (log.isTraceEnabled()) {
                log.trace("Exception: ", e);
            }
            TransactionRolledbackException ex = new TransactionRolledbackException(e.toString());
            ex.detail = e;
            throw ex;
        }
        catch (HeuristicMixedException e) {
            if (log.isTraceEnabled()) {
                log.trace("Exception: ", e);
            }
            if (reportHeuristics) {
                HeuristicMixedException ex = new HeuristicMixedException();
                ex.initCause(e);
                throw ex;
            }
        }
        catch (HeuristicRollbackException e) {
            if (log.isTraceEnabled()) {
                log.trace("Exception: ", e);
            }
            TransactionRolledbackException ex = new TransactionRolledbackException(e.toString());
            ex.detail = e;
            throw ex;
        }
        catch (SecurityException e) {
            if (log.isTraceEnabled()) {
                log.trace("Unexpected exception: ", e);
            }
            throw new AccessException(e.toString(), e);
        }
        catch (IllegalStateException e) {
            if (log.isTraceEnabled()) {
                log.trace("Unexpected exception: ", e);
            }
            throw new RemoteException(e.toString(), e);
        }
        catch (SystemException e) {
            if (log.isTraceEnabled()) {
                log.trace("Unexpected exception: ", e);
            }
            throw new UnexpectedException(e.toString(), e);
        }
    }

    public void rollback(long targetId) throws RemoteException {
        LocalId localId;
        Transaction tx;
        if (log.isTraceEnabled()) {
            log.trace("Terminator.rollback, targetId=" + Long.toHexString(targetId));
        }
        if ((tx = TMUtil.getTransaction(localId = new LocalId(targetId))) == null) {
            log.trace("RemoteException in rollback: transaction not found");
            throw new NoSuchObjectException("No transaction.");
        }
        try {
            tx.rollback();
        }
        catch (IllegalStateException e) {
            if (log.isTraceEnabled()) {
                log.trace("Unexpected exception: ", e);
            }
            throw new RemoteException(e.toString(), e);
        }
        catch (SecurityException e) {
            if (log.isTraceEnabled()) {
                log.trace("Unexpected exception: ", e);
            }
            throw new AccessException(e.toString(), e);
        }
        catch (SystemException e) {
            if (log.isTraceEnabled()) {
                log.trace("Unexpected exception: ", e);
            }
            throw new UnexpectedException(e.toString(), e);
        }
    }

    public Vote prepare(long targetId) throws RemoteException, HeuristicMixedException, HeuristicHazardException {
        LocalId localId;
        TransactionImpl tx;
        if (log.isTraceEnabled()) {
            log.trace("Resource.prepare, targetId=" + Long.toHexString(targetId));
        }
        if ((tx = (TransactionImpl)TMUtil.getTransaction(localId = new LocalId(targetId))) == null) {
            log.trace("RemoteException in prepare: transaction not found");
            throw new NoSuchObjectException("No transaction.");
        }
        TransactionManager tm = TMUtil.getTransactionManager();
        try {
            tm.resume(tx);
            int vote = tx.prepare(null);
            if (vote == 0) {
                Vote vote2 = Vote.COMMIT;
                return vote2;
            }
            Vote vote3 = Vote.READONLY;
            return vote3;
        }
        catch (RollbackException e) {
            Vote vote = Vote.ROLLBACK;
            return vote;
        }
        catch (HeuristicMixedException e) {
            if (log.isTraceEnabled()) {
                log.trace("Exception: ", e);
            }
            HeuristicMixedException ex = new HeuristicMixedException();
            ex.initCause(e);
            throw ex;
        }
        catch (HeuristicRollbackException e) {
            if (log.isTraceEnabled()) {
                log.trace("Exception: ", e);
            }
            HeuristicHazardException ex = new HeuristicHazardException();
            ex.initCause(e);
            throw ex;
        }
        catch (Exception e) {
            if (log.isTraceEnabled()) {
                log.trace("Unexpected exception: ", e);
            }
            throw new UnexpectedException(e.toString(), e);
        }
        finally {
            try {
                tm.suspend();
            }
            catch (SystemException e) {
                if (log.isTraceEnabled()) {
                    log.trace("Unexpected exception: ", e);
                }
                throw new UnexpectedException(e.toString(), e);
            }
        }
    }

    public void rollbackResource(long targetId) throws RemoteException, HeuristicCommitException, HeuristicMixedException, HeuristicHazardException {
        LocalId localId;
        TransactionImpl tx;
        if (log.isTraceEnabled()) {
            log.trace("Resource.rollback, targetId=" + Long.toHexString(targetId));
        }
        if ((tx = (TransactionImpl)TMUtil.getTransaction(localId = new LocalId(targetId))) == null) {
            log.trace("RemoteException in rollback: transaction not found");
            throw new NoSuchObjectException("No transaction.");
        }
        try {
            tx.rollbackBranch();
        }
        catch (IllegalStateException e) {
            if (log.isTraceEnabled()) {
                log.trace("Unexpected exception: ", e);
            }
            throw new RemoteException(e.toString(), e);
        }
    }

    public void commit(long targetId) throws RemoteException, TransactionNotPreparedException, HeuristicRollbackException, HeuristicMixedException, HeuristicHazardException {
        LocalId localId;
        TransactionImpl tx;
        if (log.isTraceEnabled()) {
            log.trace("Resource.commit, targetId=" + Long.toHexString(targetId));
        }
        if ((tx = (TransactionImpl)TMUtil.getTransaction(localId = new LocalId(targetId))) == null) {
            log.trace("RemoteException in commit: transaction not found");
            throw new NoSuchObjectException("No transaction.");
        }
        try {
            tx.commit(false);
        }
        catch (IllegalStateException e) {
            if (log.isTraceEnabled()) {
                log.trace("Exception: ", e);
            }
            TransactionNotPreparedException ex = new TransactionNotPreparedException();
            ex.initCause(e);
            throw ex;
        }
        catch (RollbackException e) {
            if (log.isTraceEnabled()) {
                log.trace("Exception: ", e);
            }
            TransactionRolledbackException ex = new TransactionRolledbackException(e.toString());
            ex.detail = e;
            throw ex;
        }
        catch (HeuristicMixedException e) {
            if (log.isTraceEnabled()) {
                log.trace("Exception: ", e);
            }
            HeuristicMixedException ex = new HeuristicMixedException();
            ex.initCause(e);
            throw ex;
        }
        catch (HeuristicRollbackException e) {
            if (log.isTraceEnabled()) {
                log.trace("Exception: ", e);
            }
            HeuristicRollbackException ex = new HeuristicRollbackException();
            ex.initCause(e);
            throw ex;
        }
        catch (SystemException e) {
            if (log.isTraceEnabled()) {
                log.trace("Unexpected exception: ", e);
            }
            throw new UnexpectedException(e.toString(), e);
        }
    }

    public void commitOnePhase(long targetId) throws RemoteException, HeuristicHazardException {
        LocalId localId;
        TransactionImpl tx;
        if (log.isTraceEnabled()) {
            log.trace("Resource.commitOnePhase, targetId=" + Long.toHexString(targetId));
        }
        if ((tx = (TransactionImpl)TMUtil.getTransaction(localId = new LocalId(targetId))) == null) {
            log.trace("RemoteException in commit: transaction not found");
            throw new NoSuchObjectException("No transaction.");
        }
        try {
            tx.commit(true);
        }
        catch (RollbackException e) {
            if (log.isTraceEnabled()) {
                log.trace("Exception: ", e);
            }
            TransactionRolledbackException ex = new TransactionRolledbackException(e.toString());
            ex.detail = e;
            throw ex;
        }
        catch (HeuristicMixedException e) {
            if (log.isTraceEnabled()) {
                log.trace("Exception: ", e);
            }
            throw new UnexpectedException(e.toString(), e);
        }
        catch (HeuristicRollbackException e) {
            if (log.isTraceEnabled()) {
                log.trace("Exception: ", e);
            }
            throw new UnexpectedException(e.toString(), e);
        }
        catch (SystemException e) {
            if (log.isTraceEnabled()) {
                log.trace("Unexpected exception: ", e);
            }
            throw new UnexpectedException(e.toString(), e);
        }
    }

    public void forget(long targetId) throws RemoteException {
        LocalId localId;
        TransactionImpl tx;
        if (log.isTraceEnabled()) {
            log.trace("Resource.forget, targetId=" + Long.toHexString(targetId));
        }
        if ((tx = (TransactionImpl)TMUtil.getTransaction(localId = new LocalId(targetId))) == null) {
            log.trace("RemoteException in forget: transaction not found");
            throw new NoSuchObjectException("No transaction.");
        }
        tx.forget();
    }

    public Status replayCompletion(long targetId, final Resource r) throws RemoteException, TransactionNotPreparedException {
        TxManager tm;
        if (log.isTraceEnabled()) {
            log.trace("RecoveryCoordinator.replayCompletion, targetId=" + Long.toHexString(targetId));
        }
        if ((tm = (TxManager)TMUtil.getTransactionManager()).isRecoveryPending()) {
            if (log.isTraceEnabled()) {
                log.trace("RecoveryCoordinator.replayCompletion called on targetId=" + Long.toHexString(targetId) + " before recovery is complete.\n" + " Throwing RemoteException.");
            }
            throw new RemoteException("Transaction manager not ready.");
        }
        LocalId localId = new LocalId(targetId);
        TransactionImpl tx = (TransactionImpl)TMUtil.getTransaction(localId);
        if (tx == null) {
            log.trace("RemoteException in replayCompletion: transaction not found");
            throw new NoSuchObjectException("No transaction.");
        }
        int status = tx.replayCompletion(r);
        if (status == 1 || status == 6 || status == 4 || status == 9) {
            Runnable runnable = new Runnable(){

                public void run() {
                    block2: {
                        try {
                            r.rollback();
                        }
                        catch (Exception ignore) {
                            if (!log.isTraceEnabled()) break block2;
                            log.trace("Ignoring exception in remote resource rollback", ignore);
                        }
                    }
                }
            };
            Thread t = new Thread(runnable, "resourceRollbackThread");
            t.start();
        }
        return DTMServant.javaxToJBoss(status);
    }

    public void beforeCompletion(long targetId) {
        if (log.isTraceEnabled()) {
            log.trace("Synchronization.beforeCompletion, targetId=" + Long.toHexString(targetId));
        }
    }

    public void afterCompletion(long targetId) {
        if (log.isTraceEnabled()) {
            log.trace("Synchronization.afterCompletion, targetId=" + Long.toHexString(targetId));
        }
    }

    public Coordinator createCoordinator(long localId) {
        return (Coordinator)RemoteProxy.create(Coordinator.class, localId, this.dtm.getLocators());
    }

    public Resource createResource(long localId) {
        return (Resource)RemoteProxy.create(Resource.class, localId, this.dtm.getLocators());
    }

    public Resource stringToResource(String strResource) {
        try {
            return (Resource)RemoteProxy.fromString(strResource);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public RecoveryCoordinator stringToRecoveryCoordinator(String strRecCoordinator) {
        try {
            return (RecoveryCoordinator)RemoteProxy.fromString(strRecCoordinator);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String resourceToString(Resource res) {
        return RemoteProxy.toString((Proxy)((Object)res));
    }

    public String recoveryCoordinatorToString(RecoveryCoordinator recoveryCoord) {
        return RemoteProxy.toString((Proxy)((Object)recoveryCoord));
    }

    private static Status javaxToJBoss(int status) {
        return Status.fromInteger(status);
    }
}

