/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm.recovery;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Map;
import org.jboss.tm.recovery.HeuristicStatusLogReader;
import org.jboss.tm.recovery.LogRecord;

public class SimpleHeuristicStatusLogReader
implements HeuristicStatusLogReader {
    private File logFile;

    public SimpleHeuristicStatusLogReader(File logFile) {
        this.logFile = logFile;
    }

    public String getLogFileName() {
        return this.logFile.toString();
    }

    public void recover(Map heuristicallyCompletedTransactions) {
        FileInputStream fis;
        try {
            fis = new FileInputStream(this.logFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            if (fis.available() < LogRecord.FULL_HEADER_LEN) {
                return;
            }
            FileChannel channel = fis.getChannel();
            ByteBuffer buf = ByteBuffer.allocate(LogRecord.FULL_HEADER_LEN);
            channel.read(buf);
            int len = LogRecord.getNextRecordLength(buf, 0);
            LogRecord.HeurData data = new LogRecord.HeurData();
            while (len > 0 && channel.read(buf = ByteBuffer.allocate(len + LogRecord.FULL_HEADER_LEN)) >= len) {
                buf.flip();
                LogRecord.getHeurData(buf, len, data);
                switch (data.recordType) {
                    case 72: {
                        heuristicallyCompletedTransactions.put(new Long(data.localTransactionId), data);
                        break;
                    }
                    case 70: {
                        heuristicallyCompletedTransactions.remove(new Long(data.localTransactionId));
                        break;
                    }
                }
                len = LogRecord.getNextRecordLength(buf, len);
            }
        }
        catch (IOException ignore) {
            // empty catch block
        }
        try {
            fis.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void finishRecovery() {
        this.logFile.delete();
    }
}

