/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.repository.spi;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.jboss.util.JBossStringBuilder;

public class Key
implements Comparable {
    private String[] name;
    private Map attributes;
    private int level;

    public Key(String nameExpr) throws ParseException {
        this.parseName(nameExpr);
        this.defineLevel();
    }

    public Key(String[] name, Map attributes) {
        this.name = name;
        this.attributes = attributes;
        this.defineLevel();
    }

    public Key(String name, Map attributes) {
        this.name = new String[]{name};
        this.attributes = attributes;
        this.defineLevel();
    }

    public String[] getName() {
        return this.name;
    }

    public int getLevel() {
        return this.level;
    }

    public Map getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public int compareTo(Object obj) {
        if (!(obj instanceof Key)) {
            throw new ClassCastException("Argument is not a Key, type=" + obj.getClass());
        }
        Key key = (Key)obj;
        int compare = -this.name.length + key.name.length;
        if (compare != 0) {
            return compare;
        }
        for (int i = 0; i < this.name.length; ++i) {
            compare = this.name[i].compareTo(key.name[i]);
            if (compare == 0) continue;
            return compare;
        }
        if (compare == 0) {
            Map keyAttrs = key.attributes;
            if (this.attributes == null) {
                compare = keyAttrs == null ? 0 : keyAttrs.size();
            } else if (keyAttrs == null) {
                compare = this.attributes == null ? 0 : this.attributes.size();
            } else {
                TreeSet set = new TreeSet(this.attributes.keySet());
                set.addAll(keyAttrs.keySet());
                Iterator keys = set.iterator();
                while (keys.hasNext() && compare == 0) {
                    String key1 = (String)keys.next();
                    String value1 = (String)this.attributes.get(key1);
                    String value2 = (String)keyAttrs.get(key1);
                    if (value1 == null && value2 == null) {
                        compare = 0;
                    }
                    if (value1 == null) {
                        compare = -1;
                        continue;
                    }
                    if (value2 == null) {
                        compare = 1;
                        continue;
                    }
                    compare = value1.compareTo(value2);
                }
            }
        }
        return compare;
    }

    public boolean equals(Object obj) {
        return this.compareTo(obj) == 0;
    }

    public int hashCode() {
        int hashCode = ((Object)this.attributes).hashCode();
        for (int i = 0; i < this.name.length; ++i) {
            hashCode += this.name[i].hashCode();
        }
        return hashCode;
    }

    protected void defineLevel() {
        this.level = 0;
        if (this.attributes.containsKey("DOMAIN")) {
            this.level = 0;
        }
        if (this.attributes.containsKey("CLUSTER")) {
            this.level = 1;
        }
        if (this.attributes.containsKey("SERVER")) {
            this.level = 2;
        }
        if (this.attributes.containsKey("APPLICATION")) {
            this.level = 3;
        }
        if (this.attributes.containsKey("DEPLOYMENT")) {
            this.level = 4;
        }
        if (this.attributes.containsKey("SESSION")) {
            this.level = 5;
        }
    }

    protected void parseName(String nameExpr) throws ParseException {
        int colon = nameExpr.indexOf(58);
        if (colon < 0) {
            this.parseNamePart(nameExpr);
        } else {
            this.parseNamePart(nameExpr.substring(0, colon));
            StringTokenizer tokenizer = new StringTokenizer(nameExpr.substring(colon + 1), ",=");
            while (tokenizer.hasMoreTokens()) {
                String key = tokenizer.nextToken();
                if (!tokenizer.hasMoreTokens()) {
                    throw new ParseException("No value for key: " + key, this.attributes.size());
                }
                String value = tokenizer.nextToken();
                if (this.attributes == null) {
                    this.attributes = new HashMap();
                }
                this.attributes.put(key, value);
            }
        }
    }

    private void parseNamePart(String namePart) {
        ArrayList<String> names = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(namePart, ",");
        while (tokenizer.hasMoreTokens()) {
            names.add(tokenizer.nextToken());
        }
        this.name = names.toArray(new String[names.size()]);
    }

    public String toString() {
        JBossStringBuilder sb = new JBossStringBuilder();
        sb.append("[Key[");
        sb.append(Arrays.asList(this.name));
        sb.append(":");
        boolean first = true;
        Iterator it = this.attributes.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(key);
            sb.append("=");
            sb.append(this.attributes.get(key));
        }
        sb.append("]]");
        return sb.toString();
    }
}

