/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.servlet;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.marshal.MarshalFactory;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.remoting.transport.servlet.ServletServerInvokerMBean;
import org.jboss.remoting.transport.web.WebServerInvoker;
import org.jboss.remoting.transport.web.WebUtil;

public class ServletServerInvoker
extends WebServerInvoker
implements ServletServerInvokerMBean {
    public ServletServerInvoker(InvokerLocator locator) {
        super(locator);
    }

    public ServletServerInvoker(InvokerLocator locator, Map configuration) {
        super(locator, configuration);
    }

    protected String getDefaultDataType() {
        return "http";
    }

    public String getMBeanObjectName() {
        return "jboss.remoting:service=invoker,transport=servlet";
    }

    public void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HashMap<String, String> metadata = new HashMap<String, String>();
        Enumeration enumer = request.getHeaderNames();
        while (enumer.hasMoreElements()) {
            Object obj = enumer.nextElement();
            String headerKey = (String)obj;
            String headerValue = request.getHeader(headerKey);
            metadata.put(headerKey, headerValue);
        }
        Map urlParams = request.getParameterMap();
        metadata.putAll(urlParams);
        String requestContentType = request.getContentType();
        try {
            Object invocationResponse = null;
            ServletInputStream inputStream = request.getInputStream();
            UnMarshaller unmarshaller = MarshalFactory.getUnMarshaller("http", this.getSerializationType());
            Object obj = unmarshaller.read((InputStream)inputStream, metadata);
            inputStream.close();
            InvocationRequest invocationRequest = null;
            invocationRequest = obj instanceof InvocationRequest ? (InvocationRequest)obj : (WebUtil.isBinary(requestContentType) ? this.getInvocationRequest(metadata, obj) : this.createNewInvocationRequest(metadata, obj));
            try {
                invocationResponse = this.invoke(invocationRequest);
            }
            catch (Throwable ex) {
                this.log.debug("Error thrown calling invoke on server invoker.", ex);
                invocationResponse = null;
                response.sendError(500, "Error processing invocation request.  " + ex.getMessage());
            }
            if (invocationResponse != null) {
                response.setContentType(requestContentType);
                int iContentLength = this.getContentLength(invocationResponse);
                response.setContentLength(iContentLength);
                ServletOutputStream outputStream = response.getOutputStream();
                Marshaller marshaller = MarshalFactory.getMarshaller("http", this.getSerializationType());
                marshaller.write(invocationResponse, (OutputStream)outputStream);
                outputStream.close();
            }
        }
        catch (ClassNotFoundException e) {
            this.log.error("Error processing invocation request due to class not being found.", e);
            response.sendError(500, "Error processing invocation request due to class not being found.  " + e.getMessage());
        }
    }

    public byte[] processRequest(HttpServletRequest request, byte[] requestByte, HttpServletResponse response) throws ServletException, IOException {
        byte[] retval = null;
        HashMap<String, String> metadata = new HashMap<String, String>();
        Enumeration enumer = request.getHeaderNames();
        while (enumer.hasMoreElements()) {
            Object obj = enumer.nextElement();
            String headerKey = (String)obj;
            String headerValue = request.getHeader(headerKey);
            metadata.put(headerKey, headerValue);
        }
        Map urlParams = request.getParameterMap();
        metadata.putAll(urlParams);
        metadata.put("MethodType", request.getMethod());
        metadata.put("Path", request.getPathTranslated());
        String requestContentType = request.getContentType();
        try {
            Integer handlerStatus;
            Map responseMap;
            Object invocationResponse = null;
            ServletInputStream inputStream = request.getInputStream();
            UnMarshaller unmarshaller = this.getUnMarshaller();
            Object obj = unmarshaller.read(new ByteArrayInputStream(requestByte), metadata);
            inputStream.close();
            boolean isError = false;
            InvocationRequest invocationRequest = null;
            invocationRequest = obj instanceof InvocationRequest ? (InvocationRequest)obj : (WebUtil.isBinary(requestContentType) ? this.getInvocationRequest(metadata, obj) : this.createNewInvocationRequest(metadata, obj));
            try {
                invocationResponse = this.invoke(invocationRequest);
            }
            catch (Throwable ex) {
                this.log.debug("Error thrown calling invoke on server invoker.", ex);
                invocationResponse = ex;
                isError = true;
            }
            int status = 204;
            if (invocationResponse != null) {
                if (isError) {
                    response.sendError(500, "Error occurred processing invocation request. ");
                } else {
                    status = 200;
                }
            }
            if ((responseMap = invocationRequest.getReturnPayload()) != null && (handlerStatus = (Integer)responseMap.get("ResponseCode")) != null) {
                status = handlerStatus;
            }
            response.setStatus(status);
            if (invocationResponse != null) {
                String responseContentType = invocationResponse == null ? requestContentType : WebUtil.getContentType(invocationResponse);
                response.setContentType(responseContentType);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                Marshaller marshaller = this.getMarshaller();
                marshaller.write(invocationResponse, outputStream);
                retval = outputStream.toByteArray();
                response.setContentLength(retval.length);
            }
        }
        catch (ClassNotFoundException e) {
            this.log.error("Error processing invocation request due to class not being found.", e);
            response.sendError(500, "Error processing invocation request due to class not being found.  " + e.getMessage());
        }
        return retval;
    }
}

