/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.multiplex;

import java.io.IOException;
import java.net.InetAddress;

public class AddressPair {
    private InetAddress localHost;
    private int localPort;
    private InetAddress remoteHost;
    private int remotePort;
    private boolean hashCodeSet = false;
    private int hashCode;

    public AddressPair(String remoteHost, int remotePort, String localHost, int localPort) throws IOException {
        this.localHost = InetAddress.getByName(localHost);
        this.localPort = localPort;
        this.remoteHost = InetAddress.getByName(remoteHost);
        this.remotePort = remotePort;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof AddressPair)) {
            return false;
        }
        AddressPair ap = (AddressPair)o;
        return this.localHost.equals(ap.localHost) && this.localPort == ap.localPort && this.remoteHost.equals(ap.remoteHost) && this.remotePort == ap.remotePort;
    }

    public int hashCode() {
        if (!this.hashCodeSet) {
            this.hashCode = this.localHost.hashCode() * this.localPort + this.remoteHost.hashCode() * this.remotePort;
            this.hashCodeSet = true;
        }
        return this.hashCode;
    }

    public String getLocalHost() {
        return this.localHost.getHostName();
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public String getRemoteHost() {
        return this.remoteHost.getHostName();
    }

    public int getRemotePort() {
        return this.remotePort;
    }
}

