/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.chat.client;

import java.awt.Component;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import org.jboss.logging.Logger;
import org.jboss.remoting.samples.chat.client.ChatInfo;
import org.jboss.remoting.samples.chat.client.ChatMember;
import org.jboss.remoting.samples.chat.client.ChatMessage;
import org.jboss.remoting.samples.chat.client.CloseableFrame;
import org.jboss.remoting.samples.chat.client.ConnectionStrategy;
import org.jboss.remoting.samples.chat.client.CreateConnectionStrategy;
import org.jboss.remoting.samples.chat.client.CreateFrame;
import org.jboss.remoting.samples.chat.client.InfoConnectionStrategy;
import org.jboss.remoting.samples.chat.client.InfoFrame;
import org.jboss.remoting.samples.chat.client.JoinConnectionStrategy;
import org.jboss.remoting.samples.chat.client.JoinFrame;
import org.jboss.remoting.samples.chat.client.ListConnectionStrategy;
import org.jboss.remoting.samples.chat.client.ListFrame;
import org.jboss.remoting.samples.chat.client.RemoteStrategy;
import org.jboss.remoting.samples.chat.client.ShutDownDialog;
import org.jboss.remoting.samples.chat.client.TalkConnectionStrategy;
import org.jboss.remoting.samples.chat.client.TalkFrame;
import org.jboss.remoting.samples.chat.client.Wrapper;
import org.jboss.remoting.samples.chat.exceptions.ConnectionException;
import org.jboss.remoting.samples.chat.exceptions.CreateConnectionException;
import org.jboss.remoting.samples.chat.exceptions.JoinConnectionException;
import org.jboss.remoting.samples.chat.exceptions.ListConnectionException;
import org.jboss.remoting.samples.chat.exceptions.NameInUseException;
import org.jboss.remoting.samples.chat.exceptions.RemoteConnectionException;
import org.jboss.remoting.samples.chat.exceptions.ShuttingDownException;
import org.jboss.remoting.samples.chat.exceptions.TalkConnectionException;
import org.jboss.remoting.samples.chat.server.ChatServer;
import org.jboss.remoting.samples.chat.utility.ReadWriteArrayList;

public class LocalStrategy
implements ConnectionStrategy,
CreateConnectionStrategy,
InfoConnectionStrategy,
JoinConnectionStrategy,
ListConnectionStrategy {
    protected static final Logger log = Logger.getLogger(class$org$jboss$remoting$samples$chat$client$LocalStrategy == null ? (class$org$jboss$remoting$samples$chat$client$LocalStrategy = LocalStrategy.class$("org.jboss.remoting.samples.chat.client.LocalStrategy")) : class$org$jboss$remoting$samples$chat$client$LocalStrategy);
    private RemoteStrategy remoteStrategy;
    private CloseableFrame parent;
    private CreateFrame createFrame;
    private InfoFrame infoFrame;
    private JoinFrame joinFrame;
    private ListFrame listFrame;
    private TalkFrame talkFrame;
    private Thread readThread;
    private boolean isChatting;
    private ShutDownDialog shuttingDownDialog = new ShutDownDialog();
    private Runnable shuttingDownDialogRunnable = new Runnable(){

        public void run() {
            LocalStrategy.this.shuttingDownDialog.show();
        }
    };
    static /* synthetic */ Class class$org$jboss$remoting$samples$chat$client$LocalStrategy;

    public LocalStrategy(CloseableFrame parent, RemoteStrategy remoteStrategy) {
        this.parent = parent;
        this.remoteStrategy = remoteStrategy;
    }

    public void list() {
        final Wrapper chatRoomDescriptions = new Wrapper();
        Thread t = new Thread(){

            public void run() {
                try {
                    chatRoomDescriptions.set(LocalStrategy.this.remoteStrategy.list());
                }
                catch (ShuttingDownException e) {
                    SwingUtilities.invokeLater(LocalStrategy.this.shuttingDownDialogRunnable);
                }
                catch (RemoteConnectionException e) {
                    log.error(e);
                }
                Runnable r = new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        new ListFrame(1.access$200(this.this$1), (ArrayList)1.access$300(this.this$1).get(), LocalStrategy.access$400(1.access$200(this.this$1))).show();
                    }
                };
                SwingUtilities.invokeLater(r);
            }

            static /* synthetic */ LocalStrategy access$200(1 x0) {
                return x0.LocalStrategy.this;
            }

            static /* synthetic */ Wrapper access$300(1 x0) {
                return x0.chatRoomDescriptions;
            }
        };
        t.start();
    }

    public void create() throws ConnectionException {
        this.createFrame = new CreateFrame(this, this.parent);
        this.createFrame.show();
    }

    public void createChat(final String description, final ChatMember owner) throws CreateConnectionException {
        Thread t = new Thread(){
            TalkFrame talkFrame;
            ReadWriteArrayList outgoingLines;
            ChatServer chatServer;
            {
                this.talkFrame = new TalkFrame(description, owner.get_name(), LocalStrategy.this.parent);
                this.outgoingLines = new ReadWriteArrayList();
                this.chatServer = null;
            }

            public void run() {
                try {
                    this.chatServer = LocalStrategy.this.remoteStrategy.createChat(description, owner, this.talkFrame, this.outgoingLines);
                }
                catch (ShuttingDownException sde) {
                    SwingUtilities.invokeLater(LocalStrategy.this.shuttingDownDialogRunnable);
                }
                catch (RemoteConnectionException e) {
                    log.error("Cannot create chat room: " + description);
                    log.error(e);
                }
                catch (NameInUseException e) {
                    System.out.println("Pick a new name");
                }
                Runnable r = new Runnable(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        this.this$1.talkFrame.registerStrategy(3.access$600(this.this$1).new TalkConnectionStrategyImpl(3.access$500(this.this$1), this.this$1.chatServer, this.this$1.outgoingLines));
                        this.this$1.talkFrame.show();
                    }
                };
                SwingUtilities.invokeLater(r);
            }

            static /* synthetic */ ChatMember access$500(3 x0) {
                return x0.owner;
            }

            static /* synthetic */ LocalStrategy access$600(3 x0) {
                return x0.LocalStrategy.this;
            }
        };
        t.start();
    }

    public void join(final ChatInfo chatInfo, final ChatMember newMember) throws JoinConnectionException {
        Thread t = new Thread(){
            TalkFrame talkFrame;
            ReadWriteArrayList outgoingLines;
            Wrapper remoteChatServerWrapper;
            ChatServer chatServer;
            {
                this.talkFrame = new TalkFrame(chatInfo.get_description(), newMember.get_name(), LocalStrategy.this.parent);
                this.outgoingLines = new ReadWriteArrayList();
                this.remoteChatServerWrapper = new Wrapper();
                this.chatServer = null;
            }

            public void run() {
                try {
                    this.chatServer = LocalStrategy.this.remoteStrategy.join(chatInfo.get_key(), newMember, this.talkFrame, this.outgoingLines);
                }
                catch (ShuttingDownException sde) {
                    SwingUtilities.invokeLater(LocalStrategy.this.shuttingDownDialogRunnable);
                }
                catch (RemoteConnectionException e) {
                    log.error("Cannot join chat room: " + chatInfo.get_description());
                    log.error(e);
                }
                catch (NameInUseException niue) {
                    System.out.println("Pick a new name");
                }
                Runnable r = new Runnable(this){
                    private final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        this.this$1.talkFrame.registerStrategy(5.access$800(this.this$1).new TalkConnectionStrategyImpl(5.access$700(this.this$1), this.this$1.chatServer, this.this$1.outgoingLines));
                        this.this$1.talkFrame.registerChatKey(5.access$900(this.this$1).get_key());
                        this.this$1.talkFrame.show();
                    }
                };
                SwingUtilities.invokeLater(r);
            }

            static /* synthetic */ ChatMember access$700(5 x0) {
                return x0.newMember;
            }

            static /* synthetic */ LocalStrategy access$800(5 x0) {
                return x0.LocalStrategy.this;
            }

            static /* synthetic */ ChatInfo access$900(5 x0) {
                return x0.chatInfo;
            }
        };
        t.start();
    }

    public void getId(ChatInfo chatInfo) {
        this.joinFrame = new JoinFrame(chatInfo, this, this.parent);
        this.joinFrame.show();
    }

    public void getInfo(ArrayList chatInfoList, int key) throws ListConnectionException {
        this.infoFrame = new InfoFrame(this, (ChatInfo)chatInfoList.get(key), this.parent);
        this.infoFrame.show();
    }

    public void notifyOnClose(Component c) {
        c.setVisible(false);
    }

    protected boolean isChatting() {
        return this.isChatting;
    }

    protected void setIsChatting(boolean b) {
        this.isChatting = b;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class TalkConnectionStrategyImpl
    implements TalkConnectionStrategy {
        private ChatServer chatServer;
        private ChatMember member;
        private ReadWriteArrayList outgoingLines;

        public TalkConnectionStrategyImpl(ChatMember member, ChatServer cs, ReadWriteArrayList outgoingLines) {
            this.chatServer = cs;
            this.member = member;
            this.outgoingLines = outgoingLines;
        }

        public void send(ChatMessage message) throws TalkConnectionException {
            this.outgoingLines.add(message);
        }

        public void leave() {
            Thread t = new Thread(this){
                private final /* synthetic */ TalkConnectionStrategyImpl this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    try {
                        TalkConnectionStrategyImpl.access$1100(this.this$1).leave(TalkConnectionStrategyImpl.access$1000(this.this$1));
                    }
                    catch (ShuttingDownException sde) {
                        SwingUtilities.invokeLater(LocalStrategy.access$100(TalkConnectionStrategyImpl.access$1200(this.this$1)));
                    }
                    catch (RemoteConnectionException e) {
                        log.error("TalkConnectionStrategy.leave(): unable to leave chat room");
                        log.error(e);
                    }
                    TalkConnectionStrategyImpl.access$1102(this.this$1, null);
                }
            };
            t.start();
        }

        static /* synthetic */ ChatMember access$1000(TalkConnectionStrategyImpl x0) {
            return x0.member;
        }

        static /* synthetic */ ChatServer access$1100(TalkConnectionStrategyImpl x0) {
            return x0.chatServer;
        }

        static /* synthetic */ LocalStrategy access$1200(TalkConnectionStrategyImpl x0) {
            return x0.LocalStrategy.this;
        }

        static /* synthetic */ ChatServer access$1102(TalkConnectionStrategyImpl x0, ChatServer x1) {
            x0.chatServer = x1;
            return x0.chatServer;
        }
    }
}

