/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.deployment;

import java.util.ArrayList;
import java.util.List;
import org.jboss.beans.metadata.spi.BeanMetaDataFactory;
import org.jboss.beans.metadata.spi.ClassLoaderMetaData;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;
import org.jboss.util.collection.CollectionsFactory;

public class AbstractKernelDeployment
extends JBossObject
implements KernelDeployment {
    protected String name;
    protected boolean installed;
    protected List installedContexts = CollectionsFactory.createCopyOnWriteList();
    protected List beanFactories;
    protected ClassLoaderMetaData classLoader;

    public void setBeans(List beans) {
        this.beanFactories = beans;
        this.flushJBossObjectCache();
    }

    public void setBeanFactories(List beanFactories) {
        this.beanFactories = beanFactories;
        this.flushJBossObjectCache();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.flushJBossObjectCache();
    }

    public boolean isInstalled() {
        return this.installed;
    }

    public void setInstalled(boolean installed) {
        this.installed = installed;
        this.flushJBossObjectCache();
    }

    public void addInstalledContext(KernelControllerContext context) {
        this.installedContexts.add(context);
        this.flushJBossObjectCache();
    }

    public List getInstalledContexts() {
        return this.installedContexts;
    }

    public void removeInstalledContext(KernelControllerContext context) {
        this.installedContexts.remove(context);
        this.flushJBossObjectCache();
    }

    public List getBeans() {
        if (this.beanFactories == null || this.beanFactories.size() == 0) {
            return null;
        }
        ArrayList result = new ArrayList(this.beanFactories.size());
        for (int i = 0; i < this.beanFactories.size(); ++i) {
            BeanMetaDataFactory factory = (BeanMetaDataFactory)this.beanFactories.get(i);
            List beans = factory.getBeans();
            result.addAll(beans);
        }
        return result;
    }

    public List getBeanFactories() {
        return this.beanFactories;
    }

    public ClassLoaderMetaData getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoaderMetaData classLoader) {
        this.classLoader = classLoader;
    }

    public void toString(JBossStringBuilder buffer) {
        buffer.append("name=").append(this.name);
        buffer.append(" installed=").append(this.installed);
        if (this.classLoader != null) {
            buffer.append(" classLoader=").append(this.classLoader);
        }
        if (this.beanFactories != null) {
            buffer.append(" beanFactories=").append(this.beanFactories);
        }
    }

    public void toShortString(JBossStringBuilder buffer) {
        buffer.append(this.name);
    }
}

