/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.deployment;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.ClassLoaderMetaData;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyInfo;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.dependency.AbstractKernelControllerContext;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.logging.Logger;
import org.jboss.util.JBossStringBuilder;

public class AbstractKernelDeployer {
    private static final Logger log = Logger.getLogger(AbstractKernelDeployer.class);
    protected Kernel kernel;
    protected KernelController controller;
    protected ControllerState requiredState;
    protected ControllerMode mode;

    public AbstractKernelDeployer(Kernel kernel) {
        this(kernel, null, null);
    }

    public AbstractKernelDeployer(final Kernel kernel, ControllerState requiredState, ControllerMode mode) {
        if (kernel == null) {
            throw new IllegalArgumentException("Null kernel");
        }
        this.kernel = kernel;
        PrivilegedAction action = new PrivilegedAction(){

            public Object run() {
                AbstractKernelDeployer.this.controller = kernel.getController();
                return null;
            }
        };
        AccessController.doPrivileged(action);
        this.requiredState = requiredState;
        this.mode = mode;
    }

    public void deploy(KernelDeployment deployment) throws Throwable {
        if (deployment.isInstalled()) {
            throw new IllegalArgumentException("Already installed " + deployment.getName());
        }
        try {
            this.deployBeans(this.controller, deployment);
            deployment.setInstalled(true);
        }
        catch (Throwable t) {
            this.undeploy(deployment);
            throw t;
        }
    }

    public void change(KernelDeployment deployment, ControllerState state) throws Throwable {
        if (!deployment.isInstalled()) {
            throw new IllegalStateException("Not installed " + deployment.getName());
        }
        this.changeBeans(this.controller, deployment, state);
    }

    public void undeploy(KernelDeployment deployment) {
        this.undeployBeans(this.controller, deployment);
        deployment.setInstalled(false);
    }

    public void validate() throws Throwable {
        Set notInstalled = this.controller.getNotInstalled();
        this.internalValidate(notInstalled);
    }

    public void validate(KernelDeployment deployment) throws Throwable {
        HashSet notInstalled = new HashSet(deployment.getInstalledContexts());
        this.internalValidate(notInstalled);
    }

    protected void internalValidate(Set notInstalled) throws Throwable {
        if (!notInstalled.isEmpty()) {
            Iterator i = notInstalled.iterator();
            while (i.hasNext()) {
                KernelControllerContext context = (KernelControllerContext)i.next();
                if (!context.getState().equals(context.getRequiredState())) continue;
                i.remove();
            }
            if (!notInstalled.isEmpty()) {
                KernelControllerContext ctx;
                Iterator i2;
                HashSet<KernelControllerContext> errors = new HashSet<KernelControllerContext>();
                HashSet<KernelControllerContext> incomplete = new HashSet<KernelControllerContext>();
                Iterator i3 = notInstalled.iterator();
                while (i3.hasNext()) {
                    KernelControllerContext ctx2 = (KernelControllerContext)i3.next();
                    if (ctx2.getState().equals(ControllerState.ERROR)) {
                        errors.add(ctx2);
                        continue;
                    }
                    incomplete.add(ctx2);
                }
                JBossStringBuilder buffer = new JBossStringBuilder();
                buffer.append("Incompletely deployed:\n");
                if (errors.size() != 0) {
                    buffer.append("\n*** DEPLOYMENTS IN ERROR: Name -> Error\n");
                    i2 = errors.iterator();
                    while (i2.hasNext()) {
                        ctx = (KernelControllerContext)i2.next();
                        buffer.append(ctx.getName()).append(" -> ").append(ctx.getError().toString()).append('\n');
                    }
                }
                if (incomplete.size() != 0) {
                    buffer.append("\n*** DEPLOYMENTS MISSING DEPENDENCIES: Name -> Dependency{Required State:Actual State}\n");
                    i2 = incomplete.iterator();
                    while (i2.hasNext()) {
                        ctx = (KernelControllerContext)i2.next();
                        buffer.append(ctx.getName()).append(" -> ");
                        DependencyInfo dependsInfo = ctx.getDependencyInfo();
                        Set depends = dependsInfo.getIDependOn(null);
                        Iterator j = depends.iterator();
                        while (j.hasNext()) {
                            DependencyItem item = (DependencyItem)j.next();
                            buffer.append(item.getIDependOn()).append('{').append(item.getWhenRequired().getStateString());
                            buffer.append(':');
                            ControllerContext other = this.controller.getContext(item.getIDependOn(), null);
                            if (other == null) {
                                buffer.append("** NOT FOUND **");
                            } else {
                                buffer.append(other.getState().getStateString());
                            }
                            buffer.append('}');
                            if (!j.hasNext()) continue;
                            buffer.append(", ");
                        }
                        buffer.append('\n');
                    }
                }
                throw new IllegalStateException(buffer.toString());
            }
        }
    }

    protected void deployBeans(KernelController controller, KernelDeployment deployment) throws Throwable {
        List beans = deployment.getBeans();
        if (beans != null) {
            for (int i = 0; i < beans.size(); ++i) {
                BeanMetaData metaData = (BeanMetaData)beans.get(i);
                KernelControllerContext context = this.deployBean(controller, deployment, metaData);
                deployment.addInstalledContext(context);
            }
        }
    }

    protected KernelControllerContext deployBean(KernelController controller, KernelDeployment deployment, BeanMetaData bean) throws Throwable {
        ClassLoaderMetaData deploymentClassLoader;
        ClassLoaderMetaData beanClassLoader;
        AbstractKernelControllerContext context = new AbstractKernelControllerContext(null, bean, null);
        if (this.requiredState != null) {
            context.setRequiredState(this.requiredState);
        }
        if (this.mode != null) {
            context.setMode(this.mode);
        }
        if ((beanClassLoader = bean.getClassLoader()) == null && deployment != null && (deploymentClassLoader = deployment.getClassLoader()) != null) {
            bean.setClassLoader(deploymentClassLoader);
        }
        controller.install(context);
        return context;
    }

    protected void changeBeans(KernelController controller, KernelDeployment deployment, ControllerState state) throws Throwable {
        List contexts = deployment.getInstalledContexts();
        if (contexts != null) {
            Iterator i = contexts.iterator();
            while (i.hasNext()) {
                KernelControllerContext context = (KernelControllerContext)i.next();
                this.changeBean(controller, context, state);
            }
        }
    }

    protected void changeBean(KernelController controller, KernelControllerContext context, ControllerState state) throws Throwable {
        if (ControllerMode.MANUAL.equals(context.getMode()) && !ControllerState.ERROR.equals(context.getState())) {
            controller.change(context, state);
        }
    }

    protected void undeployBeans(KernelController controller, KernelDeployment deployment) {
        List contexts = deployment.getInstalledContexts();
        if (!contexts.isEmpty()) {
            ListIterator i = contexts.listIterator(contexts.size());
            while (i.hasPrevious()) {
                KernelControllerContext context = (KernelControllerContext)i.previous();
                try {
                    this.undeployBean(controller, context);
                    deployment.removeInstalledContext(context);
                }
                catch (Throwable ignored) {
                    log.warn("Ignored error during uninstall of " + context, ignored);
                }
            }
        }
    }

    protected void undeployBean(KernelController controller, KernelControllerContext context) throws Throwable {
        if (!ControllerState.ERROR.equals(context.getState())) {
            controller.uninstall(context.getName());
        }
    }
}

