/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.stateless;

import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Map;
import javax.ejb.EJBException;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import org.jboss.annotation.ejb.LocalBinding;
import org.jboss.annotation.ejb.RemoteBinding;
import org.jboss.annotation.ejb.RemoteBindings;
import org.jboss.aop.AspectManager;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.InvocationResponse;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aop.util.MethodHashing;
import org.jboss.aspects.asynch.FutureHolder;
import org.jboss.ejb.AllowedOperationsAssociation;
import org.jboss.ejb.AllowedOperationsFlags;
import org.jboss.ejb.txtimer.TimedObjectInvoker;
import org.jboss.ejb3.EJBContainerInvocation;
import org.jboss.ejb3.Ejb3Deployment;
import org.jboss.ejb3.EjbTimerUtil;
import org.jboss.ejb3.ProxyUtils;
import org.jboss.ejb3.SessionContainer;
import org.jboss.ejb3.interceptor.InterceptorInfoRepository;
import org.jboss.ejb3.stateless.StatelessBeanContext;
import org.jboss.ejb3.stateless.StatelessLocalProxyFactory;
import org.jboss.ejb3.stateless.StatelessRemoteProxyFactory;
import org.jboss.logging.Logger;
import org.jboss.proxy.ejb.handle.HomeHandleImpl;
import org.jboss.proxy.ejb.handle.StatelessHandleImpl;

public class StatelessContainer
extends SessionContainer
implements TimedObjectInvoker {
    private static final Logger log = Logger.getLogger(StatelessContainer.class);
    protected TimerService timerService;

    public StatelessContainer(ClassLoader cl, String beanClassName, String ejbName, AspectManager manager, Hashtable ctxProperties, InterceptorInfoRepository interceptorRepository, Ejb3Deployment deployment) {
        super(cl, beanClassName, ejbName, manager, ctxProperties, interceptorRepository, deployment);
        this.beanContextClass = StatelessBeanContext.class;
    }

    public void start() throws Exception {
        try {
            super.start();
            this.timerService = EjbTimerUtil.getTimerService(this, this);
        }
        catch (Exception e) {
            try {
                this.stop();
            }
            catch (Exception ignore) {
                log.debug("Failed to cleanup after start() failure", ignore);
            }
            throw e;
        }
    }

    public void stop() throws Exception {
        if (this.timerService != null) {
            EjbTimerUtil.removeTimerService(this);
        }
        super.stop();
    }

    public TimerService getTimerService() {
        return this.timerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callTimeout(Timer timer) throws Exception {
        Method timeout = this.callbackHandler.getTimeoutCallback();
        if (timeout == null) {
            throw new EJBException("No method has been annotated with @Timeout");
        }
        Object[] args = new Object[]{timer};
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        try {
            AllowedOperationsAssociation.pushInMethodFlag(AllowedOperationsFlags.IN_EJB_TIMEOUT);
            try {
                MethodInfo info = (MethodInfo)this.methodInterceptors.get(this.callbackHandler.getTimeoutCalllbackHash());
                Interceptor[] aspects = info.interceptors;
                EJBContainerInvocation nextInvocation = new EJBContainerInvocation(info, aspects);
                nextInvocation.setAdvisor(this);
                nextInvocation.setArguments(args);
                nextInvocation.invokeNext();
            }
            catch (Throwable throwable) {
                if (throwable instanceof Exception) {
                    throw (Exception)throwable;
                }
                throw new RuntimeException(throwable);
            }
            finally {
                AllowedOperationsAssociation.popInMethodFlag();
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    public Object localInvoke(Method method, Object[] args) throws Throwable {
        return this.localInvoke(method, args, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object localInvoke(Method method, Object[] args, FutureHolder provider) throws Throwable {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        try {
            long hash = MethodHashing.calculateHash(method);
            MethodInfo info = (MethodInfo)this.methodInterceptors.get(hash);
            if (info == null) {
                throw new RuntimeException("Could not resolve beanClass method from proxy call: " + method.toString());
            }
            if (info.unadvisedMethod != null) {
                this.invokedMethod.put(this, info.unadvisedMethod);
            }
            if (info.unadvisedMethod != null && this.isHomeMethod(info.unadvisedMethod)) {
                Object object = this.invokeLocalHomeMethod(info, args);
                return object;
            }
            Interceptor[] aspects = info.interceptors;
            EJBContainerInvocation nextInvocation = new EJBContainerInvocation(info, aspects);
            nextInvocation.setAdvisor(this);
            nextInvocation.setArguments(args);
            ProxyUtils.addLocalAsynchronousInfo(nextInvocation, provider);
            Object object = nextInvocation.invokeNext();
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InvocationResponse dynamicInvoke(Object target, Invocation invocation) throws Throwable {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        try {
            InvocationResponse response;
            Thread.currentThread().setContextClassLoader(this.classloader);
            MethodInvocation si = (MethodInvocation)invocation;
            MethodInfo info = (MethodInfo)this.methodInterceptors.get(si.getMethodHash());
            if (info == null) {
                throw new RuntimeException("Could not resolve beanClass method from proxy call");
            }
            if (info.unadvisedMethod != null) {
                this.invokedMethod.put(this, info.unadvisedMethod);
            }
            Map responseContext = null;
            Object rtn = null;
            if (info.unadvisedMethod != null && this.isHomeMethod(info.unadvisedMethod)) {
                rtn = this.invokeHomeMethod(info, si);
            } else if (info != null && info.unadvisedMethod != null && this.isEJBObjectMethod(info.unadvisedMethod)) {
                rtn = this.invokeEJBObjectMethod(info, si);
            } else {
                EJBContainerInvocation newSi = null;
                Interceptor[] aspects = info.interceptors;
                newSi = new EJBContainerInvocation(info, aspects);
                newSi.setArguments(si.getArguments());
                newSi.setMetaData(si.getMetaData());
                newSi.setAdvisor(this);
                try {
                    rtn = newSi.invokeNext();
                    responseContext = newSi.getResponseContextInfo();
                }
                catch (Throwable throwable) {
                    responseContext = newSi.getResponseContextInfo();
                    InvocationResponse invocationResponse = StatelessContainer.marshallException(invocation, throwable, responseContext);
                    Thread.currentThread().setContextClassLoader(oldLoader);
                    return invocationResponse;
                }
            }
            InvocationResponse invocationResponse = response = StatelessContainer.marshallResponse(invocation, rtn, responseContext);
            return invocationResponse;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    protected Object invokeEJBObjectMethod(MethodInfo info, MethodInvocation invocation) throws Throwable {
        if (info.unadvisedMethod.getName().equals("getHandle")) {
            StatelessHandleImpl handle = null;
            RemoteBinding remoteBindingAnnotation = (RemoteBinding)this.resolveAnnotation(RemoteBinding.class);
            if (remoteBindingAnnotation != null) {
                handle = new StatelessHandleImpl(remoteBindingAnnotation.jndiBinding());
            }
            return handle;
        }
        if (info.unadvisedMethod.getName().equals("remove")) {
            return null;
        }
        if (info.unadvisedMethod.getName().equals("getEJBHome")) {
            HomeHandleImpl homeHandle = null;
            RemoteBinding remoteBindingAnnotation = (RemoteBinding)this.resolveAnnotation(RemoteBinding.class);
            if (remoteBindingAnnotation != null) {
                homeHandle = new HomeHandleImpl(remoteBindingAnnotation.jndiBinding() + "Home");
            }
            return homeHandle.getEJBHome();
        }
        if (info.unadvisedMethod.getName().equals("getPrimaryKey")) {
            return null;
        }
        if (info.unadvisedMethod.getName().equals("isIdentical")) {
            return false;
        }
        return null;
    }

    private Object invokeLocalHomeMethod(MethodInfo info, Object[] args) throws Exception {
        if (info.unadvisedMethod.getName().equals("create")) {
            LocalBinding binding = (LocalBinding)this.resolveAnnotation(LocalBinding.class);
            StatelessLocalProxyFactory factory = new StatelessLocalProxyFactory();
            factory.setContainer(this);
            factory.init();
            Object proxy = factory.createProxy();
            return proxy;
        }
        return null;
    }

    protected Object invokeHomeMethod(MethodInfo info, MethodInvocation invocation) throws Throwable {
        if (info.unadvisedMethod.getName().equals("create")) {
            RemoteBinding binding = null;
            RemoteBindings bindings = (RemoteBindings)this.resolveAnnotation(RemoteBindings.class);
            binding = bindings != null ? bindings.value()[0] : (RemoteBinding)this.resolveAnnotation(RemoteBinding.class);
            StatelessRemoteProxyFactory factory = new StatelessRemoteProxyFactory();
            factory.setContainer(this);
            factory.setRemoteBinding(binding);
            factory.init();
            return factory.createProxy();
        }
        return null;
    }

    public Object getInvokedBusinessInterface(Object key) throws IllegalStateException {
        Method method = (Method)this.invokedMethod.get(this);
        if (method == null) {
            throw new IllegalStateException("No invocation");
        }
        return this.getInvokedInterface(method);
    }

    public Object getBusinessObject(Object key, Class businessInterface) throws IllegalStateException {
        Method method = (Method)this.invokedMethod.get(this);
        if (method == null) {
            throw new IllegalStateException("No invocation");
        }
        Object invokedInterface = this.getInvokedInterface(method);
        if (!invokedInterface.equals(businessInterface)) {
            throw new IllegalStateException("Business interface " + businessInterface + " was not invoked interface");
        }
        return invokedInterface;
    }
}

