/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.service;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.StandardMBean;
import org.jboss.ejb3.service.ServiceContainer;
import org.jboss.util.Classes;

public class ServiceMBeanDelegate
implements DynamicMBean {
    MBeanServer server;
    ServiceContainer container;
    ObjectName serviceOn;
    MBeanInfo mbeanInfo;
    HashMap<String, Method> getterMethods = new HashMap();
    HashSet<String> getterBlackList = new HashSet();
    HashMap<String, Method> setterMethods = new HashMap();
    HashSet<String> setterBlackList = new HashSet();
    HashMap<String, Method> operations = new HashMap();
    HashSet<String> operationBlackList = new HashSet();

    public ServiceMBeanDelegate(MBeanServer server, ServiceContainer container, Class intf, ObjectName on) {
        this.container = container;
        this.server = server;
        this.serviceOn = on;
        StandardMBean mbean = null;
        try {
            mbean = new StandardMBean(container.getSingleton(), intf);
        }
        catch (NotCompliantMBeanException e) {
            throw new RuntimeException(e);
        }
        this.mbeanInfo = mbean.getMBeanInfo();
    }

    public ObjectName getObjectName() {
        return this.serviceOn;
    }

    public void register(ObjectName on, Class intf) throws Exception {
        this.server.registerMBean(this, this.serviceOn);
    }

    public void unregister() throws Exception {
        this.server.unregisterMBean(this.serviceOn);
    }

    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        Method getter = this.getGetter(attribute);
        try {
            return this.container.localInvoke(getter, new Object[0]);
        }
        catch (Throwable t) {
            if (t instanceof Exception) {
                throw new MBeanException((Exception)t);
            }
            throw new RuntimeException(t);
        }
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        Method setter = this.getSetter(attribute);
        try {
            this.container.localInvoke(setter, new Object[]{attribute.getValue()});
        }
        catch (Throwable t) {
            if (t instanceof Exception) {
                throw new MBeanException((Exception)t);
            }
            throw new RuntimeException(t);
        }
    }

    public AttributeList getAttributes(String[] attributes) {
        AttributeList list = new AttributeList();
        for (int i = 0; i < attributes.length; ++i) {
            try {
                Object obj = this.getAttribute(attributes[i]);
                list.add(new Attribute(attributes[i], obj));
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException("Error reading attribute: " + attributes[i], e);
            }
        }
        return list;
    }

    public AttributeList setAttributes(AttributeList attributes) {
        for (Attribute attribute : attributes) {
            try {
                this.setAttribute(attribute);
            }
            catch (Exception e) {
                throw new RuntimeException("Error setting attribute: " + attribute, e);
            }
        }
        return attributes;
    }

    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        Method operation = this.getOperation(actionName, signature);
        try {
            return this.container.localInvoke(operation, params);
        }
        catch (Throwable t) {
            if (t instanceof Exception) {
                throw new MBeanException((Exception)t);
            }
            throw new RuntimeException(t);
        }
    }

    public MBeanInfo getMBeanInfo() {
        return this.mbeanInfo;
    }

    private String getOperationSignature(String actionName, String[] types) {
        StringBuffer sig = new StringBuffer();
        sig.append(actionName);
        if (types != null) {
            for (int i = 0; i < types.length; ++i) {
                sig.append(" ");
                sig.append(types[i]);
            }
        }
        return sig.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Method getGetter(String attribute) throws AttributeNotFoundException {
        Method getter = this.getterMethods.get(attribute);
        if (getter == null && !this.getterBlackList.contains(attribute)) {
            HashMap<String, Method> hashMap = this.getterMethods;
            synchronized (hashMap) {
                getter = this.getterMethods.get(attribute);
                if (getter == null) {
                    try {
                        MBeanAttributeInfo[] attrInfos = this.mbeanInfo.getAttributes();
                        for (int i = 0; i < attrInfos.length; ++i) {
                            MBeanAttributeInfo attrInfo = attrInfos[i];
                            if (!attrInfo.getName().equals(attribute)) continue;
                            if (!attrInfo.isReadable()) {
                                throw new AttributeNotFoundException("Attribute '" + attribute + "' is not writable in " + this.container.getBeanClass().getName());
                            }
                            String getterName = (attrInfo.isIs() ? "is" : "get") + attribute;
                            getter = this.container.getBeanClass().getMethod(getterName, new Class[0]);
                            this.getterMethods.put(attribute, getter);
                        }
                        if (getter == null) {
                            throw new AttributeNotFoundException("No attribute called '" + attribute + "' in " + this.container.getBeanClass());
                        }
                    }
                    catch (NoSuchMethodException e) {
                        throw new AttributeNotFoundException("Could not find getter for attribute '" + attribute + "' on " + this.container.getBeanClass().getName());
                    }
                    finally {
                        if (getter == null) {
                            this.getterBlackList.add(attribute);
                        }
                    }
                }
            }
        }
        return getter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Method getSetter(Attribute attribute) throws AttributeNotFoundException {
        String attrName = attribute.getName();
        Method setter = this.setterMethods.get(attrName);
        if (setter == null && !this.setterBlackList.contains(attrName)) {
            HashMap<String, Method> hashMap = this.setterMethods;
            synchronized (hashMap) {
                setter = this.setterMethods.get(attrName);
                if (setter == null) {
                    try {
                        MBeanAttributeInfo[] attrInfos = this.mbeanInfo.getAttributes();
                        for (int i = 0; i < attrInfos.length; ++i) {
                            MBeanAttributeInfo attrInfo = attrInfos[i];
                            if (!attrInfo.getName().equals(attrName)) continue;
                            if (!attrInfo.isWritable()) {
                                throw new AttributeNotFoundException("Attribute '" + attrName + "' is not readable in " + this.container.getBeanClass().getName());
                            }
                            String setterName = "set" + attrName;
                            Class type = Classes.loadClass(attrInfo.getType());
                            setter = this.container.getBeanClass().getMethod(setterName, type);
                            this.setterMethods.put(attrName, setter);
                        }
                        if (setter == null) {
                            throw new AttributeNotFoundException("No attribute called '" + attribute + "' in " + this.container.getBeanClass());
                        }
                    }
                    catch (ClassNotFoundException e) {
                        throw new AttributeNotFoundException("Could not load setter type for attribute '" + attrName + "' on " + this.container.getBeanClass().getName());
                    }
                    catch (NoSuchMethodException e) {
                        throw new AttributeNotFoundException("Could not find setter for attribute '" + attrName + "' on " + this.container.getBeanClass().getName());
                    }
                    finally {
                        if (setter == null) {
                            this.setterBlackList.add(attrName);
                        }
                    }
                }
            }
        }
        return setter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Method getOperation(String actionName, String[] signature) throws ReflectionException {
        String opSig = this.getOperationSignature(actionName, signature);
        Method operation = this.operations.get(actionName);
        if (operation == null && !this.setterBlackList.contains(opSig)) {
            HashMap<String, Method> hashMap = this.setterMethods;
            synchronized (hashMap) {
                operation = this.operations.get(opSig);
                if (operation == null) {
                    try {
                        MBeanOperationInfo[] opInfos = this.mbeanInfo.getOperations();
                        for (int i = 0; i < opInfos.length; ++i) {
                            MBeanOperationInfo op = opInfos[i];
                            if (!op.getName().equals(actionName)) continue;
                            boolean match = true;
                            MBeanParameterInfo[] sigTypes = op.getSignature();
                            if (sigTypes.length == signature.length) {
                                for (int j = 0; j < sigTypes.length; ++j) {
                                    if (sigTypes[j].getType().equals(signature[j])) continue;
                                    match = false;
                                    break;
                                }
                            }
                            if (!match) continue;
                            Class[] types = null;
                            if (signature.length > 0) {
                                types = new Class[signature.length];
                                for (int j = 0; j < signature.length; ++j) {
                                    types[j] = Classes.loadClass(signature[j]);
                                }
                            } else {
                                types = new Class[]{};
                            }
                            operation = this.container.getBeanClass().getMethod(actionName, types);
                            this.operations.put(opSig, operation);
                        }
                        if (operation == null) {
                            throw new RuntimeException("No operation called '" + actionName + "' in " + this.container.getBeanClass());
                        }
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException("Could not find  type for operation '" + actionName + "' on " + this.container.getBeanClass().getName());
                    }
                    catch (NoSuchMethodException e) {
                        throw new RuntimeException("Could not find method for operation '" + actionName + "' on " + this.container.getBeanClass().getName());
                    }
                    finally {
                        if (operation == null) {
                            this.operationBlackList.add(opSig);
                        }
                    }
                }
            }
        }
        return operation;
    }
}

