/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.service;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.aop.Advisor;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.ProxyFactory;
import org.jboss.naming.Util;

public abstract class BaseServiceProxyFactory
implements ProxyFactory {
    protected Class proxyClass;
    protected Constructor proxyConstructor;
    protected Context proxyFactoryContext;
    protected String jndiName;
    protected Container container;
    protected Advisor advisor;

    public void start() throws Exception {
        this.initializeJndiName();
        Class[] interfaces = this.getInterfaces();
        Class<?> proxyClass = Proxy.getProxyClass(this.container.getBeanClass().getClassLoader(), interfaces);
        Class[] constructorParams = new Class[]{InvocationHandler.class};
        this.proxyConstructor = proxyClass.getConstructor(constructorParams);
        try {
            Util.bind((Context)this.container.getInitialContext(), this.jndiName, this.createProxy());
        }
        catch (NamingException e) {
            NamingException namingException = new NamingException("Could not bind service proxy factory for EJB container with ejb name " + this.container.getEjbName() + " into JNDI under jndiName: " + this.container.getInitialContext().getNameInNamespace() + "/" + this.jndiName);
            namingException.setRootCause(e);
            throw namingException;
        }
    }

    public void stop() throws Exception {
        Util.unbind((Context)this.container.getInitialContext(), this.jndiName);
    }

    protected abstract Class[] getInterfaces();

    protected abstract void initializeJndiName();

    public void setContainer(Container container) {
        this.container = container;
        this.advisor = (Advisor)((Object)container);
    }
}

