/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.injection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.ejb.TransactionManagementType;
import org.jboss.aop.Advisor;
import org.jboss.ejb3.BeanContext;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.injection.Injector;
import org.jboss.ejb3.tx.TxUtil;
import org.jboss.ejb3.tx.UserTransactionImpl;

public class UserTransactionMethodInjector
implements Injector {
    private Method setMethod;

    public UserTransactionMethodInjector(Method setMethod, Container container) {
        TransactionManagementType type = TxUtil.getTransactionManagementType((Advisor)((Object)container));
        if (type != TransactionManagementType.BEAN) {
            throw new IllegalStateException("Container " + container.getEjbName() + ": it is illegal to inject UserTransaction into a CMT bean");
        }
        this.setMethod = setMethod;
    }

    public void inject(BeanContext ctx) {
        UserTransactionImpl ut = new UserTransactionImpl();
        Object[] args = new Object[]{ut};
        try {
            this.setMethod.invoke(ctx.getInstance(), args);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Failed in setting EntityManager on setter method: " + this.setMethod.toString());
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    public Class getInjectionClass() {
        return this.setMethod.getParameterTypes()[0];
    }
}

