/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.injection;

import java.lang.reflect.Field;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceException;
import org.jboss.ejb3.BeanContext;
import org.jboss.ejb3.injection.Injector;
import org.jboss.ejb3.injection.PojoInjector;
import org.jboss.logging.Logger;

public class JndiFieldInjector
implements Injector,
PojoInjector {
    private static final Logger log = Logger.getLogger(JndiFieldInjector.class);
    private Field field;
    private String jndiName;
    private Context ctx;

    public JndiFieldInjector(Field field, String jndiName, Context ctx) {
        this.field = field;
        this.field.setAccessible(true);
        this.jndiName = jndiName;
        this.ctx = ctx;
    }

    public JndiFieldInjector(Field field, Context ctx) {
        this(field, field.getName(), ctx);
    }

    public void inject(BeanContext bctx) {
        this.inject(bctx, bctx.getInstance());
    }

    public Class getInjectionClass() {
        return this.field.getType();
    }

    protected Object lookup(String jndiName, Class field) {
        Object dependency = null;
        try {
            dependency = this.ctx.lookup(jndiName);
            if (dependency instanceof Service && !field.isAssignableFrom(Service.class)) {
                Service service = (Service)dependency;
                dependency = service.getPort(field);
            }
        }
        catch (NamingException e) {
            e.printStackTrace();
            throw new RuntimeException("Unable to inject jndi dependency: " + jndiName + " into field " + field, e);
        }
        catch (ServiceException e) {
            e.printStackTrace();
            throw new RuntimeException("Unable to inject jndi webservice dependency: " + jndiName + " into field " + field, e);
        }
        return dependency;
    }

    public void inject(BeanContext bctx, Object instance) {
        Object dependency = this.lookup(this.jndiName, this.field.getType());
        try {
            this.field.set(instance, dependency);
        }
        catch (IllegalArgumentException e) {
            String type = "UNKNOWN";
            String interfaces = "";
            if (dependency != null) {
                Class<?>[] intfs;
                type = dependency.getClass().getName();
                for (Class<?> intf : intfs = dependency.getClass().getInterfaces()) {
                    interfaces = interfaces + ", " + intf.getName();
                }
            }
            throw new RuntimeException("Non matching type for inject of field: " + this.field + " for type: " + type + " of jndiName " + this.jndiName + "\nintfs: " + interfaces, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

