/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.cache.tree;

import javax.ejb.EJBException;
import javax.ejb.EJBNoSuchObjectException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.annotation.ejb.cache.tree.CacheConfig;
import org.jboss.aop.Advisor;
import org.jboss.cache.AbstractTreeCacheListener;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.TreeCache;
import org.jboss.cache.TreeCacheListener;
import org.jboss.cache.TreeCacheMBean;
import org.jboss.cache.config.Option;
import org.jboss.cache.eviction.Region;
import org.jboss.cache.eviction.RegionManager;
import org.jboss.cache.xml.XmlHelper;
import org.jboss.ejb3.BeanContext;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.Pool;
import org.jboss.ejb3.cache.ClusteredStatefulCache;
import org.jboss.ejb3.stateful.StatefulBeanContext;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.mx.util.MBeanServerLocator;
import org.w3c.dom.Element;

public class StatefulTreeCache
implements ClusteredStatefulCache {
    protected static Logger log = Logger.getLogger(StatefulTreeCache.class);
    static int FQN_SIZE = 2;
    private Pool pool;
    private TreeCache cache;
    private Fqn cacheNode;
    private ClusteredStatefulCacheListener listener;

    public StatefulBeanContext create() {
        StatefulBeanContext ctx = null;
        try {
            ctx = (StatefulBeanContext)this.pool.get();
            this.cache.put(this.cacheNode + "/" + ctx.getId(), (Object)"bean", (Object)ctx);
            ctx.inUse = true;
            ctx.lastUsed = System.currentTimeMillis();
        }
        catch (EJBException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
        return ctx;
    }

    public StatefulBeanContext create(Class[] initTypes, Object[] initValues) {
        StatefulBeanContext ctx = null;
        try {
            ctx = (StatefulBeanContext)this.pool.get(initTypes, initValues);
            this.cache.put(this.cacheNode + "/" + ctx.getId(), (Object)"bean", (Object)ctx);
            ctx.inUse = true;
            ctx.lastUsed = System.currentTimeMillis();
        }
        catch (EJBException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
        return ctx;
    }

    public StatefulBeanContext get(Object key) throws EJBException {
        StatefulBeanContext entry = null;
        try {
            Object obj = this.cache.get(this.cacheNode + "/" + key, (Object)"bean");
            entry = (StatefulBeanContext)obj;
        }
        catch (CacheException e) {
            throw new RuntimeException(e);
        }
        if (entry == null) {
            throw new EJBNoSuchObjectException("Could not find Stateful bean: " + key);
        }
        entry.inUse = true;
        entry.lastUsed = System.currentTimeMillis();
        return entry;
    }

    public void remove(Object key) {
        BeanContext ctx = null;
        try {
            this.cache.remove(this.cacheNode + "/" + key);
        }
        catch (CacheException e) {
            throw new RuntimeException(e);
        }
        if (ctx != null) {
            this.pool.remove(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished(StatefulBeanContext ctx) {
        StatefulBeanContext statefulBeanContext = ctx;
        synchronized (statefulBeanContext) {
            ctx.inUse = false;
            ctx.lastUsed = System.currentTimeMillis();
        }
    }

    public void replicate(StatefulBeanContext ctx) {
        try {
            this.cache.put(this.cacheNode + "/" + ctx.getId(), (Object)"bean", (Object)ctx);
        }
        catch (CacheException e) {
            throw new RuntimeException(e);
        }
    }

    public void initialize(Container container) throws Exception {
        Advisor advisor = (Advisor)((Object)container);
        this.pool = container.getPool();
        CacheConfig config = (CacheConfig)advisor.resolveAnnotation(CacheConfig.class);
        MBeanServer server = MBeanServerLocator.locateJBoss();
        ObjectName cacheON = new ObjectName(config.name());
        TreeCacheMBean mbean = (TreeCacheMBean)MBeanProxyExt.create(TreeCacheMBean.class, cacheON, server);
        this.cache = mbean.getInstance();
        this.cacheNode = Fqn.fromString((String)("/" + container.getEjbName() + "/"));
        RegionManager rm = this.cache.getEvictionRegionManager();
        Element element = this.getElementConfig(this.cacheNode.toString(), config.idleTimeoutSeconds(), config.maxSize());
        Region region = rm.createRegion(this.cacheNode, element);
        rm.getRegions();
        log.debug("initialize(): create eviction region: " + region + " for ejb: " + container.getEjbName());
    }

    protected Element getElementConfig(String regionName, long timeToLiveSeconds, int maxNodes) throws Exception {
        String xml = "<region name=\"" + regionName + "\" policyClass=\"org.jboss.cache.eviction.LRUPolicy\">\n" + "<attribute name=\"maxNodes\">" + maxNodes + "</attribute>\n" + "<attribute name=\"timeToLiveSeconds\">" + timeToLiveSeconds + "</attribute>\n" + "</region>";
        return XmlHelper.stringToElement((String)xml);
    }

    public void start() {
        this.listener = new ClusteredStatefulCacheListener();
        this.cache.addTreeCacheListener((TreeCacheListener)this.listener);
    }

    public void stop() {
        this.cache.removeTreeCacheListener((TreeCacheListener)this.listener);
        Option opt = new Option();
        opt.setCacheModeLocal(true);
        try {
            this.cache.remove(this.cacheNode, opt);
        }
        catch (CacheException e) {
            log.error("Stop(): can't remove bean from the underlying distributed cache");
        }
        RegionManager rm = this.cache.getEvictionRegionManager();
        rm.removeRegion(this.cacheNode);
        log.info("stop(): StatefulTreeCache stopped successfully for " + this.cacheNode);
    }

    public class ClusteredStatefulCacheListener
    extends AbstractTreeCacheListener {
        protected Logger log = Logger.getLogger(ClusteredStatefulCacheListener.class);

        public void nodeActivate(Fqn fqn, boolean pre) {
            if (pre) {
                return;
            }
            if (fqn.size() != FQN_SIZE) {
                return;
            }
            if (!fqn.isChildOrEquals(StatefulTreeCache.this.cacheNode)) {
                return;
            }
            StatefulBeanContext bean = null;
            try {
                bean = (StatefulBeanContext)StatefulTreeCache.this.cache.get(fqn, (Object)"bean");
            }
            catch (CacheException e) {
                this.log.error("nodeActivate(): can't retrieve bean instance from: " + fqn + " with exception: " + (Object)((Object)e));
                return;
            }
            if (bean == null) {
                throw new IllegalStateException("StatefuleTreeCache.nodeActivate(): null bean instance.");
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("nodeActivate(): send postActivate event on fqn: " + fqn);
            }
            bean.postActivate();
        }

        public void nodePassivate(Fqn fqn, boolean pre) {
            if (!pre) {
                return;
            }
            if (fqn.size() != FQN_SIZE) {
                return;
            }
            if (!fqn.isChildOrEquals(StatefulTreeCache.this.cacheNode)) {
                return;
            }
            try {
                Node node = StatefulTreeCache.this.cache.get(fqn);
                StatefulBeanContext bean = (StatefulBeanContext)node.getData().get("bean");
                if (bean != null) {
                    bean.prePassivate();
                }
            }
            catch (CacheException e) {
                this.log.error("nodePassivate(): can't retrieve bean instance from: " + fqn + " with exception: " + (Object)((Object)e));
                return;
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("nodePassivate(): send prePassivate event on fqn: " + fqn);
            }
        }
    }
}

