/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractConstructorMetaData;
import org.jboss.beans.metadata.plugins.AbstractDependencyMetaData;
import org.jboss.beans.metadata.plugins.AbstractValueMetaData;
import org.jboss.ejb3.DependencyPolicy;
import org.jboss.ejb3.KernelAbstraction;
import org.jboss.ejb3.MCDependencyPolicy;
import org.jboss.kernel.Kernel;
import org.jboss.logging.Logger;

public class MCKernelAbstraction
implements KernelAbstraction {
    private static final Logger log = Logger.getLogger(MCKernelAbstraction.class);
    private Kernel kernel;
    private MBeanServer server;

    public MCKernelAbstraction(Kernel kernel, MBeanServer server) {
        this.kernel = kernel;
        this.server = server;
    }

    public void setMbeanServer(MBeanServer server) {
        this.server = server;
    }

    public void install(String name, DependencyPolicy dependencies, Object service) {
        AbstractBeanMetaData bean = new AbstractBeanMetaData(name, service.getClass().getName());
        bean.setConstructor(new AlreadyInstantiated(service));
        MCDependencyPolicy policy = (MCDependencyPolicy)dependencies;
        bean.setDemands(policy.getDependencies());
        log.info("installing bean: " + name + " with dependencies:");
        for (AbstractDependencyMetaData obj : policy.getDependencies()) {
            log.info("\t" + obj);
        }
        try {
            this.kernel.getController().install(bean);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public void installMBean(ObjectName on, DependencyPolicy dependencies, Object service) {
        try {
            this.server.registerMBean(service, on);
            this.install(on.toString(), dependencies, service);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void uninstallMBean(ObjectName on) {
        try {
            this.server.unregisterMBean(on);
            this.kernel.getController().uninstall(on.toString());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void uninstall(String name) {
        try {
            this.kernel.getController().uninstall(name);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class AlreadyInstantiated
    extends AbstractConstructorMetaData {
        private Object bean;

        public AlreadyInstantiated(Object bean) {
            this.bean = bean;
            this.setFactory(new AbstractValueMetaData(new Factory()));
            this.setFactoryClass(Factory.class.getName());
            this.setFactoryMethod("create");
        }

        public class Factory {
            public Object create() {
                return AlreadyInstantiated.this.bean;
            }
        }
    }
}

