/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3;

import java.io.DataInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javassist.bytecode.ClassFile;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.persistence.Entity;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import org.hibernate.cfg.EJB3DTDEntityResolver;
import org.hibernate.ejb.packaging.PersistenceMetadata;
import org.hibernate.ejb.packaging.PersistenceXmlLoader;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.DependencyPolicy;
import org.jboss.ejb3.DeploymentUnit;
import org.jboss.ejb3.EAR;
import org.jboss.ejb3.EJB3Util;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.Ejb3Handler;
import org.jboss.ejb3.Ejb3HandlerFactory;
import org.jboss.ejb3.Ejb3Registry;
import org.jboss.ejb3.KernelAbstraction;
import org.jboss.ejb3.PersistenceUnitRegistry;
import org.jboss.ejb3.ProxyFactoryHelper;
import org.jboss.ejb3.entity.PersistenceUnitDeployment;
import org.jboss.logging.Logger;
import org.jboss.util.file.ArchiveBrowser;
import org.jboss.util.file.ClassFileFilter;
import org.xml.sax.EntityResolver;

public abstract class Ejb3Deployment {
    private static final Logger log = Logger.getLogger(Ejb3Deployment.class);
    public static final String ACTUAL_ENTITY_MANAGER_FACTORY_CONTEXT = "java:/ActualEntityManagerFactories";
    public static final String MANAGED_ENTITY_FACTORY_CONTEXT = "java:/managedEntityFactories";
    protected DeploymentUnit di;
    protected LinkedHashMap ejbContainers = new LinkedHashMap();
    protected boolean hasEntities;
    protected List<String> explicitEntityClasses = new ArrayList<String>();
    protected List<PersistenceUnitDeployment> persistenceUnitDeployments;
    protected String defaultSLSBDomain = "Stateless Bean";
    protected String defaultSFSBDomain = "Stateful Bean";
    protected String defaultMDBDomain = "Message Driven Bean";
    protected String defaultMessageInflowDrivenDomain = "Message Inflow Driven Bean";
    protected String defaultConsumerDomain = "Consumer Bean";
    protected String defaultServiceDomain = "Service Bean";
    protected InitialContext initialContext;
    protected String defaultClientBinding = "socket://0.0.0.0:3873";
    protected KernelAbstraction kernelAbstraction;
    protected MBeanServer mbeanServer;
    protected EAR ear;
    PolicyConfiguration pc;

    public Ejb3Deployment(DeploymentUnit di) {
        this.di = di;
        try {
            this.initialContext = EJB3Util.getInitialContext(di.getJndiProperties());
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    public EAR getEar() {
        return this.ear;
    }

    public KernelAbstraction getKernelAbstraction() {
        return this.kernelAbstraction;
    }

    public MBeanServer getMbeanServer() {
        return this.mbeanServer;
    }

    public void setMbeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    public DeploymentUnit getDeploymentUnit() {
        return this.di;
    }

    public String getDefaultSLSBDomain() {
        return this.defaultSLSBDomain;
    }

    public String getDefaultClientBinding() {
        return this.defaultClientBinding;
    }

    public String getScopeKernelName() {
        String scopedKernelName = "";
        if (this.ear != null) {
            scopedKernelName = scopedKernelName + ",ear=" + this.ear.getShortName();
        }
        scopedKernelName = scopedKernelName + ",jar=" + this.di.getShortName();
        return scopedKernelName;
    }

    public void setDefaultSLSBDomain(String defaultSLSBDomain) {
        this.defaultSLSBDomain = defaultSLSBDomain;
    }

    public String getDefaultSFSBDomain() {
        return this.defaultSFSBDomain;
    }

    public String getDefaultConsumerDomain() {
        return this.defaultConsumerDomain;
    }

    public void setDefaultSFSBDomain(String defaultSFSBDomain) {
        this.defaultSFSBDomain = defaultSFSBDomain;
    }

    public String getDefaultMDBDomain() {
        return this.defaultMDBDomain;
    }

    public String getDefaultMessageInflowDrivenBeanDomain() {
        return this.defaultMessageInflowDrivenDomain;
    }

    public void setDefaultMDBDomain(String defaultMDBDomain) {
        this.defaultMDBDomain = defaultMDBDomain;
    }

    public String getDefaultServiceDomain() {
        return this.defaultServiceDomain;
    }

    public void setDefaultServiceDomain(String defaultServiceDomain) {
        this.defaultServiceDomain = defaultServiceDomain;
    }

    protected String getJaccContextId() {
        return this.di.getShortName();
    }

    public Container getContainer(ObjectName name) {
        return (Container)this.ejbContainers.get(name);
    }

    public Map getEjbContainers() {
        return this.ejbContainers;
    }

    public PersistenceUnitDeployment getPersistenceUnitDeployment(String unitName) throws NameNotFoundException {
        if ("".equals(unitName)) {
            if (this.persistenceUnitDeployments == null) {
                throw new NameNotFoundException("EMPTY STRING unitName but there is no deployments in scope");
            }
            if (this.persistenceUnitDeployments.size() == 1 && this.ejbContainers.size() > 0) {
                return this.persistenceUnitDeployments.get(0);
            }
            if (this.persistenceUnitDeployments.size() > 1) {
                throw new NameNotFoundException("EMPTY STRING unitName and there is more than one scoped persistence unit");
            }
            throw new NameNotFoundException("There is no default persistence unit in this deployment.");
        }
        int hashIndex = unitName.indexOf(35);
        if (hashIndex != -1) {
            String relativePath = unitName.substring(0, hashIndex);
            String name = unitName.substring(hashIndex + 1);
            if (this.ear == null) {
                String relativeJarName = relativePath.substring(3);
                for (PersistenceUnitDeployment pud : PersistenceUnitRegistry.getPersistenceUnits()) {
                    String jarName = pud.getDeployment().getDeploymentUnit().getShortName() + ".jar";
                    if (pud.getDeployment().getEar() != null || !jarName.equals(relativeJarName) || !pud.getEntityManagerName().equals(name) || !pud.isScoped()) continue;
                    return pud;
                }
                return null;
            }
            Ejb3Deployment dep = this.ear.findRelativeDeployment(relativePath);
            if (dep == null) {
                return null;
            }
            PersistenceUnitDeployment rtn = dep.getPersistenceUnitDeploymentInternal(name);
            return rtn;
        }
        PersistenceUnitDeployment rtn = this.getPersistenceUnitDeploymentInternal(unitName);
        if (rtn != null) {
            return rtn;
        }
        for (PersistenceUnitDeployment deployment : PersistenceUnitRegistry.getPersistenceUnits()) {
            if (deployment.isScoped() || !deployment.getEntityManagerName().equals(unitName)) continue;
            return deployment;
        }
        return rtn;
    }

    protected PersistenceUnitDeployment getPersistenceUnitDeploymentInternal(String unitName) {
        if (this.persistenceUnitDeployments != null) {
            for (PersistenceUnitDeployment deployment : this.persistenceUnitDeployments) {
                if (!deployment.getEntityManagerName().equals(unitName)) continue;
                return deployment;
            }
        }
        return null;
    }

    public EJBContainer getEjbContainer(String ejbLink, Class businessIntf) {
        EJBContainer container;
        int hashIndex = ejbLink.indexOf(35);
        if (hashIndex != -1) {
            if (this.ear == null) {
                return null;
            }
            String relativePath = ejbLink.substring(0, hashIndex);
            Ejb3Deployment dep = this.ear.findRelativeDeployment(relativePath);
            if (dep == null) {
                return null;
            }
            String ejbName = ejbLink.substring(hashIndex);
            return dep.getEjbContainer(ejbName, businessIntf);
        }
        for (Object obj : this.ejbContainers.values()) {
            container = (EJBContainer)obj;
            if (!container.getEjbName().equals(ejbLink)) continue;
            return container;
        }
        for (Object obj : Ejb3Registry.getContainers()) {
            container = (EJBContainer)obj;
            if (!container.getEjbName().equals(ejbLink)) continue;
            return container;
        }
        return null;
    }

    public String getEjbJndiName(String ejbLink, Class businessIntf) {
        EJBContainer container = this.getEjbContainer(ejbLink, businessIntf);
        if (container == null) {
            return null;
        }
        return ProxyFactoryHelper.getJndiName(container, businessIntf);
    }

    public EJBContainer getEjbContainer(Ejb3Deployment deployment, Class businessIntf) throws NameNotFoundException {
        EJBContainer container = null;
        for (Object obj : deployment.ejbContainers.values()) {
            EJBContainer newContainer = (EJBContainer)obj;
            if (container == newContainer || !ProxyFactoryHelper.publishesInterface(newContainer, businessIntf)) continue;
            if (container != null) {
                throw new NameNotFoundException("duplicated in " + this.di.getShortName());
            }
            container = newContainer;
        }
        return container;
    }

    public EJBContainer getEjbContainer(Class businessIntf) throws NameNotFoundException {
        EJBContainer rtnContainer = null;
        rtnContainer = this.getEjbContainer(this, businessIntf);
        if (rtnContainer != null) {
            return rtnContainer;
        }
        String jarName = null;
        if (this.ear != null) {
            for (Ejb3Deployment deployment : this.ear.getEjbDeployments()) {
                EJBContainer newContainer = this.getEjbContainer(deployment, businessIntf);
                if (rtnContainer == newContainer) continue;
                if (rtnContainer != null && newContainer != null) {
                    throw new NameNotFoundException("duplicated in .ear within " + jarName + " and " + deployment.getDeploymentUnit().getShortName());
                }
                if (newContainer == null) continue;
                rtnContainer = newContainer;
                jarName = deployment.getDeploymentUnit().getShortName();
            }
        }
        if (rtnContainer != null) {
            return rtnContainer;
        }
        for (Container container : Ejb3Registry.getContainers()) {
            EJBContainer ejbContainer = (EJBContainer)container;
            if (ejbContainer == rtnContainer || !ProxyFactoryHelper.publishesInterface(container, businessIntf)) continue;
            if (rtnContainer != null) {
                throw new NameNotFoundException("duplicated in " + ejbContainer.getDeployment().getDeploymentUnit().getShortName() + " and " + jarName);
            }
            rtnContainer = ejbContainer;
            jarName = ejbContainer.getDeployment().getDeploymentUnit().getShortName();
        }
        if (rtnContainer != null) {
            return rtnContainer;
        }
        throw new NameNotFoundException("not used by any EJBs");
    }

    public String getEjbJndiName(Class businessIntf) throws NameNotFoundException {
        EJBContainer container = this.getEjbContainer(businessIntf);
        String jndiName = ProxyFactoryHelper.getJndiName(container, businessIntf);
        if (jndiName == null) {
            throw new NameNotFoundException("not used by any EJBs");
        }
        return jndiName;
    }

    protected void processEJBContainerMetadata(Container container) throws Exception {
        ObjectName on = container.getObjectName();
        this.ejbContainers.put(on, container);
        DependencyPolicy policy = this.createDependencyPolicy();
        container.processMetadata(policy);
    }

    protected void registerEJBContainer(Container container) throws Exception {
        ObjectName on = container.getObjectName();
        this.kernelAbstraction.install(on.getCanonicalName(), container.getDependencyPolicy(), container);
        log.debug("Bound ejb3 container " + on);
    }

    protected abstract PolicyConfiguration createPolicyConfiguration() throws Exception;

    protected abstract void putJaccInService(PolicyConfiguration var1, DeploymentUnit var2);

    public void create() throws Exception {
        long start = System.currentTimeMillis();
        this.pc = this.createPolicyConfiguration();
        this.deploy();
        this.initializePersistenceUnits();
        log.info("EJB3 deployment time took: " + (System.currentTimeMillis() - start));
    }

    public void start() throws Exception {
        try {
            Container con;
            this.startPersistenceUnits();
            for (Object o : this.ejbContainers.values()) {
                con = (Container)o;
                this.processEJBContainerMetadata(con);
            }
            for (Object o : this.ejbContainers.values()) {
                con = (Container)o;
                this.registerEJBContainer(con);
            }
            this.putJaccInService(this.pc, this.di);
        }
        catch (Exception ex) {
            try {
                this.stop();
                this.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ex;
        }
    }

    protected void deploy() throws Exception {
        Ejb3HandlerFactory factory = Ejb3HandlerFactory.getInstance(this);
        if (this.di.getUrl() != null) {
            this.deployUrl(factory);
        }
        if (this.di.getClasses() != null) {
            for (Class explicit : this.di.getClasses()) {
                if (explicit.isAnnotationPresent(Entity.class)) continue;
                String name = explicit.getName().replace('.', '/') + ".class";
                InputStream stream = explicit.getClassLoader().getResourceAsStream(name);
                this.deployElement(stream, factory, this.initialContext);
            }
        }
    }

    protected void deployUrl(Ejb3HandlerFactory factory) throws Exception {
        Iterator it = ArchiveBrowser.getBrowser(this.di.getUrl(), new ClassFileFilter());
        InitialContext ctx = this.initialContext;
        while (it.hasNext()) {
            InputStream stream = (InputStream)it.next();
            this.deployElement(stream, factory, ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deployElement(InputStream stream, Ejb3HandlerFactory factory, InitialContext ctx) throws Exception {
        DataInputStream dstream = new DataInputStream(stream);
        ClassFile cf = null;
        try {
            cf = new ClassFile(dstream);
        }
        finally {
            dstream.close();
            stream.close();
        }
        this.deployElement(factory, cf, ctx);
    }

    protected void deployElement(Ejb3HandlerFactory factory, ClassFile cf, InitialContext ctx) throws Exception {
        Ejb3Handler handler = factory.createHandler(cf);
        handler.setCtxProperties(this.di.getJndiProperties());
        if (handler.isEjb() || handler.isJBossBeanType()) {
            List<Container> containers = handler.getContainers(cf, this);
            for (Container con : containers) {
                ((EJBContainer)con).instantiated();
                this.ejbContainers.put(con.getObjectName(), con);
                Ejb3Registry.register(con);
            }
        }
    }

    protected void initializePersistenceUnits() throws Exception {
        URL persistenceXmlUrl = null;
        persistenceXmlUrl = this.di.getPersistenceXml();
        boolean bl = this.hasEntities = persistenceXmlUrl != null;
        if (!this.hasEntities) {
            return;
        }
        if (this.di.getClasses() != null) {
            for (Class explicit : this.di.getClasses()) {
                if (!explicit.isAnnotationPresent(Entity.class)) continue;
                this.explicitEntityClasses.add(explicit.getName());
            }
        }
        List persistenceMetadata = PersistenceXmlLoader.deploy((URL)persistenceXmlUrl, new HashMap(), (EntityResolver)new EJB3DTDEntityResolver());
        this.persistenceUnitDeployments = new ArrayList<PersistenceUnitDeployment>();
        for (PersistenceMetadata metadata : persistenceMetadata) {
            String earShortName = this.ear == null ? null : this.ear.getShortName();
            boolean isScoped = this.ejbContainers.size() > 0;
            PersistenceUnitDeployment deployment = new PersistenceUnitDeployment(this.initialContext, this, this.explicitEntityClasses, persistenceXmlUrl, metadata, earShortName, this.di.getShortName(), isScoped);
            PersistenceUnitRegistry.register(deployment);
            this.persistenceUnitDeployments.add(deployment);
        }
    }

    public abstract DependencyPolicy createDependencyPolicy();

    protected void startPersistenceUnits() {
        if (this.persistenceUnitDeployments == null) {
            return;
        }
        for (PersistenceUnitDeployment entityDeployment : this.persistenceUnitDeployments) {
            if (entityDeployment == null) continue;
            DependencyPolicy policy = this.createDependencyPolicy();
            entityDeployment.addDependencies(policy);
            this.kernelAbstraction.install(entityDeployment.getKernelName(), policy, entityDeployment);
        }
    }

    protected void stopPersistenceUnits() {
        if (this.persistenceUnitDeployments == null) {
            return;
        }
        for (PersistenceUnitDeployment entityDeployment : this.persistenceUnitDeployments) {
            try {
                PersistenceUnitRegistry.unregister(entityDeployment);
                if (entityDeployment == null) continue;
                this.kernelAbstraction.uninstall(entityDeployment.getKernelName());
            }
            catch (Exception e) {
                log.debug("error trying to shut down persistence unit", e);
            }
        }
    }

    public void stop() throws Exception {
        for (Object o : this.ejbContainers.keySet()) {
            try {
                ObjectName on = (ObjectName)o;
                this.kernelAbstraction.uninstall(on.getCanonicalName());
                Container container = (Container)this.ejbContainers.get(on);
                Ejb3Registry.unregister(container);
            }
            catch (Exception e) {
                log.debug("error trying to shut down ejb container", e);
            }
        }
        this.stopPersistenceUnits();
    }

    public void destroy() throws Exception {
        PolicyConfigurationFactory pcFactory = PolicyConfigurationFactory.getPolicyConfigurationFactory();
        PolicyConfiguration pc = pcFactory.getPolicyConfiguration(this.getJaccContextId(), true);
        pc.delete();
    }
}

