/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.txtimer;

import javax.ejb.Timer;
import org.jboss.ejb.txtimer.FixedDelayRetryPolicyMBean;
import org.jboss.ejb.txtimer.TimedObjectInvoker;
import org.jboss.ejb.txtimer.TimerImpl;
import org.jboss.logging.Logger;
import org.jboss.system.ServiceMBeanSupport;

public class FixedDelayRetryPolicy
extends ServiceMBeanSupport
implements FixedDelayRetryPolicyMBean {
    private static Logger log = Logger.getLogger(FixedDelayRetryPolicy.class);
    private long delay = 100L;

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public void retryTimeout(TimedObjectInvoker invoker, Timer timer) {
        TimerImpl txTimer;
        long periode;
        if (timer instanceof TimerImpl && 0L < (periode = (txTimer = (TimerImpl)timer).getPeriode()) && periode / 2L < this.delay) {
            log.warn("A delay of " + this.delay + " ms might not be appropriate for a timer periode of " + periode + " ms");
        }
        new RetryThread(invoker, timer).start();
    }

    private class RetryThread
    extends Thread {
        private TimedObjectInvoker invoker;
        private Timer timer;

        public RetryThread(TimedObjectInvoker invoker, Timer timer) {
            this.invoker = invoker;
            this.timer = timer;
        }

        public void run() {
            try {
                Thread.sleep(FixedDelayRetryPolicy.this.delay);
                log.debug("Retry ejbTimeout: " + this.timer);
                this.invoker.callTimeout(this.timer);
            }
            catch (Exception ignore) {
                ignore.printStackTrace();
            }
        }
    }
}

