/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc2.bridge;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.ejb.EJBException;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.EntityEnterpriseContext;
import org.jboss.ejb.plugins.cmp.bridge.CMPFieldBridge;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCEntityPersistenceStore;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCResultSetReader;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCType;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCFieldBridge;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCCMPFieldMetaData;
import org.jboss.ejb.plugins.cmp.jdbc2.JDBCStoreManager2;
import org.jboss.ejb.plugins.cmp.jdbc2.PersistentContext;
import org.jboss.ejb.plugins.cmp.jdbc2.bridge.JDBCEntityBridge2;
import org.jboss.logging.Logger;

public class JDBCCMPFieldBridge2
implements CMPFieldBridge,
JDBCFieldBridge {
    private final JDBCEntityBridge2 entity;
    private final int rowIndex;
    private final JDBCType jdbcType;
    private final Class pkClass;
    private final Field pkField;
    private final boolean isPrimaryKeyMember;
    private final String fieldName;
    private final Class fieldType;
    private final String columnName;
    private final JDBCCMPFieldBridge2 cmpFieldIAmMappedTo;
    private final Logger log;
    private int versionIndex = -1;

    public JDBCCMPFieldBridge2(JDBCStoreManager2 manager, JDBCEntityBridge2 entity, JDBCCMPFieldMetaData metadata, int rowIndex) throws DeploymentException {
        this.rowIndex = rowIndex;
        this.entity = entity;
        this.jdbcType = manager.getJDBCTypeFactory().getJDBCType(metadata);
        this.pkClass = metadata.getEntity().getPrimaryKeyClass();
        this.pkField = metadata.getPrimaryKeyField();
        this.isPrimaryKeyMember = metadata.isPrimaryKeyMember();
        this.fieldName = metadata.getFieldName();
        this.fieldType = metadata.getFieldType();
        this.cmpFieldIAmMappedTo = null;
        this.columnName = metadata.getColumnName();
        this.log = Logger.getLogger(this.getClass().getName() + "." + entity.getEntityName() + "#" + this.getFieldName());
    }

    public JDBCCMPFieldBridge2(JDBCCMPFieldBridge2 cmpField, JDBCCMPFieldBridge2 relatedPKField) {
        this.entity = cmpField.entity;
        this.rowIndex = cmpField.rowIndex;
        this.jdbcType = cmpField.jdbcType;
        this.columnName = cmpField.columnName;
        this.fieldName = relatedPKField.fieldName;
        this.fieldType = relatedPKField.fieldType;
        this.pkClass = relatedPKField.pkClass;
        this.pkField = relatedPKField.pkField;
        this.isPrimaryKeyMember = false;
        this.cmpFieldIAmMappedTo = cmpField;
        this.log = Logger.getLogger(this.getClass().getName() + "." + this.entity.getEntityName() + "#" + this.getFieldName());
    }

    public void initVersion() {
        this.versionIndex = this.entity.getTable().addVersionField();
    }

    public int getVersionIndex() {
        return this.versionIndex;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public Object setPrimaryKeyValue(Object primaryKey, Object value) throws IllegalArgumentException {
        try {
            if (this.pkField != null) {
                if (value == null && primaryKey == null) {
                    return null;
                }
                if (primaryKey == null) {
                    primaryKey = this.pkClass.newInstance();
                }
                this.pkField.set(primaryKey, value);
                return primaryKey;
            }
            return value;
        }
        catch (Exception e) {
            throw new EJBException("Internal error setting instance field " + this.getFieldName(), e);
        }
    }

    public void setValueInternal(EntityEnterpriseContext ctx, Object value, boolean makeDirty) {
        PersistentContext pctx = (PersistentContext)ctx.getPersistenceContext();
        if (this.cmpFieldIAmMappedTo != null && this.cmpFieldIAmMappedTo.isPrimaryKeyMember) {
            Object curValue = pctx.getFieldValue(this.rowIndex);
            if (value != null && !value.equals(curValue)) {
                throw new IllegalStateException("Attempt to modify a primary key field through a foreign key field mapped to it: " + this.entity.getEntityName() + "." + this.cmpFieldIAmMappedTo.getFieldName() + " -> " + this.entity.getQualifiedTableName() + "." + this.cmpFieldIAmMappedTo.getColumnName() + ", current value=" + curValue + ", new value=" + value);
            }
            makeDirty = false;
        } else {
            pctx.setFieldValue(this.rowIndex, value);
        }
        if (makeDirty) {
            pctx.setDirty();
        }
    }

    public int setArgumentParameters(PreparedStatement ps, int parameterIndex, Object arg) {
        try {
            int[] jdbcTypes = this.jdbcType.getJDBCTypes();
            for (int i = 0; i < jdbcTypes.length; ++i) {
                Object columnValue = this.jdbcType.getColumnValue(i, arg);
                this.jdbcType.getParameterSetter()[i].set(ps, parameterIndex++, jdbcTypes[i], columnValue, this.log);
            }
            return parameterIndex;
        }
        catch (SQLException e) {
            throw new EJBException("Internal error setting parameters for field " + this.getFieldName(), e);
        }
    }

    public Object loadArgumentResults(ResultSet rs, int parameterIndex) throws IllegalArgumentException {
        try {
            Class[] javaTypes = this.jdbcType.getJavaTypes();
            if (javaTypes.length > 1) {
                throw new IllegalStateException("Complex types are not supported yet.");
            }
            JDBCResultSetReader[] rsReaders = this.jdbcType.getResultSetReaders();
            Object columnValue = null;
            for (int i = 0; i < javaTypes.length; ++i) {
                columnValue = rsReaders[i].get(rs, parameterIndex++, javaTypes[i], this.log);
                columnValue = this.jdbcType.setColumnValue(i, null, columnValue);
            }
            return columnValue;
        }
        catch (SQLException e) {
            throw new EJBException("Internal error getting results for field member " + this.getFieldName(), e);
        }
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public JDBCEntityPersistenceStore getManager() {
        return this.entity.getManager();
    }

    public void initInstance(EntityEnterpriseContext ctx) {
        Class fieldType = this.getFieldType();
        Serializable value = fieldType == Boolean.TYPE ? Boolean.FALSE : (fieldType == Byte.TYPE ? new Byte(0) : (fieldType == Integer.TYPE ? new Integer(0) : (fieldType == Long.TYPE ? new Long(0L) : (fieldType == Short.TYPE ? new Short(0) : (fieldType == Character.TYPE ? (Serializable)new Character('\u0000') : (Serializable)(fieldType == Double.TYPE ? (Number)new Double(0.0) : (Number)(fieldType == Float.TYPE ? new Float(0.0f) : null)))))));
        this.setValueInternal(ctx, value, false);
    }

    public void resetPersistenceContext(EntityEnterpriseContext ctx) {
        throw new UnsupportedOperationException();
    }

    public int setInstanceParameters(PreparedStatement ps, int parameterIndex, EntityEnterpriseContext ctx) {
        throw new UnsupportedOperationException();
    }

    public Object getInstanceValue(EntityEnterpriseContext ctx) {
        throw new UnsupportedOperationException();
    }

    public void setInstanceValue(EntityEnterpriseContext ctx, Object value) {
        throw new UnsupportedOperationException();
    }

    public int loadInstanceResults(ResultSet rs, int parameterIndex, EntityEnterpriseContext ctx) {
        throw new UnsupportedOperationException();
    }

    public int loadArgumentResults(ResultSet rs, int parameterIndex, Object[] argumentRef) {
        throw new UnsupportedOperationException();
    }

    public boolean isDirty(EntityEnterpriseContext ctx) {
        throw new UnsupportedOperationException();
    }

    public void setClean(EntityEnterpriseContext ctx) {
        throw new UnsupportedOperationException();
    }

    public boolean isCMPField() {
        return true;
    }

    public boolean isPrimaryKeyMember() {
        return this.isPrimaryKeyMember;
    }

    public boolean isReadOnly() {
        throw new UnsupportedOperationException();
    }

    public boolean isReadTimedOut(EntityEnterpriseContext ctx) {
        throw new UnsupportedOperationException();
    }

    public boolean isLoaded(EntityEnterpriseContext ctx) {
        throw new UnsupportedOperationException();
    }

    public JDBCType getJDBCType() {
        return this.jdbcType;
    }

    public Object getPrimaryKeyValue(Object primaryKey) throws IllegalArgumentException {
        try {
            if (this.pkField != null) {
                if (primaryKey == null) {
                    return null;
                }
                return this.pkField.get(primaryKey);
            }
            return primaryKey;
        }
        catch (Exception e) {
            throw new EJBException("Internal error getting primary key field member " + this.getFieldName(), e);
        }
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Object getValue(EntityEnterpriseContext ctx) {
        PersistentContext pctx = (PersistentContext)ctx.getPersistenceContext();
        return pctx.getFieldValue(this.rowIndex);
    }

    public void setValue(EntityEnterpriseContext ctx, Object value) {
        this.setValueInternal(ctx, value, true);
    }

    public Class getFieldType() {
        return this.fieldType;
    }
}

