/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc.keygen;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.ejb.CreateException;
import javax.sql.DataSource;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.EntityEnterpriseContext;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCInsertPKCreateCommand;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCStoreManager;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCUtil;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMPFieldBridge;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityCommandMetaData;

public class JDBCPkSqlCreateCommand
extends JDBCInsertPKCreateCommand {
    protected String pkSQL;
    protected JDBCCMPFieldBridge pkField;

    public void init(JDBCStoreManager manager) throws DeploymentException {
        super.init(manager);
        this.pkField = this.getGeneratedPKField();
    }

    protected void initEntityCommand(JDBCEntityCommandMetaData entityCommand) throws DeploymentException {
        super.initEntityCommand(entityCommand);
        this.pkSQL = entityCommand.getAttribute("pk-sql");
        if (this.pkSQL == null) {
            throw new DeploymentException("pk-sql attribute must be set for entity " + this.entity.getEntityName());
        }
        if (this.debug) {
            this.log.debug("Generate PK sql is: " + this.pkSQL);
        }
    }

    protected void generateFields(EntityEnterpriseContext ctx) throws CreateException {
        super.generateFields(ctx);
        Connection con = null;
        Statement s = null;
        ResultSet rs = null;
        try {
            DataSource dataSource;
            if (this.debug) {
                this.log.debug("Executing SQL: " + this.pkSQL);
            }
            if (!(rs = (s = (con = (dataSource = this.entity.getDataSource()).getConnection()).createStatement()).executeQuery(this.pkSQL)).next()) {
                throw new CreateException("Error fetching next primary key value: result set contains no rows");
            }
            this.pkField.loadInstanceResults(rs, 1, ctx);
        }
        catch (SQLException e) {
            try {
                this.log.error("Error fetching the next primary key value", e);
                throw new CreateException("Error fetching the next primary key value:" + e);
            }
            catch (Throwable throwable) {
                JDBCUtil.safeClose(rs);
                JDBCUtil.safeClose(s);
                JDBCUtil.safeClose(con);
                throw throwable;
            }
        }
        JDBCUtil.safeClose(rs);
        JDBCUtil.safeClose(s);
        JDBCUtil.safeClose(con);
    }
}

