/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.proxy.container;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Comparator;
import org.jboss.aop.proxy.container.AOPProxyFactoryMixin;
import org.jboss.aop.proxy.container.ContainerCacheUtil;
import org.jboss.repository.spi.MetaDataContext;

public class ContainerProxyCacheKey
implements Serializable {
    private static final long serialVersionUID = 8758283842273747310L;
    private static final WeakReference[] EMTPY_WR_ARRAY = new WeakReference[0];
    private static final AOPProxyFactoryMixin[] EMPTY_MIXIN_ARRAY = new AOPProxyFactoryMixin[0];
    private WeakReference clazzRef;
    private WeakReference[] addedInterfaces = EMTPY_WR_ARRAY;
    private MetaDataContext metaDataContext;
    private AOPProxyFactoryMixin[] addedMixins = EMPTY_MIXIN_ARRAY;
    private int hashcode = 0;
    private MetaDataContext ctx;

    public ContainerProxyCacheKey(Class clazz) {
        this.clazzRef = new WeakReference<Class>(clazz);
    }

    public ContainerProxyCacheKey(Class clazz, Class[] addedInterfaces, MetaDataContext metaDataContext) {
        this(clazz);
        this.addedInterfaces = ContainerCacheUtil.getSortedWeakReferenceForInterfaces(addedInterfaces);
        this.metaDataContext = metaDataContext;
    }

    public ContainerProxyCacheKey(Class clazz, Class[] addedInterfaces, AOPProxyFactoryMixin[] addedMixins, MetaDataContext metaDataContext) {
        this(clazz, addedInterfaces, metaDataContext);
        if (addedMixins != null) {
            this.addedMixins = addedMixins;
            Arrays.sort(this.addedMixins, MixinAlphabetical.singleton);
        }
    }

    public Class getClazz() {
        Class clazz = (Class)this.clazzRef.get();
        if (clazz != null) {
            return clazz;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj.getClass() != ContainerProxyCacheKey.class) {
            return false;
        }
        ContainerProxyCacheKey other = (ContainerProxyCacheKey)obj;
        if (!this.compareMetadataContext(other)) {
            return false;
        }
        if (!this.compareClass(other)) {
            return false;
        }
        if (!this.compareAddedInterfaces(other)) {
            return false;
        }
        return this.compareAddedMixins(other);
    }

    public int hashCode() {
        if (this.hashcode == 0) {
            Class clazz = (Class)this.clazzRef.get();
            StringBuffer sb = new StringBuffer();
            if (clazz != null) {
                sb.append(clazz.getName());
            }
            if (this.addedInterfaces != null) {
                for (int i = 0; i < this.addedInterfaces.length; ++i) {
                    sb.append(";");
                    sb.append(((Class)this.addedInterfaces[i].get()).getName());
                }
            }
            this.hashcode = sb.toString().hashCode();
            if (this.metaDataContext != null) {
                this.hashcode += this.metaDataContext.hashCode();
            }
        }
        return this.hashcode;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("ContainerProxyCache");
        buf.append(((Class)this.clazzRef.get()).getName());
        buf.append(";interfaces=");
        if (this.addedInterfaces == null) {
            buf.append("null");
        } else {
            buf.append(Arrays.asList(this.addedInterfaces));
        }
        buf.append(";mixins=");
        if (this.addedMixins == null) {
            buf.append("null");
        } else {
            buf.append(Arrays.asList(this.addedMixins));
        }
        return buf.toString();
    }

    private boolean compareMetadataContext(ContainerProxyCacheKey other) {
        if (this.metaDataContext != null || other.metaDataContext != null) {
            if (this.metaDataContext != null && other.metaDataContext != null) {
                if (!this.metaDataContext.equals(other.metaDataContext)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private boolean compareClass(ContainerProxyCacheKey other) {
        return ContainerCacheUtil.compareClassRefs(this.clazzRef, other.clazzRef);
    }

    private boolean compareAddedInterfaces(ContainerProxyCacheKey other) {
        return ContainerCacheUtil.compareInterfaceRefs(this.addedInterfaces, other.addedInterfaces);
    }

    private boolean compareAddedMixins(ContainerProxyCacheKey other) {
        if (this.addedMixins == null && other.addedMixins != null || this.addedMixins == null && other.addedMixins != null) {
            return false;
        }
        if (this.addedMixins != null && other.addedMixins != null) {
            if (this.addedMixins.length != other.addedMixins.length) {
                return false;
            }
            for (int i = 0; i < this.addedMixins.length; ++i) {
                if (this.addedMixins[i].equals(other.addedMixins[i])) continue;
                return false;
            }
        }
        return true;
    }

    static class MixinAlphabetical
    implements Comparator {
        static MixinAlphabetical singleton = new MixinAlphabetical();

        MixinAlphabetical() {
        }

        public int compare(Object o1, Object o2) {
            String name1 = ((AOPProxyFactoryMixin)o1).getMixin().getName();
            String name2 = ((AOPProxyFactoryMixin)o2).getMixin().getName();
            return name1.compareTo(name2);
        }
    }
}

