/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.deployment;

import java.io.File;
import java.io.FileOutputStream;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import org.jboss.aop.AOPClassPool;
import org.jboss.aop.AspectManager;
import org.jboss.mx.loading.RepositoryClassLoader;

public class JBossClassPool
extends AOPClassPool {
    protected File tempdir = null;
    protected final Object tmplock = new Object();

    protected JBossClassPool(ClassLoader cl, ClassPool src, AspectManager manager, File tmp) {
        super(cl, src, manager);
        this.tempdir = tmp;
    }

    protected JBossClassPool(ClassPool src, AspectManager manager) {
        super(src, manager);
    }

    public boolean isUnloadedClassLoader() {
        if (this.getClassLoader() instanceof RepositoryClassLoader) {
            RepositoryClassLoader rcl = (RepositoryClassLoader)this.getClassLoader();
            return rcl.getLoaderRepository() == null;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class toClass(CtClass cc, ClassLoader loader) throws CannotCompileException {
        this.lockInCache(cc);
        if (this.getClassLoader() == null || this.tempdir == null) {
            return super.toClass(cc);
        }
        Class<?> dynClass = null;
        try {
            File classFile = null;
            String classFileName = this.getResuorceName(cc.getName());
            Object object = this.tmplock;
            synchronized (object) {
                classFile = new File(this.tempdir, classFileName);
                File pkgDirs = classFile.getParentFile();
                pkgDirs.mkdirs();
                FileOutputStream stream = new FileOutputStream(classFile);
                stream.write(cc.toBytecode());
                stream.flush();
                stream.close();
                classFile.deleteOnExit();
            }
            RepositoryClassLoader rcl = (RepositoryClassLoader)this.getClassLoader();
            rcl.clearClassBlackList();
            rcl.clearResourceBlackList();
            dynClass = this.getClassLoader().loadClass(cc.getName());
        }
        catch (Exception ex) {
            ClassFormatError cfe = new ClassFormatError("Failed to load dyn class: " + cc.getName());
            cfe.initCause(ex);
            throw cfe;
        }
        return dynClass;
    }

    protected boolean isLocalResource(String resourceName) {
        if (super.isLocalResource(resourceName)) {
            return true;
        }
        File file = new File(this.tempdir, resourceName);
        return file.exists();
    }
}

