/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice;

import org.jboss.aop.Advisor;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.advice.InterceptorFactory;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.util.xml.XmlLoadable;
import org.w3c.dom.Element;

public class GenericInterceptorFactory
implements InterceptorFactory {
    private Class clazz = null;
    private String classname;
    private Element element;
    private boolean deployed = true;
    private String name;
    private static volatile int counter = 0;

    public GenericInterceptorFactory(String classname, Element element) {
        this.name = classname + counter++;
        this.classname = classname;
        this.element = element;
    }

    public GenericInterceptorFactory(Class clazz) {
        this.clazz = clazz;
        this.classname = clazz.getName();
    }

    public String getName() {
        return this.name;
    }

    public AspectDefinition getAspect() {
        return null;
    }

    public String getAdvice() {
        return "invoke";
    }

    public void undeploy() {
        this.deployed = false;
    }

    public boolean isDeployed() {
        return this.deployed;
    }

    public String getClassName() {
        return this.classname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Interceptor create(Advisor advisor, Joinpoint joinpoint) {
        try {
            GenericInterceptorFactory genericInterceptorFactory = this;
            synchronized (genericInterceptorFactory) {
                if (this.clazz == null) {
                    this.clazz = Thread.currentThread().getContextClassLoader().loadClass(this.classname);
                }
            }
            Interceptor interceptor = (Interceptor)this.clazz.newInstance();
            if (interceptor instanceof XmlLoadable && this.element != null) {
                ((XmlLoadable)((Object)interceptor)).importXml(this.element);
            }
            return interceptor;
        }
        catch (Exception re) {
            if (re instanceof RuntimeException) {
                throw (RuntimeException)re;
            }
            throw new RuntimeException(re);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GenericInterceptorFactory)) {
            return false;
        }
        return this.classname.equals(((GenericInterceptorFactory)obj).classname);
    }
}

