/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop;

import java.lang.reflect.Constructor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;

public class AdvisorFactory {
    protected static final int CLASS = 1;
    protected static final int OTHER_ADVISOR = 1000;
    protected static int advisor = 0;
    protected static Constructor otherAdvisorConstructor;
    private static final Class[] CONSTRUCTOR_SIG;

    public static void initialise(String property) {
        if (AspectManager.verbose) {
            System.out.println("[debug] Passed in advisor: " + property);
        }
        if (property != null) {
            if (property.equals(ClassAdvisor.class.getName())) {
                advisor = 1;
            } else {
                try {
                    Class<?> otherAdvisorClass = Thread.currentThread().getContextClassLoader().loadClass(property);
                    otherAdvisorConstructor = otherAdvisorClass.getConstructor(CONSTRUCTOR_SIG);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Invalid advisor " + property + " was used");
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException(property + " does not have a constructor with the expected signature");
                }
            }
        } else {
            if (AspectManager.verbose) {
                System.out.println("[debug] Defaulting advisor to: " + ClassAdvisor.class.getName());
            }
            advisor = 1;
        }
    }

    public static ClassAdvisor getClassAdvisor(String className, AspectManager am) {
        if (advisor == 1) {
            return new ClassAdvisor(className, am);
        }
        if (otherAdvisorConstructor != null) {
            try {
                return (ClassAdvisor)otherAdvisorConstructor.newInstance(className, am);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("Advisor is not set");
    }

    static {
        CONSTRUCTOR_SIG = new Class[]{String.class, AspectManager.class};
    }
}

