/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.plugins.inflow;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.ejb.EJBMetaData;
import javax.ejb.TransactionAttributeType;
import javax.management.ObjectName;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.EJBProxyFactory;
import org.jboss.ejb3.JBossProxy;
import org.jboss.ejb3.mdb.MDB;
import org.jboss.ejb3.plugins.inflow.JBossMessageEndpointFactoryMBean;
import org.jboss.ejb3.plugins.inflow.MessageInflowLocalProxy;
import org.jboss.invocation.Invocation;
import org.jboss.metadata.InvokerProxyBindingMetaData;
import org.jboss.mx.util.JMXExceptionDecoder;
import org.jboss.proxy.GenericProxyFactory;
import org.jboss.system.ServiceMBeanSupport;

public class JBossMessageEndpointFactory
extends ServiceMBeanSupport
implements EJBProxyFactory,
MessageEndpointFactory,
JBossMessageEndpointFactoryMBean {
    protected boolean trace;
    protected MDB container;
    protected String invokerBinding;
    protected InvokerProxyBindingMetaData invokerMetaData;
    protected HashMap properties;
    protected GenericProxyFactory proxyFactory;
    protected Class messagingTypeClass;
    protected String resourceAdapterName;
    protected ObjectName resourceAdapterObjectName;
    protected ActivationSpec activationSpec;
    protected ArrayList interceptors;
    protected Class[] interfaces;
    protected SynchronizedInt nextProxyId;
    protected String[] createActivationSpecSig;
    protected String[] activationSig;

    public JBossMessageEndpointFactory() {
        this.trace = this.log.isTraceEnabled();
        this.properties = new HashMap();
        this.proxyFactory = new GenericProxyFactory();
        this.nextProxyId = new SynchronizedInt(0);
        this.createActivationSpecSig = new String[]{Class.class.getName(), Collection.class.getName()};
        this.activationSig = new String[]{MessageEndpointFactory.class.getName(), ActivationSpec.class.getName()};
    }

    public MDB getContainer() {
        return this.container;
    }

    public String getConfig() {
        return this.toString();
    }

    public MessageEndpoint createEndpoint(XAResource resource) throws UnavailableException {
        this.trace = this.log.isTraceEnabled();
        if (this.getState() != 3 && this.getState() != 2) {
            throw new UnavailableException("The container is not started");
        }
        if (this.trace) {
            this.log.trace((Object)("createEndpoint " + this + " xaResource=" + resource));
        }
        MessageEndpoint endpoint = this.createProxy(resource);
        if (this.trace) {
            this.log.trace((Object)("Created endpoint " + endpoint + " from " + this));
        }
        return endpoint;
    }

    protected MessageEndpoint createProxy(XAResource resource) {
        try {
            Class<?> proxyClass = Proxy.getProxyClass(this.container.getBeanClass().getClassLoader(), this.interfaces);
            Class[] constructorParams = new Class[]{InvocationHandler.class};
            Constructor<?> proxyConstructor = proxyClass.getConstructor(constructorParams);
            MessageInflowLocalProxy proxy = new MessageInflowLocalProxy(this.container);
            proxy.setXaResource(resource);
            proxy.setMessageEndpointFactory(this);
            Object[] args = new Object[]{proxy};
            MessageEndpoint endpoint = (MessageEndpoint)proxyConstructor.newInstance(args);
            return endpoint;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean isDeliveryTransacted(Method method) throws NoSuchMethodException {
        boolean result = false;
        TransactionAttributeType type = this.container.getTransactionAttributeType();
        if (type == TransactionAttributeType.REQUIRED) {
            // empty if block
        }
        result = true;
        return result;
    }

    protected void startService() throws Exception {
        this.resolveMessageListener();
        this.resolveResourceAdapter();
        this.createActivationSpec();
        this.setupProxyParameters();
        this.activate();
    }

    protected void stopService() throws Exception {
        this.deactivate();
    }

    public boolean isIdentical(Container container, Invocation mi) {
        throw new Error("Not valid for MessageDriven beans");
    }

    public Object getEJBHome() {
        throw new Error("Not valid for MessageDriven beans");
    }

    public EJBMetaData getEJBMetaData() {
        throw new Error("Not valid for MessageDriven beans");
    }

    public Collection getEntityCollection(Collection c) {
        throw new Error("Not valid for MessageDriven beans");
    }

    public Object getEntityEJBObject(Object id) {
        throw new Error("Not valid for MessageDriven beans");
    }

    public Object getStatefulSessionEJBObject(Object id) {
        throw new Error("Not valid for MessageDriven beans");
    }

    public Object getStatelessSessionEJBObject() {
        throw new Error("Not valid for MessageDriven beans");
    }

    public void setInvokerBinding(String binding) {
        this.invokerBinding = binding;
    }

    public void setInvokerMetaData(InvokerProxyBindingMetaData imd) {
        this.invokerMetaData = imd;
    }

    public void setContainer(Container container) {
        this.container = (MDB)container;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(100);
        buffer.append(super.toString());
        buffer.append("{ resourceAdapter=").append(this.resourceAdapterObjectName);
        buffer.append(", messagingType=").append(this.container.getMessagingType());
        buffer.append(", ejbName=").append(this.container.getEjbName());
        buffer.append(", activationConfig=").append(this.properties.values());
        buffer.append(", activationSpec=").append(this.activationSpec);
        buffer.append("}");
        return buffer.toString();
    }

    protected void resolveMessageListener() throws DeploymentException {
        String messagingType = this.container.getMessagingType();
        try {
            this.messagingTypeClass = this.container.getClassloader().loadClass(messagingType);
        }
        catch (Exception e) {
            DeploymentException.rethrowAsDeploymentException((String)("Could not load messaging-type class " + messagingType), (Throwable)e);
        }
    }

    protected String resolveResourceAdapterName() throws DeploymentException {
        return this.container.getResourceAdaptorName();
    }

    protected void resolveResourceAdapter() throws DeploymentException {
        this.resourceAdapterName = this.resolveResourceAdapterName();
        try {
            this.resourceAdapterObjectName = new ObjectName("jboss.jca:service=RARDeployment,name='" + this.resourceAdapterName + "'");
            int state = (Integer)this.server.getAttribute(this.resourceAdapterObjectName, "State");
            if (state != 3) {
                throw new DeploymentException("The resource adapter is not started " + this.resourceAdapterName);
            }
        }
        catch (Exception e) {
            DeploymentException.rethrowAsDeploymentException((String)("Cannot locate resource adapter deployment " + this.resourceAdapterName), (Throwable)e);
        }
    }

    protected void setupProxyParameters() throws Exception {
        this.interfaces = new Class[]{MessageEndpoint.class, this.messagingTypeClass, JBossProxy.class};
    }

    protected void augmentActivationConfigProperties() throws DeploymentException {
        String jndiName = this.container.getDestination();
        if (jndiName != null) {
            this.properties.put("destination", jndiName);
        }
    }

    protected void createActivationSpec() throws DeploymentException {
        this.properties = new HashMap(this.container.getActivationConfigProperties());
        this.augmentActivationConfigProperties();
        Object[] params = new Object[]{this.messagingTypeClass, this.properties.values()};
        try {
            this.activationSpec = (ActivationSpec)this.server.invoke(this.resourceAdapterObjectName, "createActivationSpec", params, this.createActivationSpecSig);
        }
        catch (Throwable t) {
            t = JMXExceptionDecoder.decode((Throwable)t);
            DeploymentException.rethrowAsDeploymentException((String)("Unable to create activation spec ra=" + this.resourceAdapterObjectName + " messaging-type=" + this.messagingTypeClass.getName() + " properties=" + this.container.getActivationConfigProperties()), (Throwable)t);
        }
    }

    protected void activate() throws DeploymentException {
        Object[] params = new Object[]{this, this.activationSpec};
        try {
            this.server.invoke(this.resourceAdapterObjectName, "endpointActivation", params, this.activationSig);
        }
        catch (Throwable t) {
            t = JMXExceptionDecoder.decode((Throwable)t);
            DeploymentException.rethrowAsDeploymentException((String)("Endpoint activation failed ra=" + this.resourceAdapterObjectName + " activationSpec=" + this.activationSpec), (Throwable)t);
        }
    }

    protected void deactivate() {
    }
}

