/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.injection.pojo;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.annotation.Resource;
import javax.ejb.EJBContext;
import javax.ejb.TimerService;
import javax.naming.NamingException;
import javax.transaction.UserTransaction;
import org.jboss.ejb3.BeanContext;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.injection.pojo.InjectionHelper;
import org.jboss.ejb3.injection.pojo.PojoInjector;
import org.jboss.ejb3.tx.UserTransactionImpl;

public class ResourceInjector
implements PojoInjector {
    private Container container;
    private BeanContext ctx;

    public ResourceInjector(Container container, BeanContext ctx) {
        this.container = container;
        this.ctx = ctx;
    }

    public void inject(Method m, Annotation annotation, Object pojo) {
        InjectionHelper.checkMethodSignature(m, annotation);
        Resource ref = (Resource)annotation;
        Object obj = null;
        obj = this.getResource(m.getParameterTypes()[0], m.getName().substring(3), ref);
        try {
            m.invoke(pojo, obj);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Object getResource(Class type, String defaultEncName, Resource ref) {
        Object obj;
        String encName;
        if (!ref.type().equals(Object.class)) {
            type = ref.type();
        }
        if ((encName = ref.name()) == null || encName.equals("")) {
            encName = defaultEncName;
        }
        if (type.equals(UserTransaction.class)) {
            obj = new UserTransactionImpl();
        } else if (type.equals(TimerService.class)) {
            obj = this.container.getTimerService();
        } else if (EJBContext.class.isAssignableFrom(type)) {
            obj = this.ctx.getEJBContext();
        } else {
            String jndiName = ref.name();
            if (jndiName == null || jndiName.equals("")) {
                jndiName = defaultEncName;
            }
            try {
                obj = this.container.getInitialContext().lookup(jndiName);
            }
            catch (NamingException e) {
                jndiName = "java:/" + jndiName;
                try {
                    obj = this.container.getInitialContext().lookup(jndiName);
                }
                catch (NamingException e1) {
                    throw new RuntimeException(e1);
                }
            }
        }
        return obj;
    }

    public void inject(Field f, Annotation annotation, Object pojo) {
        Resource ref = (Resource)annotation;
        Object obj = this.getResource(f.getType(), f.getName(), ref);
        try {
            f.setAccessible(true);
            f.set(pojo, obj);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

