/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.injection;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnit;
import javax.persistence.PersistenceUnits;
import org.hibernate.SessionFactory;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.entity.EntityManagerDeployment;
import org.jboss.ejb3.entity.InjectedEntityManager;
import org.jboss.ejb3.entity.InjectedEntityManagerFactory;
import org.jboss.ejb3.entity.InjectedSessionFactory;
import org.jboss.ejb3.entity.ManagedEntityManagerFactory;
import org.jboss.ejb3.injection.EntityManagerFactoryFieldInjector;
import org.jboss.ejb3.injection.EntityManagerFactoryMethodInjector;
import org.jboss.ejb3.injection.InjectionUtil;
import org.jboss.ejb3.interceptor.InterceptorInjector;
import org.jboss.naming.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceUnitHandler {
    private static void loadPUsAnnotation(Container container, Class clazz, boolean isContainer) throws Exception {
        PersistenceUnits resources = (PersistenceUnits)InjectionUtil.getAnnotation(PersistenceUnits.class, (EJBContainer)container, clazz, isContainer);
        if (resources == null) {
            return;
        }
        for (PersistenceUnit ref : resources.value()) {
            String encName = ref.name();
            if (encName == null || encName.equals("")) {
                throw new RuntimeException("JBoss requires name() for class level @PersistenceUnit");
            }
            EntityManagerFactory factory = PersistenceUnitHandler.getEntityManagerFactory(ref, container);
            PersistenceUnitHandler.bindEntityManagerFactoryToEnc(container, encName, factory);
        }
        PersistenceUnit pu = (PersistenceUnit)InjectionUtil.getAnnotation(PersistenceUnit.class, (EJBContainer)container, clazz, isContainer);
        if (pu != null) {
            String encName = pu.name();
            if (encName == null || encName.equals("")) {
                throw new RuntimeException("JBoss requires name() for class level @PersistenceUnit");
            }
            ManagedEntityManagerFactory factory = PersistenceUnitHandler.getManagedEntityManagerFactory(pu, container);
            PersistenceUnitHandler.bindEntityManagerToEnc(container, factory, encName);
        }
    }

    private static void loadClassPUDependencies(Container container, Class clazz, boolean isContainer) {
        PersistenceUnits resources = (PersistenceUnits)InjectionUtil.getAnnotation(PersistenceUnits.class, (EJBContainer)container, clazz, isContainer);
        if (resources == null) {
            return;
        }
        for (PersistenceUnit ref : resources.value()) {
            String encName = ref.name();
            if (encName == null || encName.equals("")) {
                throw new RuntimeException("JBoss requires name() for class level @PersistenceUnit");
            }
            PersistenceUnitHandler.addPUDependency(ref.unitName(), (EJBContainer)container);
        }
        PersistenceUnit pu = (PersistenceUnit)InjectionUtil.getAnnotation(PersistenceUnit.class, (EJBContainer)container, clazz, isContainer);
        if (pu != null) {
            String encName = pu.name();
            if (encName == null || encName.equals("")) {
                throw new RuntimeException("JBoss requires name() for class level @PersistenceUnit");
            }
            PersistenceUnitHandler.addPUDependency(pu.unitName(), (EJBContainer)container);
        }
    }

    public static void addPUDependency(String unitName, EJBContainer container) {
        EntityManagerDeployment deployment = container.getDeployment().getEntityManagerDeployment(unitName);
        if (deployment != null) {
            container.getDependencyPolicy().addDependency(deployment.getKernelName());
            return;
        }
        container.getDependencyPolicy().addDependency(EntityManagerDeployment.getGlobalEntityManagerKernelName(unitName));
    }

    private static ManagedEntityManagerFactory getManagedEntityManagerFactory(PersistenceUnit ref, Container container) throws NamingException {
        String unitName = ref.unitName();
        return PersistenceUnitHandler.getManagedEntityManagerFactory(container, unitName);
    }

    public static ManagedEntityManagerFactory getManagedEntityManagerFactory(Container container, String unitName) throws NamingException {
        ManagedEntityManagerFactory factory;
        EntityManagerDeployment deployment = ((EJBContainer)container).getDeployment().getEntityManagerDeployment(unitName);
        if (deployment != null) {
            factory = deployment.getManagedFactory();
        } else {
            InitialContext ctx = container.getInitialContext();
            String jndiName = EntityManagerDeployment.getManagedEntityFactoryJndiName(unitName);
            factory = (ManagedEntityManagerFactory)ctx.lookup(jndiName);
        }
        return factory;
    }

    private static EntityManagerFactory getEntityManagerFactory(PersistenceUnit ref, Container container) throws NamingException {
        String jndiName;
        EntityManagerFactory factory;
        EntityManagerDeployment deployment = ((EJBContainer)container).getDeployment().getEntityManagerDeployment(ref.unitName());
        if (deployment != null) {
            factory = deployment.getActualFactory();
            jndiName = deployment.getScopedActualJndiName();
        } else {
            InitialContext ctx = container.getInitialContext();
            jndiName = EntityManagerDeployment.getActualEntityManagerFactoryJndiName(ref.unitName());
            factory = (EntityManagerFactory)ctx.lookup(jndiName);
        }
        return new InjectedEntityManagerFactory(factory, jndiName, container.getInitialContextProperties());
    }

    private static SessionFactory getSessionFactory(PersistenceUnit ref, Container container) throws NamingException {
        String jndiName;
        EntityManagerFactory factory;
        EntityManagerDeployment deployment = ((EJBContainer)container).getDeployment().getEntityManagerDeployment(ref.unitName());
        if (deployment != null) {
            factory = deployment.getActualFactory();
            jndiName = deployment.getScopedActualJndiName();
        } else {
            InitialContext ctx = container.getInitialContext();
            jndiName = EntityManagerDeployment.getActualEntityManagerFactoryJndiName(ref.unitName());
            factory = (EntityManagerFactory)ctx.lookup(jndiName);
        }
        return new InjectedSessionFactory(factory, jndiName, container.getInitialContextProperties());
    }

    public static List loadInjectors(Container container) throws Exception {
        Class clazz = container.getBeanClass();
        return PersistenceUnitHandler.loadInjectors((EJBContainer)container, clazz, true);
    }

    public static List loadInjectors(InterceptorInjector injector) throws Exception {
        return PersistenceUnitHandler.loadInjectors((EJBContainer)injector.getContainer(), injector.getClazz(), false);
    }

    public static void loadDependencies(EJBContainer container, Class clazz, boolean isContainer) {
        PersistenceUnitHandler.loadClassPUDependencies(container, clazz, isContainer);
        HashSet<String> visitedMethods = new HashSet<String>();
        PersistenceUnitHandler.loadMethodDependencies(visitedMethods, container, clazz, isContainer);
        PersistenceUnitHandler.loadFieldDependencies(clazz, container, isContainer);
    }

    public static List loadInjectors(EJBContainer container, Class clazz, boolean isContainer) throws Exception {
        ArrayList list = new ArrayList();
        Context resourceCtx = Util.createSubcontext((Context)container.getInitialContext(), (String)"java:comp.ejb3/env/resource");
        HashSet<String> visitedMethods = new HashSet<String>();
        PersistenceUnitHandler.loadPUsAnnotation(container, clazz, isContainer);
        PersistenceUnitHandler.loadMethodInjectors(visitedMethods, container, clazz, list, resourceCtx, isContainer);
        PersistenceUnitHandler.loadFieldInjectors(clazz, container, list, resourceCtx, isContainer);
        return list;
    }

    private static void bindEntityManagerFactoryToEnc(Container container, String encName, Object factory) throws NamingException {
        Context entityCtx = Util.createSubcontext((Context)container.getInitialContext(), (String)"java:comp.ejb3/env");
        Util.bind((Context)container.getEnc(), (String)encName, (Object)factory);
    }

    private static void bindEntityManagerToEnc(Container container, ManagedEntityManagerFactory factory, String encName) throws NamingException {
        InjectedEntityManager entityManager = new InjectedEntityManager(factory, container.getInitialContextProperties());
        Util.bind((Context)container.getEnc(), (String)encName, (Object)entityManager);
    }

    public static void loadMethodInjectors(HashSet<String> visitedMethods, EJBContainer container, Class clazz, ArrayList list, Context resourceCtx, boolean isContainer) throws Exception {
        if (clazz != null && !clazz.equals(Object.class)) {
            PersistenceUnitHandler.loadMethodInjectors(visitedMethods, container, clazz.getSuperclass(), list, resourceCtx, isContainer);
        }
        Method[] methods = clazz.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            EntityManagerFactory factory;
            PersistenceUnit ref = (PersistenceUnit)InjectionUtil.getAnnotation(PersistenceUnit.class, container, methods[i], isContainer);
            if (ref == null) continue;
            if (!Modifier.isPrivate(methods[i].getModifiers())) {
                if (visitedMethods.contains(methods[i].getName())) continue;
                visitedMethods.add(methods[i].getName());
            }
            if (!methods[i].getName().startsWith("set")) {
                throw new RuntimeException("@PersistenceContext can only be used with a set method: " + methods[i]);
            }
            if (methods[i].getParameterTypes().length != 1) {
                throw new RuntimeException("@PersistenceContext can only be used with a set method of one parameter: " + methods[i]);
            }
            String encName = ref.name();
            if (encName == null || encName.equals("")) {
                encName = InjectionUtil.getEncName(methods[i]);
            }
            if (methods[i].getParameterTypes()[0].getName().equals(EntityManagerFactory.class.getName())) {
                factory = PersistenceUnitHandler.getEntityManagerFactory(ref, container);
                list.add(new EntityManagerFactoryMethodInjector(methods[i], container, factory));
                PersistenceUnitHandler.bindEntityManagerFactoryToEnc(container, encName, factory);
                continue;
            }
            factory = PersistenceUnitHandler.getSessionFactory(ref, container);
            list.add(new EntityManagerFactoryMethodInjector(methods[i], container, factory));
            PersistenceUnitHandler.bindEntityManagerFactoryToEnc(container, encName, factory);
        }
    }

    public static void loadMethodDependencies(HashSet<String> visitedMethods, EJBContainer container, Class clazz, boolean isContainer) {
        if (clazz != null && !clazz.equals(Object.class)) {
            PersistenceUnitHandler.loadMethodDependencies(visitedMethods, container, clazz.getSuperclass(), isContainer);
        }
        Method[] methods = clazz.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            PersistenceUnit ref = (PersistenceUnit)InjectionUtil.getAnnotation(PersistenceUnit.class, container, methods[i], isContainer);
            if (ref == null) continue;
            if (!Modifier.isPrivate(methods[i].getModifiers())) {
                if (visitedMethods.contains(methods[i].getName())) continue;
                visitedMethods.add(methods[i].getName());
            }
            PersistenceUnitHandler.addPUDependency(ref.unitName(), container);
        }
    }

    private static void loadFieldDependencies(Class clazz, EJBContainer container, boolean isContainer) {
        if (clazz == null || clazz.equals(Object.class)) {
            return;
        }
        PersistenceUnitHandler.loadFieldDependencies(clazz.getSuperclass(), container, isContainer);
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            PersistenceUnit ref = (PersistenceUnit)InjectionUtil.getAnnotation(PersistenceUnit.class, container, fields[i], isContainer);
            if (ref == null) continue;
            PersistenceUnitHandler.addPUDependency(ref.unitName(), container);
        }
    }

    private static void loadFieldInjectors(Class clazz, EJBContainer container, ArrayList list, Context resourceCtx, boolean isContainer) throws Exception {
        if (clazz == null || clazz.equals(Object.class)) {
            return;
        }
        PersistenceUnitHandler.loadFieldInjectors(clazz.getSuperclass(), container, list, resourceCtx, isContainer);
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            EntityManagerFactory factory;
            PersistenceUnit ref = (PersistenceUnit)InjectionUtil.getAnnotation(PersistenceUnit.class, container, fields[i], isContainer);
            if (ref == null) continue;
            fields[i].setAccessible(true);
            String encName = ref.name();
            if (encName == null || encName.equals("")) {
                encName = InjectionUtil.getEncName(fields[i]);
            }
            if (fields[i].getType().getName().equals(EntityManagerFactory.class.getName())) {
                factory = PersistenceUnitHandler.getEntityManagerFactory(ref, container);
                list.add(new EntityManagerFactoryFieldInjector(fields[i], container, factory));
                PersistenceUnitHandler.bindEntityManagerFactoryToEnc(container, encName, factory);
                continue;
            }
            factory = PersistenceUnitHandler.getSessionFactory(ref, container);
            list.add(new EntityManagerFactoryFieldInjector(fields[i], container, factory));
            PersistenceUnitHandler.bindEntityManagerFactoryToEnc(container, encName, factory);
        }
    }
}

