/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.injection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.persistence.PersistenceContextType;
import javax.persistence.Transient;
import org.jboss.ejb3.BeanContext;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.entity.ManagedEntityManagerFactory;
import org.jboss.ejb3.injection.EntityManagerInjector;

public class EntityManagerMethodInjector
extends EntityManagerInjector {
    private Method setMethod;

    public EntityManagerMethodInjector(Method setMethod, Container container, ManagedEntityManagerFactory factory, PersistenceContextType type) {
        super(container, factory, type);
        this.setMethod = setMethod;
    }

    public void inject(BeanContext ctx) {
        this.inject(ctx, ctx.getInstance());
    }

    public void inject(BeanContext ctx, Object instance) {
        try {
            boolean isTransient = ((EJBContainer)this.container).resolveAnnotation(this.setMethod, Transient.class) != null;
            Object entityManager = this.getEntityManager(ctx, isTransient, this.setMethod.getParameterTypes()[0]);
            Object[] args = new Object[]{entityManager};
            this.setMethod.invoke(instance, args);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Failed in setting EntityManager on setter method: " + this.setMethod.toString());
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
    }
}

