/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.injection;

import java.lang.reflect.Field;
import javax.persistence.PersistenceContextType;
import javax.persistence.Transient;
import org.jboss.ejb3.BeanContext;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.entity.ManagedEntityManagerFactory;
import org.jboss.ejb3.injection.EntityManagerInjector;

public class EntityManagerFieldInjector
extends EntityManagerInjector {
    protected Field field;

    public EntityManagerFieldInjector(Field field, Container container, ManagedEntityManagerFactory factory, PersistenceContextType type) {
        super(container, factory, type);
        this.field = field;
        this.field.setAccessible(true);
    }

    public void inject(BeanContext ctx) {
        this.inject(ctx, ctx.getInstance());
    }

    public void inject(BeanContext ctx, Object instance) {
        try {
            Object entityManager = null;
            boolean isTransient = ((EJBContainer)this.container).resolveAnnotation(this.field, Transient.class) != null;
            entityManager = this.getEntityManager(ctx, isTransient, this.field.getType());
            this.field.set(instance, entityManager);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Failed in setting EntityManager on setter field: " + this.field.toString());
        }
    }
}

