/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.entity;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.PersistenceContextType;
import javax.persistence.Query;
import org.hibernate.Session;
import org.hibernate.ejb.HibernateEntityManager;
import org.jboss.ejb3.EJB3Util;
import org.jboss.ejb3.entity.ExtendedPersistenceContext;
import org.jboss.ejb3.entity.HibernateSession;
import org.jboss.ejb3.entity.ManagedEntityManagerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedEntityManager
implements EntityManager,
HibernateSession,
Externalizable,
ExtendedPersistenceContext {
    private EntityManager persistenceContext;
    private transient ManagedEntityManagerFactory factory;
    private boolean isTransient = false;
    private Hashtable initialContextProperties;

    public ExtendedEntityManager(boolean isTransient, ManagedEntityManagerFactory factory, Hashtable initialContextProperties) {
        this(isTransient, factory, initialContextProperties, factory.createEntityManager(PersistenceContextType.EXTENDED));
    }

    public ExtendedEntityManager(boolean isTransient, ManagedEntityManagerFactory factory, Hashtable initialContextProperties, EntityManager pc) {
        this.isTransient = isTransient;
        this.factory = factory;
        this.persistenceContext = pc;
        this.initialContextProperties = initialContextProperties;
    }

    public ExtendedEntityManager() {
    }

    @Override
    public ManagedEntityManagerFactory getFactory() {
        return this.factory;
    }

    @Override
    public EntityManager getPersistenceContext() {
        return this.persistenceContext;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this.isTransient);
        out.writeObject(this.initialContextProperties);
        out.writeUTF(this.factory.getJndiName());
        if (!this.isTransient) {
            out.writeObject(this.persistenceContext);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.isTransient = in.readBoolean();
        try {
            this.initialContextProperties = (Hashtable)in.readObject();
            InitialContext ctx = EJB3Util.getInitialContext(this.initialContextProperties);
            String jndiName = in.readUTF();
            this.factory = (ManagedEntityManagerFactory)ctx.lookup(jndiName);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        this.persistenceContext = !this.isTransient ? (EntityManager)in.readObject() : this.factory.createEntityManager(PersistenceContextType.EXTENDED);
    }

    @Override
    public Session getHibernateSession() {
        if (this.persistenceContext instanceof HibernateEntityManager) {
            return ((HibernateEntityManager)this.persistenceContext).getSession();
        }
        throw new RuntimeException("ILLEGAL ACTION:  Not a Hibernate persistence provider");
    }

    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        return (T)this.persistenceContext.getReference(entityClass, primaryKey);
    }

    public void persist(Object entity) {
        this.persistenceContext.persist(entity);
    }

    public <T> T merge(T entity) {
        return (T)this.persistenceContext.merge(entity);
    }

    public void remove(Object entity) {
        this.persistenceContext.remove(entity);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey) {
        return (T)this.persistenceContext.find(entityClass, primaryKey);
    }

    public void flush() {
        this.persistenceContext.flush();
    }

    public Query createQuery(String ejbqlString) {
        return this.persistenceContext.createQuery(ejbqlString);
    }

    public Query createNamedQuery(String name) {
        return this.persistenceContext.createNamedQuery(name);
    }

    public Query createNativeQuery(String sqlString) {
        return this.persistenceContext.createNativeQuery(sqlString);
    }

    public Query createNativeQuery(String sqlString, Class resultClass) {
        return this.persistenceContext.createNativeQuery(sqlString, resultClass);
    }

    public Query createNativeQuery(String sqlString, String resultSetMapping) {
        return this.persistenceContext.createNativeQuery(sqlString, resultSetMapping);
    }

    public void refresh(Object entity) {
        this.persistenceContext.refresh(entity);
    }

    public boolean contains(Object entity) {
        return this.persistenceContext.contains(entity);
    }

    public void close() {
        throw new IllegalStateException("It is illegal to close an injected EntityManager");
    }

    public boolean isOpen() {
        return this.persistenceContext.isOpen();
    }

    public EntityTransaction getTransaction() {
        return this.persistenceContext.getTransaction();
    }

    public void setFlushMode(FlushModeType flushMode) {
        this.persistenceContext.setFlushMode(flushMode);
    }

    @Override
    public void closeExtendedPersistenceContext() {
        this.persistenceContext.close();
    }
}

